/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import org.apache.commons.collections.CollectionUtils;

public class TaskExecutorUpgradeServiceImpl
implements IUpgradeService {
    private static final DBRoute DB_EPM = DBRoute.of((String)"epm");
    private static final String PLANT_KEY = "TaskExecutorUpgradeService";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)PLANT_KEY);){
            StringBuilder upgradeLog;
            if (!UpdateRecordHelper.isUpdated((String)PLANT_KEY)) {
                if (this.checkNeedAppendExecutors()) {
                    upgradeLog = this.upgrade();
                    result.setLog(upgradeLog.toString());
                    UpdateRecordHelper.addRecord((String)PLANT_KEY, (String)upgradeLog.toString(), null, (boolean)true);
                } else {
                    result.setLog("executors don't need upgrade.");
                }
            } else {
                result.setLog("this script had invoke.");
            }
            result.setSuccess(true);
            upgradeLog = result;
            return upgradeLog;
        }
        catch (Exception e) {
            result.setSuccess(false);
            StackTraceElement[] arr = e.getStackTrace();
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement ele : arr) {
                sb.append(ele.toString()).append("\r\n");
            }
            result.setLog(e.getMessage());
            result.setErrorInfo(sb.toString());
            tx.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return result;
    }

    public StringBuilder upgrade() {
        StringBuilder upgradeLog = new StringBuilder("upgrade success. ");
        upgradeLog.append(this.upgradeExecutors("t_eb_tasksave", "t_eb_tasksave_executors"));
        upgradeLog.append(this.upgradeExecutors("t_eb_taskdistorg", "t_eb_taskorg_executors"));
        upgradeLog.append(this.upgradeExecutors("t_eb_taskprocess", "t_eb_taskproces_executors"));
        return upgradeLog;
    }

    public String upgradeExecutors(String tableName, String executorTable) {
        String sql = "select fid,fexecutorid from " + tableName + " where fexecutorid is not null and fexecutorid != 0";
        DataSet ds = DB.queryDataSet((String)("upgradeExecutors" + tableName), (DBRoute)DB_EPM, (String)sql, null);
        ArrayList executors = Lists.newArrayListWithExpectedSize((int)8192);
        while (ds != null && ds.hasNext()) {
            Row row = ds.next();
            long id = row.getLong("fid");
            long executor = row.getLong("fexecutorid");
            Object[] data = new Object[]{0L, id, executor};
            executors.add(data);
        }
        if (CollectionUtils.isNotEmpty((Collection)executors)) {
            long[] ids = GlobalIdUtil.genGlobalLongIds((int)executors.size());
            for (int i = 0; i < executors.size(); ++i) {
                ((Object[])executors.get((int)i))[0] = ids[i];
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)executors)) {
            String backupSql = "insert into " + executorTable + "(fpkid,fid,fbasedataid) values(?,?,?)";
            DB.executeBatch((DBRoute)DB_EPM, (String)backupSql, (List)executors);
            return tableName + " insert executors " + executors.size() + ";";
        }
        return tableName + "  executors is empty;";
    }

    private boolean checkNeedAppendExecutors() {
        String sql1 = "select fid from t_eb_tasksave where fexecutorid is not null and fexecutorid != 0";
        String sql2 = "select fid from t_eb_taskdistorg where fexecutorid is not null and fexecutorid != 0";
        String sql3 = "select fid from t_eb_taskprocess where fexecutorid is not null and fexecutorid != 0";
        return (Boolean)DB.query((DBRoute)DB_EPM, (String)sql1, ResultSet::next) != false || (Boolean)DB.query((DBRoute)DB_EPM, (String)sql2, ResultSet::next) != false || (Boolean)DB.query((DBRoute)DB_EPM, (String)sql3, ResultSet::next) != false;
    }
}

