/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class TaskMonitorUpgradeServiceImpl
implements IUpgradeService {
    private static final DBRoute DB_EPM = DBRoute.of((String)"epm");
    private static final String PLANT_KEY = "TaskMonitorUpgradeService";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)PLANT_KEY);){
            StringBuilder upgradeLog;
            if (!UpdateRecordHelper.isUpdated((String)PLANT_KEY)) {
                if (this.checkNeedUpgrade()) {
                    upgradeLog = this.upgrade();
                    result.setLog(upgradeLog.toString());
                    UpdateRecordHelper.addRecord((String)PLANT_KEY, (String)upgradeLog.toString(), null, (boolean)true);
                } else {
                    result.setLog("don't need upgrade.");
                }
            } else {
                result.setLog("this script had invoke.");
            }
            result.setSuccess(true);
            upgradeLog = result;
            return upgradeLog;
        }
        catch (Exception e) {
            result.setSuccess(false);
            StackTraceElement[] arr = e.getStackTrace();
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement ele : arr) {
                sb.append(ele.toString()).append("\r\n");
            }
            result.setLog(e.getMessage());
            result.setErrorInfo(sb.toString());
            tx.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return result;
    }

    public StringBuilder upgrade() {
        StringBuilder stringBuilder = new StringBuilder("upgrade success. ");
        Set<Long> subTaskIds = this.getSubTaskOfHasPreTasks();
        stringBuilder.append("SubTaskOfHasPreTasks size").append(subTaskIds.size()).append(";");
        this.setSubTaskMonitorDefaultValue(subTaskIds);
        return stringBuilder;
    }

    private void setSubTaskMonitorDefaultValue(Set<Long> subTaskIds) {
        if (subTaskIds.size() > 0) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("update t_eb_task set fmoniop='1',fpretaskstatus ='1' where ", new Object[0]);
            sql.appendIn("fid", subTaskIds.toArray());
            DB.execute((DBRoute)DB_EPM, (SqlBuilder)sql);
        }
    }

    private Set<Long> getSubTaskOfHasPreTasks() {
        HashSet<Long> taskIds = new HashSet<Long>(16);
        String sql = "select fid,fbasedataid from t_eb_taskrely where fbasedataid != 0 and fbasedataid is not null";
        DataSet ds = DB.queryDataSet((String)"getSubTaskOfHasPreTasks", (DBRoute)DB_EPM, (String)sql);
        while (ds != null && ds.hasNext()) {
            Row row = ds.next();
            Long subTaskId = row.getLong("fid");
            Long baseDataId = row.getLong("fbasedataid");
            if (!IDUtils.isNotEmptyLong((Long)subTaskId).booleanValue() && !IDUtils.isNotEmptyLong((Long)baseDataId).booleanValue()) continue;
            taskIds.add(subTaskId);
        }
        return taskIds;
    }

    private boolean checkNeedUpgrade() {
        String sql1 = "select fid from t_eb_taskrely where fbasedataid != 0 and fbasedataid is not null";
        return (Boolean)DB.query((DBRoute)DB_EPM, (String)sql1, ResultSet::next);
    }
}

