/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.epm.eb.business.servicehelper.EbBatchSave;
import kd.epm.eb.business.servicehelper.EbOlapServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.service.template.TemplateExportAndImportService;

public class TemplateExportAndImportServiceImpl
implements TemplateExportAndImportService {
    public void saveOlapData(List<Map<String, String>> dimlist, long modelId, String modelNumber) {
        if (dimlist == null || dimlist.isEmpty() || modelId == 0L || modelNumber == null) {
            return;
        }
        EbBatchSave batchSave = EbOlapServiceHelper.getBatchSave();
        SaveCommandInfo saveCommandInfo = null;
        BgData bgData = null;
        String value = null;
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensions = cacheHelper.getDimensionList();
        ArrayList<String> dimesnionNums = new ArrayList<String>(dimensions.size());
        for (Dimension dimension : dimensions) {
            dimesnionNums.add(dimension.getNumber());
        }
        try {
            saveCommandInfo = new SaveCommandInfo();
            saveCommandInfo.addDimensions(cacheHelper.getModelobj().getDimensionNums());
            saveCommandInfo.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            batchSave.open(modelNumber, saveCommandInfo);
            for (Map map : dimlist) {
                value = (String)map.get(FacTabFieldDefEnum.FIELD_MONEY.getField());
                if (value == null) continue;
                bgData = new BgData(Long.valueOf(modelId), map);
                try {
                    batchSave.add(dimesnionNums, bgData, (Object)new BigDecimal(value));
                }
                catch (Exception ex) {
                    batchSave.add(dimesnionNums, bgData, (Object)value);
                }
            }
            batchSave.flush();
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadResFormat((String)"OLAP\u4fdd\u5b58\u5931\u8d25\u201c%1\u201d\u3002", (String)"AdjustExternalInvokeServiceImpl_64", (String)"epm-eb-mservice", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            batchSave.close();
        }
    }
}

