/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class VersionDataValidationRecordUpServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(VersionDataValidationRecordUpServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"VersionDataValidationRecordUpServiceImpl");){
            try {
                this.excute();
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    private void excute() {
        String sql = "select tev.fid ,tev .fmodelid ,tev.fbusinessmodel ,tev.fentitynum ,teb.fnumber ,tev2.fdimensionid from  t_eb_versioncopyrecord tev \nleft join t_eb_copyrecordentity tec on tev.fid  = tec.fid \nleft join t_eb_businessmodel teb on tev.fbusinessmodel  = teb.fid \nleft join t_eb_viewentry tev2 on tev2.fid = teb.fid \nwhere tev.fschemetype = '1' and tev2.fseq = 1 and tec.fid  is null ";
        DataSet ds = DB.queryDataSet((String)"VersionDataValidationRecordUpServiceImpl", (DBRoute)BgBaseConstant.epm, (String)sql);
        ArrayList recordList = new ArrayList(16);
        String insertSql = "INSERT INTO t_eb_copyrecordentity\n(fid, fentryid, fseq, fentityid, fentity)\nVALUES(?, ?, ?, ?, ?);\n";
        while (ds != null && ds.hasNext()) {
            Row row = ds.next();
            HashMap<String, Object> record = new HashMap<String, Object>(4);
            record.put("id", row.get("fid"));
            record.put("model", row.getLong("fmodelid"));
            record.put("businessmodel", row.getLong("fbusinessmodel"));
            record.put("entitynum", row.getString("fentitynum"));
            record.put("busNumber", row.getString("fnumber"));
            record.put("dimensionid", row.getLong("fdimensionid"));
            if (StringUtils.isEmpty((String)row.getString("fentitynum"))) continue;
            recordList.add(record);
        }
        if (!recordList.isEmpty()) {
            Map<Object, List<Map>> busNumber = recordList.stream().collect(Collectors.groupingBy(map -> map.get("busNumber")));
            Map<Object, List<Map<String, Object>>> model1 = recordList.stream().collect(Collectors.groupingBy(map -> map.get("model")));
            Map<String, List<Map<String, Object>>> modelBizMap = recordList.stream().collect(Collectors.groupingBy(map -> map.get("model") + "_" + map.get("businessmodel")));
            HashMap<String, List<Object>> aunnalBudgetData = new HashMap<String, List<Object>>(16);
            HashMap<String, List<Object>> otherBizModeData = new HashMap<String, List<Object>>(16);
            for (Map.Entry<Object, List<Map>> objectListEntry : busNumber.entrySet()) {
                if (objectListEntry.getKey().equals("AunnalBudget")) {
                    this.getAunnalBudgetData(objectListEntry.getValue(), aunnalBudgetData);
                    continue;
                }
                this.getAunnalBudgetData(objectListEntry.getValue(), aunnalBudgetData);
                this.getOtherBizModelData(objectListEntry.getValue(), otherBizModeData);
            }
            List<ParamsPojo> paramList = this.handleAnnalBudgetData(model1, aunnalBudgetData);
            if (otherBizModeData.size() > 0) {
                this.handleOtherBusinessModelData(modelBizMap, otherBizModeData, paramList);
            }
            if (!paramList.isEmpty()) {
                Set collect = paramList.stream().collect(Collectors.toSet());
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>(collect.size());
                for (ParamsPojo objects : collect) {
                    Object[] param = new Object[]{objects.getId(), GlobalIdUtil.genGlobalLongId(), 0, null, objects.getMemberId()};
                    paramsList.add(param);
                }
                int[] ints = DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)insertSql, paramsList);
                log.info("insert success:" + Arrays.toString(ints));
            }
        }
    }

    private void handleOtherBusinessModelData(Map<String, List<Map<String, Object>>> modelBizMap, Map<String, List<Object>> otherBizModeData, List<ParamsPojo> paramList) {
        StringBuilder memberSql = new StringBuilder("select distinct tes.fmodelid ,tev2 .fid ,tev.fnumber,tev .flongnumber,tev .fmemberid from t_eb_viewmember tev \nleft join t_eb_viewentry tev2 on tev2.fviewid  = tev.fviewid \nleft join t_eb_structofent tes on tes.fdimensionid  = tev2.fdimensionid \nwhere tes.fmodelid   in (");
        List<Object> model = otherBizModeData.get("model");
        for (int i = 0; i < model.size(); ++i) {
            if (i < model.size() - 1) {
                memberSql.append(model.get(i)).append(',');
                continue;
            }
            memberSql.append(model.get(i)).append(") and tev2.fid in ( ");
        }
        List<Object> businessmodel = otherBizModeData.get("businessmodel");
        for (int i = 0; i < businessmodel.size(); ++i) {
            if (i < businessmodel.size() - 1) {
                memberSql.append(businessmodel.get(i)).append(',');
                continue;
            }
            memberSql.append(businessmodel.get(i)).append(')');
        }
        DataSet members = DB.queryDataSet((String)"other", (DBRoute)BgBaseConstant.epm, (String)memberSql.toString());
        while (members != null && members.hasNext()) {
            Row next1 = members.next();
            List<Map<String, Object>> fmodelid = modelBizMap.get(next1.get("fmodelid") + "_" + next1.get("fid"));
            if (fmodelid.isEmpty()) continue;
            for (Map<String, Object> map : fmodelid) {
                if (!StringUtils.isNotEmpty((String)next1.getString("flongnumber")) || map.get("entitynum") == null || !StringUtils.isNotEmpty((String)map.get("entitynum").toString()) || !next1.getString("flongnumber").contains(map.get("entitynum").toString())) continue;
                Long fmemberid = next1.getLong("fmemberid");
                ParamsPojo param = new ParamsPojo();
                param.setId(Long.parseLong(map.get("id").toString()));
                param.setMemberId(fmemberid);
                paramList.add(param);
            }
        }
    }

    @NotNull
    private List<ParamsPojo> handleAnnalBudgetData(Map<Object, List<Map<String, Object>>> model1, Map<String, List<Object>> aunnalBudgetData) {
        ArrayList<ParamsPojo> paramList = new ArrayList<ParamsPojo>(10);
        if (aunnalBudgetData != null && aunnalBudgetData.size() > 0) {
            StringBuilder memberSql = new StringBuilder(" select tes.fid ,tes.flongnumber,tes.fmodelid from  t_eb_structofent tes where tes.fmodelid in ( ");
            List<Object> model = aunnalBudgetData.get("model");
            for (int i = 0; i < model.size(); ++i) {
                if (i < model.size() - 1) {
                    memberSql.append(model.get(i)).append(',');
                    continue;
                }
                memberSql.append(model.get(i)).append(") and (");
            }
            List<Object> entity = aunnalBudgetData.get("entity");
            for (int i = 0; i < entity.size(); ++i) {
                if (i < entity.size() - 1) {
                    memberSql.append("tes.flongnumber  like ").append("'").append(entity.get(i)).append("'").append(" or ");
                    continue;
                }
                memberSql.append("tes.flongnumber  like ").append("'").append(entity.get(i)).append("'").append(')');
            }
            DataSet members = DB.queryDataSet((String)"", (DBRoute)BgBaseConstant.epm, (String)memberSql.toString());
            while (members != null && members.hasNext()) {
                Row next1 = members.next();
                List<Map<String, Object>> fmodelid = model1.get(next1.get("fmodelid"));
                if (fmodelid.isEmpty()) continue;
                for (Map<String, Object> map : fmodelid) {
                    if (!StringUtils.isNotEmpty((String)next1.getString("flongnumber")) || map.get("entitynum") == null || !StringUtils.isNotEmpty((String)map.get("entitynum").toString()) || !next1.getString("flongnumber").contains(map.get("entitynum").toString())) continue;
                    Long fmemberid = next1.getLong("fid");
                    ParamsPojo param = new ParamsPojo();
                    param.setId(Long.parseLong(map.get("id").toString()));
                    param.setMemberId(fmemberid);
                    paramList.add(param);
                }
            }
        }
        return paramList;
    }

    public void getAunnalBudgetData(List<Map<String, Object>> list, Map<String, List<Object>> aunnalBudgetData) {
        List modelList = aunnalBudgetData.getOrDefault("model", new ArrayList(16));
        List entityList = aunnalBudgetData.getOrDefault("entity", new ArrayList(16));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (Map<String, Object> map : list) {
            modelList.add(map.get("model"));
            entityList.add("%" + map.get("entitynum") + "%");
        }
        aunnalBudgetData.put("model", modelList);
        aunnalBudgetData.put("entity", entityList);
    }

    public void getOtherBizModelData(List<Map<String, Object>> list, Map<String, List<Object>> otherBizModeData) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List modelList = otherBizModeData.getOrDefault("model", new ArrayList(16));
        List entityList = otherBizModeData.getOrDefault("entity", new ArrayList(16));
        List bizModel = otherBizModeData.getOrDefault("businessmodel", new ArrayList(16));
        for (Map<String, Object> map : list) {
            modelList.add(map.get("model"));
            entityList.add(map.get("entitynum"));
            bizModel.add(map.get("businessmodel"));
        }
        otherBizModeData.put("model", modelList);
        otherBizModeData.put("entity", entityList);
        otherBizModeData.put("businessmodel", bizModel);
    }

    static class ParamsPojo {
        private Long id;
        private Long memberId;

        ParamsPojo() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getMemberId() {
            return this.memberId;
        }

        public void setMemberId(Long memberId) {
            this.memberId = memberId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParamsPojo that = (ParamsPojo)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.memberId, that.memberId);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.memberId);
        }
    }
}

