/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgBaseConstant;
import org.apache.commons.collections4.CollectionUtils;

public class VersionDataValidationSchemeOrgViewInfoUpServiceImpl
implements IUpgradeService {
    private static final Log loger = LogFactory.getLog(VersionDataValidationSchemeOrgViewInfoUpServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"VersionDataValidationSchemeOrgViewInfoUpServiceImpl");){
            try {
                this.excute();
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    private void excute() {
        String schemeIdSelectSql = "select  tev.fid ,tev.fbusinessmodel  ,tev.fschemename ,tev2.fviewid \nfrom  t_eb_versioncopyscheme tev \nleft join t_eb_model tem  on tev.fmodel  = tem.fid \nleft join t_eb_dimension ted on tev.fmodel  = ted.fmodelid \nleft join t_eb_viewentry tev2 on tev2.fdimensionid  = ted.fid and tev.fbusinessmodel  = tev2.fid \nwhere tev.fschemetype  = '1'  and (tem.freporttype = '7' or tem.freporttype = '6' )\nand ted.fnumber  = 'Entity'   and (tev.forgview  is null or tev.forgview = 0) ";
        DataSet ds = DB.queryDataSet((String)"noOrgViewSchemeQurty", (DBRoute)BgBaseConstant.epm, (String)schemeIdSelectSql);
        ArrayList schemeList = new ArrayList(16);
        loger.info("schemeList:{}", (Object)schemeList.size());
        while (ds.hasNext()) {
            Row next = ds.next();
            HashMap<String, Long> temp = new HashMap<String, Long>(2);
            temp.put("schemeId", next.getLong("fid"));
            temp.put("viewId", next.getLong("fviewid"));
            schemeList.add(temp);
        }
        if (CollectionUtils.isNotEmpty(schemeList)) {
            String updateSql = "update t_eb_versioncopyscheme  set forgview  = ? where fid  = ? ";
            ArrayList<Object[]> params = new ArrayList<Object[]>(16);
            for (Map map : schemeList) {
                Long fid = (Long)map.get("schemeId");
                Long fviewId = (Long)map.get("viewId");
                Object[] objectArray = new Object[]{fviewId, fid};
                params.add(objectArray);
            }
            loger.info("params:{}", params);
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, params);
        }
        String recordQuerySql = "select  tev.fid ,tev2.fviewid \nfrom  t_eb_versioncopyrecord tev \nleft join t_eb_model tem  on tev.fmodelid  = tem.fid \nleft join t_eb_dimension ted on tev.fmodelid  = ted.fmodelid \nleft join t_eb_viewentry tev2 on tev2.fdimensionid  = ted.fid and tev.fbusinessmodel  = tev2.fid \nwhere tev.fschemetype  = '1' and (tem.freporttype = '7' or tem.freporttype = '6' )\nand ted.fnumber  = 'Entity'   and (tev.forgview  is null or tev.forgview = 0) ";
        DataSet record = DB.queryDataSet((String)"noOrgViewRecordQurty", (DBRoute)BgBaseConstant.epm, (String)recordQuerySql);
        ArrayList recordList = new ArrayList(16);
        while (record.hasNext()) {
            Row row = record.next();
            HashMap<String, Long> temp = new HashMap<String, Long>(2);
            temp.put("recordId", row.getLong("fid"));
            temp.put("viewId", row.getLong("fviewid"));
            recordList.add(temp);
        }
        if (CollectionUtils.isNotEmpty(recordList)) {
            String string = "update t_eb_versioncopyrecord  set forgview  = ? where fid  = ? ";
            ArrayList<Object[]> params = new ArrayList<Object[]>(16);
            for (Map map : recordList) {
                Long fid = (Long)map.get("recordId");
                Long fviewId = (Long)map.get("viewId");
                Object[] param = new Object[]{fviewId, fid};
                params.add(param);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)string, params);
        }
    }
}

