/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.addMember;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.ebcommon.common.util.GlobalIdUtil;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import kd.epm.eb.service.addMember.IAddMemberService;

public class AddMemberServiceImpl
implements IAddMemberService {
    private static final String SUCCESS = "success";
    private static final String EXIST = "exist";
    private static final String FAIL = "fail";
    private static final String MODEL_ERROR = "model error";
    private static final String DIMENSION_ERROR = "dimension error";
    private static final Log log = LogFactory.getLog(AddMemberServiceImpl.class);
    private static final String[] fields = new String[]{"number", "name", "parentNumber", "parentName", "modelNumber", "dimensionNumber"};

    public String createMember(Map<String, String> map) {
        log.info("AddMemberServiceImpl-Create-checkParams");
        String msg = this.checkParams(map);
        if (StringUtils.isNotEmpty((String)msg)) {
            return msg;
        }
        String modelNumber = map.get("modelNumber");
        Long modelId = this.getModelId(modelNumber);
        if (modelId == 0L) {
            log.info("AddMemberServiceImpl-Create-model error");
            return MODEL_ERROR;
        }
        String dimensionNumber = map.get("dimensionNumber");
        Long dimensionId = this.getDimensionId(modelId, dimensionNumber);
        if (dimensionId == 0L) {
            log.info("AddMemberServiceImpl-Create-dimension error");
            return DIMENSION_ERROR;
        }
        String number = map.get("number");
        String numberMsg = this.checkNumber(modelId, number, dimensionId);
        if (StringUtils.isNotEmpty((String)numberMsg)) {
            log.info("AddMemberServiceImpl-Create-" + numberMsg);
            return numberMsg;
        }
        DynamicObject parent = this.getOrCreateParentId(modelId, dimensionId, map.get("parentNumber"), map.get("parentName"), dimensionNumber);
        if (parent == null) {
            log.info("AddMemberServiceImpl-Create-add parent fail");
            return FAIL;
        }
        String name = map.get("name");
        DynamicObject savedMember = this.creatMember(modelId, dimensionId, number, name, parent);
        log.info("AddMemberServiceImpl-CreateSuccess" + number + "-" + name);
        CubeUtils.updateDimensionVersion((Long)modelId, (Long)dimensionId);
        DimMembPermVerHelper.updateVer4MembChanged(null, (Long)modelId, (Long)dimensionId, (String)"AddMemberServiceImpl-createMember");
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId, (boolean)true);
        try {
            Model modelobj = orCreate.getModelobj();
            List datasets = DatasetServiceHelper.getAllDatasets((Long)modelId, (String)dimensionNumber);
            ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((Model)modelobj);
            ShrekOlapServiceHelper.updateDimension((Model)modelobj, (List)datasets, (String)dimensionNumber, (ShrekConfig)config);
        }
        catch (Exception e) {
            log.info("AddMemberServiceImpl-syncolap", (Object)e);
            throw new KDBizException(e.getMessage());
        }
        return SUCCESS;
    }

    private DynamicObject getOrCreateParentId(Long modelId, Long dimensionId, String number, String name, String dimNumber) {
        QFilter qf1 = new QFilter("model", "=", (Object)modelId);
        QFilter qf2 = new QFilter("dimension", "=", (Object)dimensionId);
        QFilter qf3 = new QFilter("number", "=", (Object)number);
        DynamicObject parent = QueryServiceHelper.queryOne((String)"epm_userdefinedmembertree", (String)"id,number,longnumber,level", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        if (parent != null) {
            return parent;
        }
        log.info("AddMemberServiceImpl-beginCreate-createParent-" + number + "-" + name);
        DynamicObject root = this.getRoot(modelId, dimensionId, dimNumber);
        if (root == null) {
            log.info("AddMemberServiceImpl-beginCreate-root not exist-");
            return root;
        }
        DynamicObject newParent = this.creatMember(modelId, dimensionId, number, name, root);
        return newParent;
    }

    private DynamicObject getRoot(Long modelId, Long dimensionId, String dimNumber) {
        QFilter qf1 = new QFilter("model", "=", (Object)modelId);
        QFilter qf2 = new QFilter("dimension", "=", (Object)dimensionId);
        QFilter qf3 = new QFilter("number", "=", (Object)dimNumber);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_userdefinedmembertree", (String)"id,longnumber,level", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        return dynamicObject;
    }

    private DynamicObject creatMember(Long modelId, Long dimensionId, String number, String name, DynamicObject parent) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"epm_userdefinedmembertree");
        Long id = GlobalIdUtil.genGlobalLongId();
        this.dimMemberCommonProperties(object);
        object.set("id", (Object)id);
        object.set("number", (Object)number);
        object.set("name", (Object)name);
        object.set("parent", (Object)parent.getLong("id"));
        object.set("model", (Object)modelId);
        object.set("dimension", (Object)dimensionId);
        object.set("longnumber", (Object)(parent.getString("longnumber") + "!" + number));
        object.set("datatype", (Object)"0");
        object.set("level", (Object)(parent.getInt("level") + 1));
        object.set("dseq", (Object)DimensionServiceHelper.getDSeq((long)parent.getLong("id"), (String)"epm_userdefinedmembertree", (String)"AddMemberServiceImpl"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        DynamicObject object1 = BusinessDataServiceHelper.loadSingle((Object)parent.get("id"), (String)"epm_userdefinedmembertree");
        if (object1 != null && object1.getBoolean("isleaf")) {
            object1.set("isleaf", (Object)"0");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object1});
        }
        return object;
    }

    private void dimMemberCommonProperties(DynamicObject object) {
        String userId = RequestContext.get().getUserId();
        Date now = TimeServiceHelper.now();
        object.set("modifier", (Object)userId);
        object.set("modifytime", (Object)now);
        object.set("status", (Object)"C");
        object.set("creator", (Object)userId);
        object.set("createtime", (Object)now);
        object.set("enable", (Object)"1");
        object.set("membersource", (Object)"4");
        object.set("isleaf", (Object)"1");
        object.set("aggoprt", (Object)"1");
        object.set("storagetype", (Object)"2");
    }

    private String checkNumber(Long modelId, String number, Long dimId) {
        if (number.length() > 50) {
            return "number too long";
        }
        String regEx = "^(?!_)[-a-zA-Z0-9_.]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches() || number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
            return "number is not standard";
        }
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        QFilter qf1 = new QFilter("dimension", "=", (Object)dimId);
        QFilter qf2 = new QFilter("number", "=", (Object)number);
        boolean exists = QueryServiceHelper.exists((String)"epm_userdefinedmembertree", (QFilter[])new QFilter[]{qf, qf1, qf2});
        return exists ? EXIST : "";
    }

    private Long getDimensionId(Long modelId, String dimNumber) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        QFilter qf1 = new QFilter("number", "=", (Object)dimNumber);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id", (QFilter[])new QFilter[]{qf, qf1});
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("id");
    }

    private Long getModelId(String modelNumber) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"id", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)modelNumber)});
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("id");
    }

    private String checkParams(Map<String, String> map) {
        for (String field : fields) {
            if (!StringUtils.isEmpty((String)map.get(field))) continue;
            return "need " + field;
        }
        return "";
    }
}

