/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.adjuest;

import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.enums.ApplicationTypeEnum;

public class AdjustMenuPermUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(AdjustMenuPermUpgradeServiceImpl.class);
    private static final String BGM_ADJUSTBILLLIST = "bgm_adjustbilllist";
    private static final String BGM_ADJUSTBILL = "bgm_adjustbill";
    private static final String BGM_ADJPSTBILLLIST = "bgm_adjpstbilllist";
    private static final String BGM_ADJPSTBILL = "bgm_adjpstbill";
    private static final String EB_ADJUSTBILLLIST = "eb_adjustbilllist";
    private static final String EB_ADJUSTBILL = "eb_adjustbill";
    private static final String EB_ADJPSTBILLLIST = "eb_adjpstbilllist";
    private static final String EB_ADJPSTBILL = "eb_adjpstbill";
    private static final String BGM_ADJUSTBILLLIST_NBG = "bgm_adjustbilllist_nbg";
    private static final String EB_ADJUSTBILL_NBG = "eb_adjustbill_nbg";
    private static final String BGM_ADJPSTBILLLIST_NBG = "bgm_adjpstbilllist_nbg";
    private static final String EB_ADJPSTBILL_NBG = "eb_adjpstbill_nbg";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"AdjustMenuPermDataServiceImpl");){
            try {
                boolean isNewAdjpstRolePermExist;
                boolean isNewAdjpstUserPermExist;
                boolean isNewEbAdjpstRolePermExist;
                boolean isNewAdjustRolePermExist;
                boolean isNewAdjustUserPermExist;
                boolean isNewEbRolePermExist;
                boolean isEbAdjpstRolePermExist;
                boolean isEbRolePermExist;
                boolean isBgmAdjpstRolePermExist;
                boolean isBgmRolePermExist;
                log.info("[AdjustMenuPermData] bgm adjust upgrade begin");
                AppInfo bgmAppInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.BGM.getAppnum());
                String bgmAppId = bgmAppInfo.getId();
                boolean isBgmUserPermExist = this.checkAdjustUserPermExist(bgmAppId, BGM_ADJUSTBILLLIST);
                if (isBgmUserPermExist) {
                    this.updateAdjustUserPermData(BGM_ADJUSTBILL, bgmAppId, BGM_ADJUSTBILLLIST);
                }
                if (isBgmRolePermExist = this.checkAdjustRolePermExist(bgmAppId, BGM_ADJUSTBILLLIST)) {
                    this.updateAdjustRolePermData(BGM_ADJUSTBILL, bgmAppId, BGM_ADJUSTBILLLIST);
                }
                log.info("[AdjustMenuPermData] bgm adjust upgrade end");
                log.info("[AdjustMenuPermData] bgm adjpst upgrade start");
                boolean isBgmAdjpstUserPermExist = this.checkAdjustUserPermExist(bgmAppId, BGM_ADJPSTBILLLIST);
                if (isBgmAdjpstUserPermExist) {
                    this.updateAdjustUserPermData(BGM_ADJPSTBILL, bgmAppId, BGM_ADJPSTBILLLIST);
                }
                if (isBgmAdjpstRolePermExist = this.checkAdjustRolePermExist(bgmAppId, BGM_ADJPSTBILLLIST)) {
                    this.updateAdjustRolePermData(BGM_ADJPSTBILL, bgmAppId, BGM_ADJPSTBILLLIST);
                }
                log.info("[AdjustMenuPermData] bgm adjpst upgrade end");
                log.info("[AdjustMenuPermData] eb adjust upgrade start");
                AppInfo ebAppInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.EB.getAppnum());
                String ebAppId = ebAppInfo.getId();
                boolean isEbUserPermExist = this.checkAdjustUserPermExist(ebAppId, EB_ADJUSTBILLLIST);
                if (isEbUserPermExist) {
                    this.updateAdjustUserPermData(EB_ADJUSTBILL, ebAppId, EB_ADJUSTBILLLIST);
                }
                if (isEbRolePermExist = this.checkAdjustRolePermExist(ebAppId, EB_ADJUSTBILLLIST)) {
                    this.updateAdjustRolePermData(EB_ADJUSTBILL, ebAppId, EB_ADJUSTBILLLIST);
                }
                log.info("[AdjustMenuPermData] eb adjust upgrade end");
                log.info("[AdjustMenuPermData] eb adjpst upgrade start");
                boolean isEbAdjpstUserPermExist = this.checkAdjustUserPermExist(ebAppId, EB_ADJPSTBILLLIST);
                if (isEbAdjpstUserPermExist) {
                    this.updateAdjustUserPermData(EB_ADJPSTBILL, ebAppId, EB_ADJPSTBILLLIST);
                }
                if (isEbAdjpstRolePermExist = this.checkAdjustRolePermExist(ebAppId, EB_ADJPSTBILLLIST)) {
                    this.updateAdjustRolePermData(EB_ADJPSTBILL, ebAppId, EB_ADJPSTBILLLIST);
                }
                log.info("[AdjustMenuPermData] eb adjpst upgrade end");
                log.info("[AdjustMenuPermData] newEb adjust upgrade start");
                AppInfo newEbAppInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.BG.getAppnum());
                String newEbAppId = newEbAppInfo.getId();
                boolean isNewEbUserPermExist = this.checkAdjustUserPermExist(newEbAppId, BGM_ADJUSTBILLLIST_NBG);
                if (isNewEbUserPermExist) {
                    this.updateAdjustUserPermData(BGM_ADJUSTBILL, newEbAppId, BGM_ADJUSTBILLLIST_NBG);
                }
                if (isNewEbRolePermExist = this.checkAdjustRolePermExist(newEbAppId, BGM_ADJUSTBILLLIST_NBG)) {
                    this.updateAdjustRolePermData(BGM_ADJUSTBILL, newEbAppId, BGM_ADJUSTBILLLIST_NBG);
                }
                if (isNewAdjustUserPermExist = this.checkAdjustUserPermExist(newEbAppId, EB_ADJUSTBILL_NBG)) {
                    this.updateAdjustUserPermData(BGM_ADJUSTBILL, newEbAppId, EB_ADJUSTBILL_NBG);
                }
                if (isNewAdjustRolePermExist = this.checkAdjustRolePermExist(newEbAppId, EB_ADJUSTBILL_NBG)) {
                    this.updateAdjustRolePermData(BGM_ADJUSTBILL, newEbAppId, EB_ADJUSTBILL_NBG);
                }
                log.info("[AdjustMenuPermData] newEb adjust upgrade end");
                log.info("[AdjustMenuPermData] newEb adjpst upgrade start");
                boolean isNewEbAdjpstUserPermExist = this.checkAdjustUserPermExist(newEbAppId, BGM_ADJPSTBILLLIST_NBG);
                if (isNewEbAdjpstUserPermExist) {
                    this.updateAdjustUserPermData(BGM_ADJPSTBILL, newEbAppId, BGM_ADJPSTBILLLIST_NBG);
                }
                if (isNewEbAdjpstRolePermExist = this.checkAdjustRolePermExist(newEbAppId, BGM_ADJPSTBILLLIST_NBG)) {
                    this.updateAdjustRolePermData(BGM_ADJPSTBILL, newEbAppId, BGM_ADJPSTBILLLIST_NBG);
                }
                if (isNewAdjpstUserPermExist = this.checkAdjustUserPermExist(newEbAppId, EB_ADJPSTBILL_NBG)) {
                    this.updateAdjustUserPermData(BGM_ADJPSTBILL, newEbAppId, EB_ADJPSTBILL_NBG);
                }
                if (isNewAdjpstRolePermExist = this.checkAdjustRolePermExist(newEbAppId, EB_ADJPSTBILL_NBG)) {
                    this.updateAdjustRolePermData(BGM_ADJPSTBILL, newEbAppId, EB_ADJPSTBILL_NBG);
                }
                log.info("[AdjustMenuPermData] newEb adjpst upgrade end");
                result.setSuccess(true);
            }
            catch (Throwable ex) {
                log.error("[AdjustMenuPermData] upgrade error: ", ex);
                tx.markRollback();
                result.setErrorInfo(ex.getMessage());
                result.setSuccess(false);
            }
        }
        return result;
    }

    private boolean checkAdjustUserPermExist(String appId, String entityTypeId) {
        String sql = "select count(1) from t_perm_userpermdetail where fbizappid = ? and fentitytypeid = ?";
        DataSet dataSet = DB.queryDataSet((String)"checkAdjustUserPermExist", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{appId, entityTypeId});
        return dataSet != null && !dataSet.isEmpty() && dataSet.hasNext();
    }

    private boolean checkAdjustRolePermExist(String appId, String entityTypeId) {
        String sql = "select count(1) from t_perm_rolepermdetial where fbizappid = ? and fentitytypeid = ?";
        DataSet dataSet = DB.queryDataSet((String)"checkAdjustRolePermExist", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{appId, entityTypeId});
        return dataSet != null && !dataSet.isEmpty() && dataSet.hasNext();
    }

    public void updateAdjustUserPermData(String newEntityTypeId, String appId, String entityTypeId) {
        String updateSql = "update t_perm_userpermdetail set fentitytypeid = ? where fbizappid = ? and fentitytypeid = ?";
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])new Object[]{newEntityTypeId, appId, entityTypeId});
    }

    public void updateAdjustRolePermData(String newEntityTypeId, String appId, String entityTypeId) {
        String updateSql = "update t_perm_rolepermdetial set fentitytypeid = ? where fbizappid = ? and fentitytypeid = ?";
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)updateSql, (Object[])new Object[]{newEntityTypeId, appId, entityTypeId});
    }
}

