/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.adjust;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;

public class RepairedAdjustDataServiceImpl
implements IUpgradeService {
    private DBRoute route = new DBRoute("epm");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            String selectSql = "select fid,fhashcode,fdimensionjson,fmodel,fdataset from t_eb_decomposeadjust where fmodel > 0 and fdataset > 0";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(50);
            DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)this.route, (String)selectSql);
            if (dataSet == null || !dataSet.hasNext()) {
                result.setLog(String.format("RepairedAdjustDataService reparid data size : %s", 0));
                result.setSuccess(true);
                return result;
            }
            HashSet<Long> modelIsDelete = new HashSet<Long>(16);
            HashMap<Long, IModelCacheHelper> modelCacheHelperMap = new HashMap<Long, IModelCacheHelper>(16);
            while (dataSet.hasNext()) {
                String[] dimensionNums;
                Row next = dataSet.next();
                Long modelId = next.getLong("fmodel");
                Long datasetId = next.getLong("fdataset");
                if (modelIsDelete.contains(modelId)) continue;
                IModelCacheHelper modelCacheHelper = (IModelCacheHelper)modelCacheHelperMap.get(modelId);
                if (modelCacheHelper == null) {
                    try {
                        modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                        modelCacheHelperMap.put(modelId, modelCacheHelper);
                    }
                    catch (Exception e) {
                        modelIsDelete.add(modelId);
                        continue;
                    }
                }
                if ((dimensionNums = modelCacheHelper.getDimensionNums(datasetId)) == null || dimensionNums.length == 0) continue;
                String dimensionStr = next.getString("fdimensionjson");
                Map dimensionMap = AdjustServiceHelper.parseMap((String)dimensionStr);
                if (!this.isHasUserdefinedDimens(dimensionNums, modelCacheHelper)) continue;
                Map newDimensionMap = AdjustServiceHelper.removeCustomDimNoneMember((Map)dimensionMap, (IModelCacheHelper)modelCacheHelper);
                String newDimensionStr = AdjustServiceHelper.toJsonString((Map)newDimensionMap);
                Long fid = next.getLong("fid");
                paramList.add(new Object[]{newDimensionStr, newDimensionMap.hashCode(), fid});
            }
            if (paramList.size() > 0) {
                String updateSql = "UPDATE t_eb_decomposeadjust SET fdimensionjson = ?, fhashcode = ? WHERE fid = ? ;";
                int[] batch = DB.executeBatch((DBRoute)this.route, (String)updateSql, paramList);
                result.setLog(String.format("RepairedAdjustDataService reparid data size : %s", batch.length));
            } else {
                result.setLog(String.format("RepairedAdjustDataService reparid data size : %s", 0));
            }
            result.setSuccess(true);
        }
        catch (Exception e) {
            String stackTraceStr = CommonServiceHelper.getStackTraceStr((Throwable)e);
            result.setSuccess(false);
            result.setErrorInfo(stackTraceStr);
            result.setLog(e.getMessage());
        }
        return result;
    }

    private boolean isHasUserdefinedDimens(String[] dimensionNums, IModelCacheHelper modelCacheHelper) {
        for (String dimensionNum : dimensionNums) {
            Dimension dimension = modelCacheHelper.getDimension(dimensionNum);
            if (dimension == null || !dimension.getMemberModel().equals(SysDimensionEnum.Project.getMemberTreemodel())) continue;
            return true;
        }
        return false;
    }
}

