/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.analysis;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

public abstract class AbstractAnalysisServiceImpl {
    private static final Log log = LogFactory.getLog(AbstractAnalysisServiceImpl.class);

    protected Map<String, Object> getDefaultReturnData(String lastUpdateVersion) {
        if (StringUtils.isEmpty((String)lastUpdateVersion)) {
            lastUpdateVersion = String.valueOf(System.nanoTime());
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("lastUpdateVersion", lastUpdateVersion);
        return returnData;
    }

    protected String getJSONData(Map<String, Object> returnData) {
        return SerializationUtils.toJsonString(returnData);
    }

    protected void dealException(Exception ex, StringBuilder errMsg) {
        log.error("AnalysisServiceImpl-error:", (Object)CommonServiceHelper.getStackTraceStr((Throwable)ex));
        errMsg.append(ResManager.loadResFormat((String)"\u8f7b\u5206\u6790\u670d\u52a1\u63a5\u53e3\u9519\u8bef(%1)\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractAnalysisServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[]{ex.getMessage() != null ? ex.getMessage() : ""}));
    }

    protected void dealException(Exception ex, Map<String, Object> returnData) {
        log.error("AnalysisServiceImpl-error:", (Object)CommonServiceHelper.getStackTraceStr((Throwable)ex));
        returnData.put("errorMsg", ResManager.loadResFormat((String)"\u8f7b\u5206\u6790\u670d\u52a1\u63a5\u53e3\u9519\u8bef(%1)\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractAnalysisServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[]{ex.getMessage() != null ? ex.getMessage() : ""}));
    }

    protected boolean verifyModelId(String modelId, Map<String, Object> returnData) {
        StringBuilder errMsg = new StringBuilder();
        if (StringUtils.isEmpty((String)modelId)) {
            errMsg.append(ResManager.loadKDString((String)"\u4f53\u7cfbid\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractAnalysisServiceImpl_1", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (errMsg.length() == 0) {
            try {
                Long _modelId = IDUtils.toLong((Object)modelId);
                if (!QueryServiceHelper.exists((String)"epm_model", (Object)_modelId)) {
                    errMsg.append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6307\u5b9aid\u7684\u9884\u7b97\u4f53\u7cfb\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractAnalysisServiceImpl_2", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
            }
            catch (Exception ex) {
                this.dealException(ex, errMsg);
            }
        }
        boolean result = true;
        if (errMsg.length() > 0) {
            returnData.put("errorMsg", errMsg.toString());
            result = false;
        }
        return result;
    }

    protected boolean verifyDimensionId(String dimensionId, Map<String, Object> returnData) {
        StringBuilder errMsg = new StringBuilder();
        if (StringUtils.isEmpty((String)dimensionId)) {
            errMsg.append(ResManager.loadKDString((String)"\u7ef4\u5ea6id\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractAnalysisServiceImpl_4", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        if (errMsg.length() == 0) {
            try {
                Long _dimensionId = IDUtils.toLong((Object)dimensionId);
                if (!QueryServiceHelper.exists((String)"epm_dimension", (Object)_dimensionId)) {
                    errMsg.append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6307\u5b9aid\u7684\u9884\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractAnalysisServiceImpl_5", (String)"epm-eb-mservice", (Object[])new Object[0]));
                }
            }
            catch (Exception ex) {
                this.dealException(ex, errMsg);
            }
        }
        boolean result = true;
        if (errMsg.length() > 0) {
            returnData.put("errorMsg", errMsg.toString());
            result = false;
        }
        return result;
    }
}

