/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.analysis;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.service.analysis.AbstractAnalysisServiceImpl;
import kd.epm.eb.service.analysis.AnalysisService;

public class AnalysisServiceImpl
extends AbstractAnalysisServiceImpl
implements AnalysisService {
    public String getDatabaseList() {
        Map<String, Object> returnData = this.getDefaultReturnData(null);
        try {
            DynamicObjectCollection _models = QueryServiceHelper.query((String)"epm_model", (String)"id,shownumber,name", null, (String)"shownumber");
            ArrayList list = new ArrayList(_models.size());
            _models.forEach(m -> {
                LinkedHashMap<String, String> _model = new LinkedHashMap<String, String>();
                _model.put("id", m.getString("id"));
                _model.put("number", m.getString("shownumber"));
                _model.put("name", m.getString("name"));
                list.add(_model);
            });
            returnData.put("data", list);
        }
        catch (Exception ex) {
            this.dealException(ex, returnData);
        }
        return this.getJSONData(returnData);
    }

    public String getCubeList(String databaseId) {
        Map<String, Object> returnData = this.getDefaultReturnData(null);
        if (this.verifyModelId(databaseId, returnData)) {
            ArrayList cubes = new ArrayList();
            try {
                DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)IDUtils.toLong((Object)databaseId), (String)"epm_model");
                if (model != null) {
                    if (StringUtils.equals((String)ApplicationTypeEnum.EB.getIndex(), (String)model.getString("reporttype"))) {
                        LinkedHashMap<String, String> cube = new LinkedHashMap<String, String>();
                        cube.put("id", model.getString("id"));
                        cube.put("number", model.getString("number"));
                        cube.put("name", model.getString("name"));
                        cubes.add(cube);
                    } else {
                        QFBuilder builder = new QFBuilder();
                        builder.add("model", "=", (Object)model.getLong("id"));
                        DynamicObjectCollection _datasets = QueryServiceHelper.query((String)"eb_dataset", (String)"id,number,name", (QFilter[])builder.toArray(), (String)"number");
                        _datasets.forEach(m -> {
                            LinkedHashMap<String, String> _cube = new LinkedHashMap<String, String>();
                            _cube.put("id", m.getString("id"));
                            _cube.put("number", m.getString("number"));
                            _cube.put("name", m.getString("name"));
                            cubes.add(_cube);
                        });
                    }
                }
                returnData.put("data", cubes);
            }
            catch (Exception ex) {
                this.dealException(ex, returnData);
            }
        }
        return this.getJSONData(returnData);
    }

    public String getDimensionAndMeasureList(String cubeId) {
        Map<String, Object> returnData = this.getDefaultReturnData(null);
        try {
            LinkedHashMap dataMap = new LinkedHashMap();
            ArrayList dimensions = new ArrayList();
            dataMap.put("dimensions", dimensions);
            QFBuilder builder = null;
            Long _modelId = IDUtils.toLong((Object)cubeId);
            if (QueryServiceHelper.exists((String)"epm_model", (Object)_modelId)) {
                builder = new QFBuilder();
                builder.add("model", "=", (Object)_modelId);
            } else if (QueryServiceHelper.exists((String)"eb_dataset", (Object)_modelId)) {
                DynamicObject dataset = BusinessDataServiceHelper.loadSingleFromCache((Object)_modelId, (String)"eb_dataset", (String)"id,model.id");
                Set dimNumber = DatasetServiceHelper.getRefDimNumber((Long)_modelId);
                if (dimNumber != null && !dimNumber.isEmpty()) {
                    builder = new QFBuilder();
                    builder.add("model", "=", (Object)dataset.getLong("model.id"));
                    builder.add("number", "in", (Object)dimNumber);
                }
            } else {
                returnData.put("errorMsg", ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6307\u5b9aid\u7684\u9884\u7b97\u4f53\u7cfb\u6216\u8005\u6570\u636e\u96c6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractAnalysisServiceImpl_3", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            if (builder != null) {
                DynamicObjectCollection _dimension = QueryServiceHelper.query((String)"epm_dimension", (String)"id,number,name", (QFilter[])builder.toArray(), (String)"dseq,number");
                _dimension.forEach(d -> {
                    LinkedHashMap<String, String> _dimensionMap = new LinkedHashMap<String, String>();
                    _dimensionMap.put("id", d.getString("id"));
                    _dimensionMap.put("number", d.getString("number"));
                    _dimensionMap.put("name", d.getString("name"));
                    dimensions.add(_dimensionMap);
                });
                returnData.put("data", dataMap);
            }
        }
        catch (Exception ex) {
            this.dealException(ex, returnData);
        }
        return this.getJSONData(returnData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDimensionMemberList(String cubeId, String dimensionId, String lastUpdateVersion) {
        Map<String, Object> returnData = this.getDefaultReturnData(lastUpdateVersion);
        if (this.verifyDimensionId(dimensionId, returnData)) {
            ArrayList members = new ArrayList();
            try {
                DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)IDUtils.toLong((Object)dimensionId), (String)"epm_dimension");
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)object.getLong("model.id"));
                Dimension dimension = modelCacheHelper.getDimension(object.getString("number"));
                if (dimension != null) {
                    boolean hasMetric = "Metric".equals(dimension.getNumber());
                    List _members = dimension.getAllMemberSort();
                    _members.forEach(m -> {
                        LinkedHashMap<String, String> _member = new LinkedHashMap<String, String>();
                        _member.put("id", String.valueOf(m.getId()));
                        _member.put("number", m.getNumber());
                        _member.put("name", m.getName());
                        _member.put("parentId", String.valueOf(m.getParentId()));
                        if (hasMetric) {
                            if (MetricUtils.isNumeric((String)m.getDatatype())) {
                                _member.put("dataType", "NUMBER");
                            } else {
                                _member.put("dataType", "STRING");
                            }
                        }
                        members.add(_member);
                    });
                    returnData.put("data", members);
                }
            }
            catch (Exception ex) {
                this.dealException(ex, returnData);
            }
            finally {
                ModelCacheContext.remove();
            }
        }
        return this.getJSONData(returnData);
    }

    public String getDataSet(String cubeId, String dimensionIds, String measureIds, String filters, String lastUpdateVersion) {
        return null;
    }
}

