/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.apply;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.StringUtils;

public class OldTempTableAddColsService
implements IUpgradeService {
    private DBRoute route = new DBRoute("epm");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            Set<String> allTempTable = this.getAllTempTable();
            this.addColumn(allTempTable);
        }
        catch (Exception e) {
            String stackTraceStr = CommonServiceHelper.getStackTraceStr((Throwable)e);
            result.setSuccess(false);
            result.setErrorInfo(stackTraceStr);
            result.setLog(e.getMessage());
        }
        return result;
    }

    private void addColumn(Set<String> allTempTable) {
        StringBuilder sql = new StringBuilder();
        for (String table : allTempTable) {
            List<String> columnNames = this.getTableColNames(this.route, table);
            if (columnNames == null || columnNames.size() == 0) continue;
            HashSet<String> allCols = new HashSet<String>(columnNames.size());
            for (String colKey : columnNames) {
                if (!StringUtils.isNotEmpty((String)colKey)) continue;
                allCols.add(colKey.toLowerCase());
            }
            if (!allCols.contains("fcreator")) {
                sql.append("alter table ").append(table).append(" add (fcreator bigint default 0);");
            }
            if (!allCols.contains("fcreatedate")) {
                sql.append("alter table ").append(table).append(" add (fcreatedate datetime);");
            }
            if (!allCols.contains("fmodifier")) {
                sql.append("alter table ").append(table).append(" add (fmodifier bigint default 0);");
            }
            if (allCols.contains("fmodifydate")) continue;
            sql.append("alter table ").append(table).append(" add (fmodifydate datetime);");
        }
        if (sql.length() > 0) {
            DB.execute((DBRoute)this.route, (String)sql.toString());
        }
    }

    private List<String> getTableColNames(DBRoute route, String table) {
        return DB.getColumnNames((DBRoute)route, (String)table);
    }

    private Set<String> getAllTempTable() {
        HashSet<String> tables = new HashSet<String>(16);
        String sql = "select fentrycfgjson_tag from t_eb_applytemplate";
        try (DataSet dataSet = DB.queryDataSet((String)"getAllTempTable", (DBRoute)this.route, (String)sql);){
            for (Row row : dataSet) {
                String fentrycfgjson_tag = row.getString("fentrycfgjson_tag");
                if (!StringUtils.isNotEmpty((String)fentrycfgjson_tag)) continue;
                ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)fentrycfgjson_tag, ColumnList.class);
                tables.addAll(columnList.getEntityinfomap().values());
            }
        }
        return tables;
    }
}

