/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.approve;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class ApproveBillPermUpgradeServiceImpl
implements IUpgradeService {
    private static final String FLAG = "ApproveBillPermUpgradeService";
    private static final String EB_APPROVEBILL_MANAGE = "eb_approvebill_manage";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        if (!UpdateRecordHelper.isUpdated((String)FLAG)) {
            try (TXHandle tx = TX.requiresNew((String)FLAG);){
                try {
                    this.upUserPerm();
                    PermissionServiceHelper.clearAllCache();
                    result.setSuccess(true);
                }
                catch (Exception e) {
                    result.setSuccess(false);
                    result.setLog(e.getMessage());
                    result.setErrorInfo(CommonServiceHelper.getStackTraceStr((Throwable)e));
                    tx.markRollback();
                    UpgradeResult upgradeResult = result;
                    if (tx != null) {
                        if (var7_7 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                var7_7.addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                    return upgradeResult;
                }
            }
            UpdateRecordHelper.addRecord((String)FLAG, null, null, (boolean)true);
        }
        return result;
    }

    private void upUserPerm() {
        Object userId3;
        Object row3;
        HashMap<Long, String> modelTypeMap = new HashMap<Long, String>(16);
        HashSet<Long> modelIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,freporttype from t_eb_model where freporttype in('6','7')", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"querymodel", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            for (Object row2 : dataSet) {
                Long modelId = row2.getLong("fid");
                modelIds.add(modelId);
                modelTypeMap.put(modelId, row2.getString("freporttype"));
            }
        }
        if (modelIds.isEmpty()) {
            return;
        }
        HashSet<Long> userIds = new HashSet<Long>(16);
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select b.fusers from t_eb_modelperm a,t_eb_modelpermentry b where a.fid=b.fid ", new Object[0]);
        sqlBuilder.appendIn(" and a.fmodelid", modelIds.toArray());
        DataSet dataSet = DB.queryDataSet((String)"querymodelperm", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        Object object = null;
        try {
            for (Object row3 : dataSet) {
                userId3 = row3.getLong("fusers");
                userIds.add((Long)userId3);
            }
        }
        catch (Throwable row2) {
            object = row2;
            throw row2;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row2) {
                        ((Throwable)object).addSuppressed(row2);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (userIds.isEmpty()) {
            return;
        }
        HashSet<String> uIds = new HashSet<String>(16);
        DBRoute dbRoute = new DBRoute("sys");
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fuserid,forgid,fisincludesuborg,fdimtype from t_perm_userperm where ", new Object[0]);
        sqlBuilder.appendIn(" fuserid", userIds.toArray());
        sqlBuilder.appendIn(" and forgid", modelIds.toArray());
        DataSet dataSet2 = DB.queryDataSet((String)"queryuserperm", (DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
        row3 = null;
        try {
            for (Object row4 : dataSet2) {
                String id = row4.getString("fid");
                String userId2 = row4.getString("fuserid");
                String modelId = row4.getString("forgid");
                uIds.add(id + "!" + userId2 + "!" + modelId);
            }
        }
        catch (Throwable userId3) {
            row3 = userId3;
            throw userId3;
        }
        finally {
            if (dataSet2 != null) {
                if (row3 != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable userId3) {
                        ((Throwable)row3).addSuppressed(userId3);
                    }
                } else {
                    dataSet2.close();
                }
            }
        }
        HashSet<String> permIds = new HashSet<String>(16);
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid from t_perm_permitem where ", new Object[0]);
        sqlBuilder.appendIn(" fnumber", new Object[]{"QXX0004", "QXX0001", "QXX0007", "BGM-SUBMIT-CANCEL"});
        DataSet dataSet3 = DB.queryDataSet((String)"querypermitem", (DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
        userId3 = null;
        try {
            for (Object row5 : dataSet3) {
                String id = row5.getString("fid");
                permIds.add(id);
            }
        }
        catch (Throwable row4) {
            userId3 = row4;
            throw row4;
        }
        finally {
            if (dataSet3 != null) {
                if (userId3 != null) {
                    try {
                        dataSet3.close();
                    }
                    catch (Throwable row4) {
                        ((Throwable)userId3).addSuppressed(row4);
                    }
                } else {
                    dataSet3.close();
                }
            }
        }
        AppInfo bgmAppInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.BGM.getAppnum());
        AppInfo ebAppInfo = AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.EB.getAppnum());
        ArrayList<Object[]> newPermRowData = new ArrayList<Object[]>(16);
        for (String uId : uIds) {
            String[] ids = uId.split("!");
            String id = ids[0];
            Long userId4 = Long.parseLong(ids[1]);
            Long dimId = Long.parseLong(ids[2]);
            String modelType = (String)modelTypeMap.get(dimId);
            String appId = bgmAppInfo.getId();
            if ("6".equals(modelType)) {
                appId = ebAppInfo.getId();
            }
            for (String permId : permIds) {
                Object[] newRowData = new Object[]{id, null, 0, "10", permId, EB_APPROVEBILL_MANAGE, appId, "1", 0, userId4, "epm_model", dimId, "0"};
                newPermRowData.add(newRowData);
            }
        }
        if (newPermRowData.size() > 0) {
            String[] stringIds = GlobalIdUtil.genStringIds((int)newPermRowData.size());
            for (int seq = 0; seq < newPermRowData.size(); ++seq) {
                ((Object[])newPermRowData.get((int)seq))[1] = stringIds[seq];
            }
            String insertSql = "insert into t_perm_userpermdetail(fid,fentryid,fseq,fcontrolmode,fpermitemid,fentitytypeid,fbizappid,fsource,fbizroleid,fuserid,fdimtype,fdimid,fisincludesub) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)dbRoute, (String)insertSql, newPermRowData);
        }
    }
}

