/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.approve;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.approveBill.RejectOnReportService;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.utils.WorkFlowUtil;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.approveBill.Entity.RejectStatus;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.StringUtils;

public class ApproveBillService {
    private static final Log log = LogFactory.getLog(ApproveBillService.class);

    public void dealBillWFProcessStop(Long approveBillId, String currentNodeNumber) {
        ApproveBillInfo approveBillInfo = ApproveBillHelper.queryBill((Long)approveBillId);
        if (approveBillInfo == null) {
            return;
        }
        HashSet<Long> billIds = new HashSet<Long>(1);
        if (approveBillInfo.isCentralBill()) {
            ApproveUtils.getInstance().discardApproveBills(approveBillInfo.getParentBillId(), Collections.singletonList(approveBillInfo.getBillId()));
            billIds.add(approveBillInfo.getParentBillId());
        } else {
            ApproveUtils.getInstance().discardAllChildBills(approveBillInfo, null);
            billIds.add(approveBillId);
            RejectOnReportService.getInstance().handleWorkFlowForceStop(approveBillId);
        }
        ApproveUtils.getInstance().updateApproveSplitBillType(billIds);
        log.info("dealBillWFProcessStop-- bill:{},node:{}", (Object)approveBillId, (Object)currentNodeNumber);
    }

    public void handleNodeEnter(Long approveBillId, String currentNodeNumber, String dynToNodeInfo, String eventName) {
        ApproveBillInfo approveBillInfo;
        String lastNodeNumber = this.getLastNodeNumber(dynToNodeInfo);
        log.info("handleNodeEnter--bill:{},cNode:{},lNode:{},eName:{},dynToNodeInfo:{}", new Object[]{approveBillId, currentNodeNumber, lastNodeNumber, eventName, dynToNodeInfo});
        if (StringUtils.isEmpty((String)lastNodeNumber)) {
            return;
        }
        HashSet preNodeNumbers = new HashSet(16);
        HashSet nextNodeNumbers = new HashSet(16);
        WorkFlowUtil.selFlowSignNodes((String)"eb_approvebill", (Long)approveBillId, (String)currentNodeNumber, (boolean)true, preNodeNumbers, nextNodeNumbers);
        if (preNodeNumbers.contains(lastNodeNumber) && nextNodeNumbers.contains(currentNodeNumber)) {
            ApproveUtils.getInstance().finishPreCentralBill(approveBillId, preNodeNumbers);
        } else if (nextNodeNumbers.contains(lastNodeNumber) && (approveBillInfo = ApproveBillHelper.queryBill((Long)approveBillId)) != null && !approveBillInfo.isCentralBill()) {
            ApproveUtils.getInstance().discardAllChildBills(approveBillInfo, currentNodeNumber, nextNodeNumbers);
            HashSet<Long> billIds = new HashSet<Long>(1);
            billIds.add(approveBillId);
            ApproveUtils.getInstance().updateApproveSplitBillType(billIds);
        }
        RejectOnReportService.getInstance().handleWorkFlowJump(approveBillId);
    }

    private String getLastNodeNumber(String dynToNodeInfo) {
        int signIndex;
        Map dynToNodeMap;
        String lastNode;
        String lastNodeNumber = null;
        if (StringUtils.isNotEmpty((String)dynToNodeInfo) && StringUtils.isNotEmpty((String)(lastNode = (String)(dynToNodeMap = (Map)SerializationUtils.fromJsonString((String)dynToNodeInfo, HashMap.class)).get("srcNode"))) && (signIndex = lastNode.lastIndexOf("_")) != -1) {
            lastNodeNumber = lastNode.substring(signIndex + 1);
        }
        return lastNodeNumber;
    }

    public RejectStatus getProcessRejectStatusForService(Long processId, Long approveBillId) {
        return ApproveUtils.getInstance().getProcessRejectStatus(processId, approveBillId);
    }
}

