/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.approve;

import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class ApproveBillSortValUpServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"ApproveBillSortValUp");){
            try {
                if (!UpdateRecordHelper.isUpdated((String)"ApproveBillSortValUp")) {
                    this.update();
                    UpdateRecordHelper.addRecord((String)"ApproveBillSortValUp", null, null, (boolean)true);
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setLog(e.getMessage());
                result.setErrorInfo(CommonServiceHelper.getStackTraceStr((Throwable)e));
                tx.markRollback();
            }
        }
        return result;
    }

    private void update() {
        List<Object[]> approveBillInfo = this.selApproveBillInfo();
        if (approveBillInfo.size() > 0) {
            approveBillInfo.sort(Comparator.comparing(row -> (Date)row[0]));
            Long[] sortVals = ApproveBillHelper.getSortVal((int)approveBillInfo.size());
            int seq = 0;
            for (Object[] billObj : approveBillInfo) {
                billObj[0] = sortVals[seq];
                ++seq;
            }
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)"update t_eb_approvebill set fsortval = ? where fid = ?", approveBillInfo);
        }
    }

    public List<Object[]> selApproveBillInfo() {
        LinkedList<Object[]> vals = new LinkedList<Object[]>();
        try (DataSet dataSet = DB.queryDataSet((String)"selApproveBillInfo", (DBRoute)BgFormConstant.DBROUTE, (String)"select fid,fcreatedate,fsortval from t_eb_approvebill");){
            for (Row row : dataSet) {
                Long sortVal = row.getLong("fsortval");
                if (!IDUtils.isNull((Long)sortVal)) continue;
                vals.add(new Object[]{row.getDate("fcreatedate"), row.getLong("fid")});
            }
        }
        return vals;
    }
}

