/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.approve;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.StringUtils;

public class ApproveBillUpdateServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(ApproveBillUpdateServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"approveBillUpdate");){
            try {
                this.updateApproveBill();
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    private void updateApproveBill() {
        Serializable fid;
        Object frptprocesstype;
        HashSet<Long> tasklist = new HashSet<Long>(16);
        HashSet<Long> rptscheme = new HashSet<Long>(16);
        ArrayList<Long> taskprocessid = new ArrayList<Long>(16);
        HashMap<Long, String> type = new HashMap<Long, String>(16);
        HashSet<Long> orgViewid = new HashSet<Long>(16);
        String sqlPart = "select fid,frptprocesstype,forgviewid from t_eb_approvebill where fsourceid = ?";
        try (DataSet ds = DB.queryDataSet((String)"queryApprovebill", (DBRoute)DBRoute.of((String)"epm"), (String)sqlPart, (Object[])new Object[]{0});){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long fid2 = row.getLong("fid");
                Long viewid = row.getLong("forgviewid");
                frptprocesstype = row.getString("frptprocesstype");
                if (StringUtils.isEmpty((String)frptprocesstype)) {
                    tasklist.add(fid2);
                    type.put(fid2, "1");
                } else {
                    String frptprocesstype1 = row.getString("frptprocesstype");
                    if (StringUtils.equals((String)"1", (String)frptprocesstype1)) {
                        tasklist.add(fid2);
                        type.put(fid2, "1");
                    } else {
                        rptscheme.add(fid2);
                        type.put(fid2, "2");
                    }
                }
                if (viewid == null || viewid == 0L) {
                    orgViewid.add(fid2);
                }
                taskprocessid.add(row.getLong("fid"));
            }
        }
        log.info("t_eb_approvebill:tasklist:" + tasklist + "rptscheme:" + rptscheme + "taskprocessid:" + taskprocessid);
        log.info("t_eb_approvebill:tasklist.size:" + tasklist.size() + "rptscheme.size:" + rptscheme.size() + "taskprocessid.size:" + taskprocessid.size());
        ArrayList<Long> tasklistList = new ArrayList<Long>(16);
        ArrayList<Long> rptschemeList = new ArrayList<Long>(16);
        HashMap<Long, Long> approvebillentry = new HashMap<Long, Long>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid,ftaskprocessid from t_eb_approvebillentry where ", new Object[0]);
        sql.appendIn("fid", taskprocessid);
        if (taskprocessid.size() > 0) {
            DataSet ds = DB.queryDataSet((String)"queryApprovebill", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sql);
            frptprocesstype = null;
            try {
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    Long ftaskprocessid = row.getLong("ftaskprocessid");
                    fid = row.getLong("fid");
                    if (ftaskprocessid == 0L) continue;
                    if (tasklist.contains(fid)) {
                        tasklistList.add(ftaskprocessid);
                    } else if (rptscheme.contains(fid)) {
                        rptschemeList.add(ftaskprocessid);
                    }
                    approvebillentry.put((Long)fid, ftaskprocessid);
                }
            }
            catch (Throwable row) {
                frptprocesstype = row;
                throw row;
            }
            finally {
                if (ds != null) {
                    if (frptprocesstype != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)frptprocesstype).addSuppressed(row);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        log.info("t_eb_approvebillentry:tasklistList:" + tasklistList + "rptschemeList:" + rptschemeList + "approvebillentry:" + approvebillentry);
        log.info("t_eb_approvebillentry:tasklistList.size:" + tasklistList.size() + "rptschemeList.size:" + rptschemeList.size() + "approvebillentry.size:" + approvebillentry.size());
        HashMap<Long, Long> dynamicreport = new HashMap<Long, Long>(16);
        ArrayList<Long> schemeassignid = new ArrayList<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fschemeassignid from t_eb_dynamicreport where ", new Object[0]);
        sqlBuilder.appendIn("fid", rptschemeList);
        if (rptschemeList.size() > 0) {
            DataSet ds = DB.queryDataSet((String)"queryApprovebill", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
            fid = null;
            try {
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    dynamicreport.put(row.getLong("fid"), row.getLong("fschemeassignid"));
                    schemeassignid.add(row.getLong("fschemeassignid"));
                }
            }
            catch (Throwable row) {
                fid = row;
                throw row;
            }
            finally {
                if (ds != null) {
                    if (fid != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)fid).addSuppressed(row);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        log.info("t_eb_dynamicreport:dynamicreport:" + dynamicreport);
        log.info("t_eb_dynamicreport:dynamicreport.size:" + dynamicreport.size());
        HashMap<Long, Long> schemeid = new HashMap<Long, Long>(16);
        ArrayList<Long> schemeidList = new ArrayList<Long>(16);
        SqlBuilder sqlBuilder1 = new SqlBuilder();
        sqlBuilder1.append("select fid,fschemeid from t_eb_schemeassign where ", new Object[0]);
        sqlBuilder1.appendIn("fid", schemeassignid);
        if (schemeassignid.size() > 0) {
            try (DataSet ds = DB.queryDataSet((String)"queryApprovebill", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder1);){
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    schemeid.put(row.getLong("fid"), row.getLong("fschemeid"));
                    schemeidList.add(row.getLong("fschemeid"));
                }
            }
        }
        log.info("t_eb_schemeassign:schemeid:" + schemeid);
        log.info("t_eb_schemeassign:schemeid.size:" + schemeid.size());
        HashMap<Long, Long> schemeviewid = new HashMap<Long, Long>(16);
        SqlBuilder sqlBuilder2 = new SqlBuilder();
        sqlBuilder2.append("select fid,forgviewid from t_eb_rptscheme where ", new Object[0]);
        sqlBuilder2.appendIn("fid", schemeidList);
        if (schemeidList.size() > 0) {
            DataSet ds = DB.queryDataSet((String)"queryApprovebill", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder2);
            Object object = null;
            try {
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    schemeviewid.put(row.getLong("fid"), row.getLong("forgviewid"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        log.info("t_eb_rptscheme:schemeviewid:" + schemeviewid);
        log.info("t_eb_rptscheme:schemeviewid.size:" + schemeviewid.size());
        HashMap updatareport = new HashMap(16);
        for (Map.Entry entry : dynamicreport.entrySet()) {
            Long key = (Long)entry.getKey();
            if (schemeid.get(entry.getValue()) == null) continue;
            updatareport.put(key, schemeid.get(entry.getValue()));
        }
        SqlBuilder sqlTaskProcess = new SqlBuilder();
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> taskprocessViewid = new HashMap<Long, Long>(16);
        ArrayList<Long> taskid = new ArrayList<Long>(16);
        sqlTaskProcess.append("select fid,ftaskid,forgviewid from t_eb_taskprocess where ", new Object[0]);
        sqlTaskProcess.appendIn("fid", tasklistList);
        if (tasklistList.size() > 0) {
            try (DataSet ds = DB.queryDataSet((String)"queryApprovebill", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlTaskProcess);){
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    hashMap.put(row.getLong("fid"), row.getLong("ftaskid"));
                    taskprocessViewid.put(row.getLong("fid"), row.getLong("forgviewid"));
                    taskid.add(row.getLong("ftaskid"));
                }
            }
        }
        log.info("t_eb_taskprocess:taskprocess:" + hashMap + "taskid:" + taskid);
        log.info("t_eb_taskprocess:taskprocess.size:" + hashMap.size() + "taskid.size:" + taskid.size());
        SqlBuilder sqlTask = new SqlBuilder();
        HashMap<Long, Long> task = new HashMap<Long, Long>(16);
        sqlTask.append("select fid,ftasklistid from t_eb_task where ", new Object[0]);
        sqlTask.appendIn("fid", taskid);
        if (taskid.size() > 0) {
            DataSet ds = DB.queryDataSet((String)"queryApprovebill", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlTask);
            Object object = null;
            try {
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    task.put(row.getLong("fid"), row.getLong("ftasklistid"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        log.info("t_eb_task:task:" + task);
        log.info("t_eb_task:task.size:" + task.size());
        ArrayList<Object[]> updateApprove = new ArrayList<Object[]>(16);
        for (Long l : orgViewid) {
            Long rptScheme;
            Long scheme;
            Long l2 = (Long)approvebillentry.get(l);
            if (taskprocessViewid.get(l2) != null) {
                Long viewId = (Long)taskprocessViewid.get(l2);
                updateApprove.add(new Object[]{viewId, l});
                continue;
            }
            if (dynamicreport.get(l2) == null || schemeid.get(scheme = (Long)dynamicreport.get(l2)) == null || schemeviewid.get(rptScheme = (Long)schemeid.get(scheme)) == null) continue;
            Long viewId = (Long)schemeviewid.get(rptScheme);
            updateApprove.add(new Object[]{viewId, l});
        }
        ArrayList<Object[]> updateHeadDatas = new ArrayList<Object[]>(16);
        for (Map.Entry entry : approvebillentry.entrySet()) {
            Long tasklistid;
            Long key = (Long)entry.getKey();
            Long value = (Long)entry.getValue();
            String billType = (String)type.get(key);
            if (StringUtils.equals((String)"2", (String)billType)) {
                if (updatareport.get(value) == null) continue;
                Long report = (Long)updatareport.get(value);
                updateHeadDatas.add(new Object[]{report, key});
                continue;
            }
            if (hashMap.get(value) == null || task.get(tasklistid = (Long)hashMap.get(value)) == null) continue;
            Long taskexample = (Long)task.get(tasklistid);
            updateHeadDatas.add(new Object[]{taskexample, key});
        }
        String string = "update t_eb_approvebill set fsourceid = ? where fid = ?";
        String string2 = "update t_eb_approvebill set forgviewid = ? where fid = ?";
        try {
            if (updateHeadDatas.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)string, updateHeadDatas);
            }
            if (updateApprove.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)string2, updateApprove);
            }
            log.info("ApproveUpdata:" + updateHeadDatas);
            log.info("ApproveUpdata.size:" + updateHeadDatas.size());
            log.info("updateApprove:" + updateApprove);
        }
        catch (Exception e) {
            log.error("ApproveUpdata:" + e.getMessage());
        }
    }
}

