/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.approve;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class ApproveBillViewUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(ApproveBillViewUpgradeServiceImpl.class);
    private static final String sql = "update t_eb_approvebill set forgviewid = ? where fid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(false);
        try {
            if (!UpdateRecordHelper.isUpdated((String)"AppBillViewUpgrade")) {
                ArrayList<Object[]> params = new ArrayList<Object[]>(16);
                Map<String, Long> viewMap = this.getViewMap();
                this.getToUpdateViewParams(viewMap, params);
                try (TXHandle tx = TX.required((String)"ApproveTypeUpgradeServiceImpl");){
                    try {
                        if (params.size() != 0) {
                            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, params);
                        }
                    }
                    catch (Throwable e) {
                        tx.markRollback();
                        throw e;
                    }
                }
                UpdateRecordHelper.addRecord((String)"AppBillViewUpgrade", null, null, (boolean)true);
            }
            result.setSuccess(true);
        }
        catch (Throwable e) {
            result.setLog(CommonServiceHelper.getStackTraceStr((Throwable)e));
        }
        return result;
    }

    private Map<String, Long> getViewMap() {
        Long viewId;
        Long id;
        Row row;
        HashMap<String, Long> viewMap = new HashMap<String, Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, forgviewid from t_eb_rptscheme", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"querySchemeView", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                row = ds.next();
                id = row.getLong("fid");
                viewId = row.getLong("forgviewid");
                if (id == null || id == 0L || viewId == null || viewId == 0L) continue;
                viewMap.put("2&" + id, viewId);
            }
        }
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, forgview from t_eb_tasklist", new Object[0]);
        ds = DB.queryDataSet((String)"queryTaskView", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        var4_4 = null;
        try {
            while (ds.hasNext()) {
                row = ds.next();
                id = row.getLong("fid");
                viewId = row.getLong("forgview");
                if (id == null || id == 0L || viewId == null || viewId == 0L) continue;
                viewMap.put("1&" + id, viewId);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var4_4 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return viewMap;
    }

    private void getToUpdateViewParams(Map<String, Long> viewMap, List<Object[]> params) {
        if (viewMap == null || viewMap.size() == 0) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,frptprocesstype, fsourceid from t_eb_approvebill", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"queryApproveScheme", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long source = row.getLong("fsourceid");
                String rptType = row.getString("frptprocesstype");
                Long fid = row.getLong("fid");
                Long viewId = viewMap.get(rptType + "&" + source);
                if (viewId == null || viewId == 0L) continue;
                params.add(new Object[]{viewId, fid});
            }
        }
    }
}

