/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.approve;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class ApproveTypeUpgradeServiceImpl
implements IUpgradeService {
    private static final String insertMainTableSql = "insert into t_eb_approvaltypeentity(fid,fnumber,fmodelid,fbizmodelid,faudittype,fstatus,fdesc,fcreaterid,fcreatedate,fmodifierid,fmodifydate) values (?,?,?,?,?,?,?,?,?,?,?)";
    private static final String insertEntryTableSql = "insert into t_eb_approvaltypeentry(fid,fentryid,ftemplateid) values (?,?,?)";
    private static final String insertMultiTableSql = "insert into t_eb_approvaltypeentity_l(fid,fpkid,flocaleid,fname) values (?,?,?,?)";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(false);
        try {
            if (!UpdateRecordHelper.isUpdated((String)"ApproveTypeUpgradeServiceImpl")) {
                HashMap<Long, List<Long>> approveTypeTemplateMap = new HashMap<Long, List<Long>>(16);
                Map<Long, List<Long>> businessApproveTypeMap = this.collectApproveTypeInBusiness(approveTypeTemplateMap);
                HashMap<Long, Long> approveModelMap = new HashMap<Long, Long>(16);
                HashMap<Long, LocaleString> approveNameMap = new HashMap<Long, LocaleString>(16);
                HashMap<Long, Object[]> otherValues = new HashMap<Long, Object[]>(16);
                Map<Long, BasedataPojo> approveTypeInfos = this.collectAllApproveTypeInfos(approveModelMap, approveNameMap, otherValues);
                ArrayList<Object[]> mainParams = new ArrayList<Object[]>(16);
                ArrayList<Object[]> entryParams = new ArrayList<Object[]>(16);
                ArrayList<Object[]> multiParams = new ArrayList<Object[]>(16);
                this.buildUpgradeParams(mainParams, entryParams, multiParams, approveTypeTemplateMap, businessApproveTypeMap, approveNameMap, approveModelMap, otherValues, approveTypeInfos);
                try (TXHandle tx = TX.required((String)"ApproveTypeUpgradeServiceImpl");){
                    try {
                        if (mainParams.size() != 0) {
                            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertMainTableSql, mainParams);
                        }
                        if (entryParams.size() != 0) {
                            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertEntryTableSql, entryParams);
                        }
                        if (multiParams.size() != 0) {
                            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertMultiTableSql, multiParams);
                        }
                    }
                    catch (Throwable e) {
                        tx.markRollback();
                        throw e;
                    }
                }
                UpdateRecordHelper.addRecord((String)"ApproveTypeUpgradeServiceImpl", null, null, (boolean)true);
            }
            result.setSuccess(true);
        }
        catch (Throwable e) {
            result.setLog(CommonServiceHelper.getStackTraceStr((Throwable)e));
        }
        return result;
    }

    private Map<Long, List<Long>> collectApproveTypeInBusiness(Map<Long, List<Long>> approveTypeTemplateMap) {
        Long pkId;
        Row row3;
        Throwable throwable;
        DataSet ds;
        List tasks;
        HashMap<Long, List<Long>> approveTypeInBusiness = new HashMap<Long, List<Long>>(16);
        HashMap<Long, Long> taskApproveTypeMap = new HashMap<Long, Long>(16);
        HashMap<Long, List> taskAndListMap = new HashMap<Long, List>(16);
        String sql = "select fid, fapprovaltypeid, ftasklistid from t_eb_task where fapprovaltypeid != 0";
        try (DataSet ds2 = DB.queryDataSet((String)"queryTask", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds2.hasNext()) {
                Row row2 = ds2.next();
                Long pkId2 = row2.getLong("fid");
                Long approverTypeId = row2.getLong("fapprovaltypeid");
                Long taskListId = row2.getLong("ftasklistid");
                taskApproveTypeMap.put(pkId2, approverTypeId);
                tasks = taskAndListMap.computeIfAbsent(taskListId, k -> new ArrayList(16));
                if (tasks.contains(pkId2)) continue;
                tasks.add(pkId2);
            }
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        if (taskAndListMap.size() != 0) {
            sqlBuilder.append("select fid, fbizmodelid from t_eb_tasklist where ", new Object[0]);
            sqlBuilder.appendIn("fid", taskAndListMap.keySet().toArray());
            ds = DB.queryDataSet((String)"queryTaskListByTask", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
            throwable = null;
            try {
                while (ds.hasNext()) {
                    row3 = ds.next();
                    pkId = row3.getLong("fid");
                    Long bizModelId = row3.getLong("fbizmodelid");
                    tasks = (List)taskAndListMap.get(pkId);
                    if (tasks == null) continue;
                    for (Long task : tasks) {
                        List bizModelIds;
                        Long approveTypeId = (Long)taskApproveTypeMap.get(task);
                        if (approveTypeId == null || (bizModelIds = approveTypeInBusiness.computeIfAbsent(approveTypeId, k -> new ArrayList(16))).contains(bizModelId)) continue;
                        bizModelIds.add(bizModelId);
                    }
                }
            }
            catch (Throwable row3) {
                throwable = row3;
                throw row3;
            }
            finally {
                if (ds != null) {
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable row3) {
                            throwable.addSuppressed(row3);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        if (taskApproveTypeMap.size() != 0) {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid, ftemplateid from t_eb_taskreftemplate where ", new Object[0]);
            sqlBuilder.appendIn("fid", taskApproveTypeMap.keySet().toArray());
            ds = DB.queryDataSet((String)"queryTemplateInTask", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
            throwable = null;
            try {
                while (ds.hasNext()) {
                    List templates;
                    row3 = ds.next();
                    pkId = row3.getLong("fid");
                    Long templateId = row3.getLong("ftemplateid");
                    Long approveTypeId = (Long)taskApproveTypeMap.get(pkId);
                    if (approveTypeId == null || (templates = approveTypeTemplateMap.computeIfAbsent(approveTypeId, k -> new ArrayList(16))).contains(templateId)) continue;
                    templates.add(templateId);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds != null) {
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return approveTypeInBusiness;
    }

    private Map<Long, BasedataPojo> collectAllApproveTypeInfos(Map<Long, Long> approveModelMap, Map<Long, LocaleString> approveNameMap, Map<Long, Object[]> otherValues) {
        HashMap<Long, BasedataPojo> approveTypeInfos = new HashMap<Long, BasedataPojo>(16);
        String sql = "select fid, fnumber, fcreaterid,fcreatedate,fmodifierid,fmodifydate,fdescription,fmodelid from t_eb_approvaltype";
        try (DataSet ds = DB.queryDataSet((String)"queryApproveType", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds.hasNext()) {
                Object[] otherValueArray;
                Row row = ds.next();
                Long pkId = row.getLong("fid");
                Long modelId = row.getLong("fmodelid");
                approveModelMap.put(pkId, modelId);
                BasedataPojo basedataPojo = (BasedataPojo)approveTypeInfos.get(pkId);
                if (basedataPojo == null) {
                    String number = row.getString("fnumber");
                    approveTypeInfos.put(pkId, new BasedataPojo(pkId, "", number));
                }
                if ((otherValueArray = otherValues.get(pkId)) != null) continue;
                otherValueArray = new Object[]{row.getString("fdescription"), row.getLong("fcreaterid"), row.getTimestamp("fcreatedate"), row.getLong("fmodifierid"), row.getTimestamp("fmodifydate")};
                otherValues.put(pkId, otherValueArray);
            }
        }
        if (approveModelMap.size() != 0) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid, fname, flocaleid from t_eb_approvaltype_l where ", new Object[0]);
            sqlBuilder.appendIn("fid", approveModelMap.keySet().toArray());
            try (DataSet ds = DB.queryDataSet((String)"queryApproveTypeMulti", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Long pkId = row.getLong("fid");
                    String name = row.getString("fname");
                    String localeId = row.getString("flocaleid");
                    LocaleString localeString = approveNameMap.get(pkId);
                    if (localeString == null) {
                        localeString = new LocaleString(localeId, name);
                        approveNameMap.put(pkId, localeString);
                        continue;
                    }
                    localeString.setItem(localeId, (Object)name);
                }
            }
        }
        return approveTypeInfos;
    }

    private void buildUpgradeParams(List<Object[]> mainParams, List<Object[]> entryParams, List<Object[]> multiParams, Map<Long, List<Long>> approveTypeTemplateMap, Map<Long, List<Long>> businessApproveTypeMap, Map<Long, LocaleString> approveNameMap, Map<Long, Long> approveModelMap, Map<Long, Object[]> otherValues, Map<Long, BasedataPojo> approveTypeInfos) {
        if (approveTypeInfos.size() == 0) {
            return;
        }
        HashMap bizTemplateMap = new HashMap(16);
        HashSet businessModels = new HashSet(16);
        if (businessApproveTypeMap.size() != 0) {
            businessApproveTypeMap.values().stream().filter(Objects::nonNull).forEach(businessModels::addAll);
        }
        QFilter datasetQFilter = new QFilter("dataset.businessmodel", "in", businessModels);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"eb_templateentity", (String)"id, dataset.businessmodel as bizModel", (QFilter[])new QFilter[]{datasetQFilter});
        templates.forEach(e -> {
            List _templates = bizTemplateMap.computeIfAbsent(e.getLong("bizModel"), k -> new ArrayList(16));
            _templates.add(e.getLong("id"));
        });
        for (Map.Entry<Long, BasedataPojo> approveTypeInfo : approveTypeInfos.entrySet()) {
            Long approveTypeId = approveTypeInfo.getKey();
            BasedataPojo basedataPojo = approveTypeInfo.getValue();
            List<Long> bizModelIds = businessApproveTypeMap.get(approveTypeId);
            List templateIds = approveTypeTemplateMap.getOrDefault(approveTypeId, new ArrayList(16));
            if (bizModelIds == null) {
                this.addUpgradeParam(mainParams, entryParams, multiParams, templateIds, approveNameMap, approveTypeId, approveModelMap, otherValues, basedataPojo, 0L);
                continue;
            }
            for (Long bizModelId : bizModelIds) {
                ArrayList<Long> tmp = new ArrayList<Long>(templateIds);
                List _templateIds = bizTemplateMap.getOrDefault(bizModelId, new ArrayList(16));
                tmp.retainAll(_templateIds);
                this.addUpgradeParam(mainParams, entryParams, multiParams, tmp, approveNameMap, approveTypeId, approveModelMap, otherValues, basedataPojo, bizModelId);
            }
        }
    }

    private void addUpgradeParam(List<Object[]> mainParams, List<Object[]> entryParams, List<Object[]> multiParams, List<Long> templates, Map<Long, LocaleString> approveNameMap, Long approveTypeId, Map<Long, Long> approveModelMap, Map<Long, Object[]> otherValues, BasedataPojo basedataPojo, Long bizModelId) {
        LocaleString name;
        Set localeIds;
        int localeSize;
        long pkId = DB.genGlobalLongId();
        Object[] mainParam = new Object[11];
        mainParam[0] = pkId;
        mainParam[1] = basedataPojo == null ? " " : basedataPojo.getNumber();
        mainParam[2] = approveModelMap.getOrDefault(approveTypeId, 0L);
        mainParam[3] = bizModelId;
        mainParam[4] = "0";
        int templateSize = templates.size();
        mainParam[5] = bizModelId.equals(0L) || templateSize == 0 ? "0" : "1";
        Object[] otherValuesArray = otherValues.getOrDefault(approveTypeId, new Object[5]);
        mainParam[6] = otherValuesArray[0] == null ? " " : otherValuesArray[0];
        mainParam[7] = otherValuesArray[1] == null ? Long.valueOf(0L) : otherValuesArray[1];
        mainParam[8] = otherValuesArray[2] == null ? new Timestamp(System.currentTimeMillis()) : otherValuesArray[2];
        mainParam[9] = otherValuesArray[3] == null ? Long.valueOf(0L) : otherValuesArray[3];
        mainParam[10] = otherValuesArray[4] == null ? new Timestamp(System.currentTimeMillis()) : otherValuesArray[4];
        mainParams.add(mainParam);
        if (templateSize != 0) {
            long[] pkIds = DB.genGlobalLongIds((int)templateSize);
            for (int i = 0; i < templates.size(); ++i) {
                Object[] entryParam = new Object[]{pkId, pkIds[i], templates.get(i)};
                entryParams.add(entryParam);
            }
        }
        if ((localeSize = (localeIds = (name = approveNameMap.getOrDefault(approveTypeId, new LocaleString())).keySet()).size()) != 0) {
            long[] pkIds = DB.genGlobalLongIds((int)localeSize);
            Iterator iterator = localeIds.iterator();
            for (int i = 0; i < localeIds.size(); ++i) {
                Object[] multiParam = new Object[4];
                multiParam[0] = pkId;
                multiParam[1] = pkIds[i];
                String localeId = (String)iterator.next();
                multiParam[2] = localeId;
                multiParam[3] = name.get((Object)localeId) == null ? " " : name.get((Object)localeId);
                multiParams.add(multiParam);
            }
        }
    }
}

