/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.approve;

import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;

public class CentralBillTypeUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            SqlBuilder sqlBuilder;
            String sql = "select fid,fparentbillid from t_eb_approvebill";
            DataSet dataSet = DB.queryDataSet((String)"queryApproveBill", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
            HashSet<Long> normalIds = new HashSet<Long>(16);
            HashSet<Long> mainIds = new HashSet<Long>(16);
            HashSet<Long> subIds = new HashSet<Long>(16);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("fid");
                Long parentId = row.getLong("fparentbillid");
                if (IDUtils.isNull((Long)parentId)) {
                    normalIds.add(id);
                    continue;
                }
                mainIds.add(parentId);
                subIds.add(id);
            }
            if (!normalIds.isEmpty()) {
                sqlBuilder = new SqlBuilder();
                sqlBuilder.append("update t_eb_approvebill set fsplitbilltype='N' where ", new Object[0]);
                sqlBuilder.appendIn("fid", normalIds.toArray());
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
            }
            if (!mainIds.isEmpty()) {
                sqlBuilder = new SqlBuilder();
                sqlBuilder.append("update t_eb_approvebill set fsplitbilltype='M' where ", new Object[0]);
                sqlBuilder.appendIn("fid", mainIds.toArray());
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
            }
            if (!subIds.isEmpty()) {
                sqlBuilder = new SqlBuilder();
                sqlBuilder.append("update t_eb_approvebill set fsplitbilltype='C' where ", new Object[0]);
                sqlBuilder.appendIn("fid", subIds.toArray());
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
            }
            result.setSuccess(true);
        }
        catch (Exception ex) {
            String stackTraceStr = CommonServiceHelper.getStackTraceStr((Throwable)ex);
            result.setSuccess(false);
            result.setErrorInfo(stackTraceStr);
            result.setLog(ex.getMessage());
        }
        return result;
    }
}

