/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.cache.control.BgControlCache;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class BussnessMoldeUpImpl
implements IUpgradeService {
    private static final DBRoute epm = BgBaseConstant.epm;
    private static final String versionTable = "t_eb_controlversion";
    private static final String mateRuleTable = "t_eb_dimmaterulebill";
    private static final String controlRuleTable = "t_eb_controlrulemain";
    private static final String dimmappingTable = "t_eb_dimmembermapping";
    private static final String centralizedTable = "t_eb_centralized_entity";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        List<Long> allBgmdModel = BussnessMoldeUpImpl.getAllBgmdModel();
        if (CollectionUtils.isEmpty(allBgmdModel)) {
            return result;
        }
        Map<Long, Long> bussnessModel = BussnessMoldeUpImpl.getBussnessModel(allBgmdModel, result);
        if (MapUtils.isEmpty(bussnessModel)) {
            return result;
        }
        this.updateRows(versionTable, bussnessModel, true);
        this.updatemateRuleRows(mateRuleTable, bussnessModel);
        this.updateRows(controlRuleTable, bussnessModel, false);
        this.updateRows(dimmappingTable, bussnessModel, true);
        this.updateRows(centralizedTable, bussnessModel, true);
        CacheServiceHelper.clearCacheByScenVer();
        for (Long modelId : allBgmdModel) {
            BgControlCache.clearCentralized((Long)modelId);
        }
        return result;
    }

    private void updatemateRuleRows(String mateRuleTable, Map<Long, Long> bussnessModelAndModel) {
        List<Object[]> controlmateRuleParms = this.getControlMateRuleParms(bussnessModelAndModel);
        if (controlmateRuleParms.isEmpty() || !DB.exitsTable((DBRoute)epm, (String)mateRuleTable)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update  ").append(mateRuleTable).append("  set fbussmodelid = ? where  FEntryID in (select FEntryID from t_eb_dimmateruleapp where fid in (select fid from t_eb_dimmaterule where fmodelid = ?))");
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), controlmateRuleParms);
    }

    private List<Object[]> getControlMateRuleParms(Map<Long, Long> bussnessModel) {
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Long> mapEntry : bussnessModel.entrySet()) {
            updateList.add(new Object[]{mapEntry.getValue(), mapEntry.getKey()});
        }
        return updateList;
    }

    private List<Object[]> getControlVersionParms(Map<Long, Long> bussnessModel) {
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Long> mapEntry : bussnessModel.entrySet()) {
            updateList.add(new Object[]{mapEntry.getValue(), mapEntry.getKey()});
        }
        return updateList;
    }

    public void updateRows(String ebTableName, Map<Long, Long> bussnessModel, boolean isfmodel) {
        List<Object[]> controlVersionParms = this.getControlVersionParms(bussnessModel);
        if (!DB.exitsTable((DBRoute)epm, (String)ebTableName) || controlVersionParms.isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        if (isfmodel) {
            sql.append("update  ").append(ebTableName).append("  set fbussmodelid = ? where fmodel = ?");
        } else {
            sql.append("update  ").append(ebTableName).append("  set fbussmodelid = ? where fmodelid = ?");
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), controlVersionParms);
    }

    public static List<Long> getAllBgmdModel() {
        ArrayList<Long> list = new ArrayList<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"ControlRecordUpImpl", (DBRoute)epm, (String)"select fid,fnumber,fcreatorid from t_eb_model where freporttype = '7'", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                list.add(row.getLong("fid"));
            }
        }
        return list;
    }

    public static Map<Long, Long> getBussnessModel(List<Long> modelList, UpgradeResult result) {
        HashMap<Long, Long> modelAndBuss = new HashMap<Long, Long>(modelList.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fmodel,fbasedatafield from t_eb_bgmcontroldimension where ", new Object[0]);
        sqlBuilder.appendIn("fmodel", modelList.toArray(new Object[0]));
        HashSet<Long> needRemovemodelIds = new HashSet<Long>();
        try (DataSet ds = DB.queryDataSet((String)"ControlRecordUpImpl", (DBRoute)epm, (SqlBuilder)sqlBuilder);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long basedatafieldId = row.getLong("fbasedatafield");
                if (!IDUtils.isNotEmptyLong((Long)basedatafieldId).booleanValue()) continue;
                Long modelId = row.getLong("fmodel");
                if (!modelAndBuss.containsKey(modelId)) {
                    modelAndBuss.put(modelId, row.getLong("fbasedatafield"));
                    continue;
                }
                result.setErrorInfo(ResManager.loadResFormat((String)"\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6\u5b58\u5728\u4e24\u4e2a\u4e1a\u52a1\u6a21\u578b\uff0c\u8bf7\u5148\u5220\u9664\u4e00\u4e2a\u518d\u8fdb\u884c\u624b\u52a8\u5347\u7ea7,fmodelid = %1,fbasedatafield = %2\u3002", (String)"bussnessMoldeUpImpl", (String)"epm-eb-mservice", (Object[])new Object[]{modelId, basedatafieldId}));
                needRemovemodelIds.add(modelId);
            }
        }
        for (Long needRemovemodelId : needRemovemodelIds) {
            modelAndBuss.remove(needRemovemodelId);
        }
        return modelAndBuss;
    }
}

