/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.control;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ControlRecordUpImpl
implements IUpgradeService {
    private static final DBRoute epm = BgBaseConstant.epm;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        List<String> allBgmdModel = ControlRecordUpImpl.getAllBgmdModel();
        if (CollectionUtils.isEmpty(allBgmdModel)) {
            return result;
        }
        Map<Long, Long> bussnessModel = ControlRecordUpImpl.getBussnessModel(allBgmdModel, result);
        if (MapUtils.isEmpty(bussnessModel)) {
            return result;
        }
        ControlRecordUpImpl.creatNewRecordTable(bussnessModel);
        return result;
    }

    public static List<String> getAllBgmdModel() {
        ArrayList<String> list = new ArrayList<String>(16);
        try (DataSet ds = DB.queryDataSet((String)"ControlRecordUpImpl", (DBRoute)epm, (String)"select fid,fnumber,fcreatorid from t_eb_model where freporttype = '7'", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                list.add(row.getString("fid"));
            }
        }
        return list;
    }

    public static Map<Long, Long> getBussnessModel(List<String> modelList, UpgradeResult result) {
        HashMap<Long, Long> modelAndBuss = new HashMap<Long, Long>(modelList.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fmodel,fbasedatafield from t_eb_bgmcontroldimension where ", new Object[0]);
        sqlBuilder.appendIn("fmodel", IDUtils.toLongs(modelList).toArray(new Object[0]));
        try (DataSet ds = DB.queryDataSet((String)"ControlRecordUpImpl", (DBRoute)epm, (SqlBuilder)sqlBuilder);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                if (row.getString("fbasedatafield") == null || row.getString("fbasedatafield").equals("0")) continue;
                if (!modelAndBuss.containsKey(row.getLong("fmodel"))) {
                    modelAndBuss.put(row.getLong("fmodel"), row.getLong("fbasedatafield"));
                    continue;
                }
                result.setErrorInfo(ResManager.loadKDString((String)"\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6\u5b58\u5728\u4e24\u4e2a\u4e1a\u52a1\u6a21\u578b\uff0c\u8bf7\u5148\u5220\u9664\u4e00\u4e2a\u518d\u8fdb\u884c\u624b\u52a8\u5347\u7ea7", (String)"bussnessMoldeUpImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
                modelAndBuss.remove(row.getLong("fmodel"));
            }
        }
        return modelAndBuss;
    }

    public static String getFiledSql(List<String> columnNames) {
        if (columnNames != null && !columnNames.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String s : columnNames) {
                stringBuilder.append(s).append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }
        return null;
    }

    public static List<String> getAllFile(String tableName) {
        List columnNames = DB.getColumnNames((DBRoute)epm, (String)tableName);
        ArrayList<String> columnName_new = new ArrayList<String>(columnNames.size());
        for (String s : columnNames) {
            columnName_new.add(s.toLowerCase());
        }
        return columnName_new;
    }

    private static void creatTable(String table_new, Long bussnessModleId, List<String> filed) {
        if (!DB.exitsTable((DBRoute)epm, (String)table_new)) {
            StringBuilder sql = new StringBuilder();
            sql.append("create table ").append(table_new).append(" (").append("fid bigint not null default 0, fmodelid bigint not null default 0, ").append("fentitynumber nvarchar(80) not null default ' ', fbizid nvarchar(80) not null default ' ',").append("fbiznumber nvarchar(80) not null default ' ', foperation  nvarchar(80) not null default ' ',").append("freqorgunitid bigint not null default 0, forgunitid bigint not null default 0,").append("freqaccountid bigint not null default 0, faccountid bigint not null default 0,").append("fbgperiodid bigint not null default 0, fcurrencyid bigint not null default 0, fversionid bigint not null default 0,").append("fatid bigint not null default 0, fctid bigint not null default 0, ").append("fdtid bigint not null default 0, fmetricid bigint default 0 not null, ").append("famount decimal(19,6) not null default 0, fcreatetime datetime, fcreatorid bigint not null default 0, ").append("fruleid bigint not null default 0, frefbizid nvarchar(80) not null default ' ', fentryid bigint not null default 0,");
            if (!filed.isEmpty()) {
                for (String s : filed) {
                    sql.append(s).append(" bigint not null default 0,");
                }
            }
            sql.deleteCharAt(sql.length() - 1).append(")");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
            String index = BgControlUtils.getBgControlRecordIndexNew((Long)bussnessModleId);
            sql.setLength(0);
            sql.append("create index ").append(index).append(" ON ").append(table_new).append(" (fbizid)");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
            String entityIndex = BgControlUtils.getBgControlRecordEntityIndexNew((Long)bussnessModleId);
            sql.setLength(0);
            sql.append("create index ").append(entityIndex).append(" ON ").append(table_new).append(" (fentitynumber, fbiznumber)");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
            String oaIndex = BgControlUtils.getBgControlRecordOrgAccIndexNew((Long)bussnessModleId);
            sql.setLength(0);
            sql.append("create index ").append(oaIndex).append(" ON ").append(table_new).append(" (fcreatetime, forgunitid, faccountid, fbgperiodid)");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
        }
    }

    public static void creatNewRecordTable(Map<Long, Long> modelAndBuss) {
        StringBuilder updataSql = new StringBuilder();
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
        ArrayList list = Lists.newArrayList((Object[])new String[]{"fid", "fmodelid", "fentitynumber", "fbizid", "fbiznumber", "foperation", "freqorgunitid", "forgunitid", "freqaccountid", "faccountid", "fbgperiodid", "fcurrencyid", "fversionid", "fatid", "fctid", "fdtid", "fmetricid", "famount", "fcreatetime", "fcreatorid", "fruleid", "frefbizid"});
        for (Map.Entry<Long, Long> mapEntry : modelAndBuss.entrySet()) {
            Long modelId = mapEntry.getKey();
            Long bussmodelId = mapEntry.getValue();
            String table_old = "t_eb_cr" + modelId;
            String table_new = BgControlUtils.getBgControlRecordTable((Long)modelId, (Long)bussmodelId);
            List<String> allFile = ControlRecordUpImpl.getAllFile(table_old);
            List<String> notExitList = ControlRecordUpImpl.getNotExitList(list, allFile);
            String alltableFiled = ControlRecordUpImpl.getFiledSql(allFile);
            ControlRecordUpImpl.creatTable(table_new, bussmodelId, notExitList);
            if (!DB.exitsTable((DBRoute)epm, (String)table_old)) continue;
            StringBuilder sql = new StringBuilder();
            updateList.add(new Object[]{table_new, table_old});
            sql.append("TRUNCATE TABLE ").append(table_new);
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
            sql.setLength(0);
            sql.append("insert into ").append(table_new).append("(").append(alltableFiled).append(")").append(" select  ").append(alltableFiled).append("  from ").append(table_old);
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
        }
        updataSql.append("update ").append("t_eb_bgcontrolindex").append(" set FTABLE = ?").append(" where FTABLE = ?");
        if (updateList != null && !updateList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updataSql.toString(), updateList);
        }
    }

    private static List<String> getNotExitList(List<String> list, List<String> allFile) {
        ArrayList<String> list_new = new ArrayList<String>(16);
        list_new.addAll(allFile);
        list_new.removeAll(list);
        return list_new;
    }
}

