/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.control;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class ReceptMappingAddBusinessModelImpl
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        if (UpdateRecordHelper.isUpdated((String)"receptMappingBusiness")) {
            return new UpgradeResult();
        }
        List list = new ArrayList();
        String sql = "select c.fid as mappingid,c.fmodel,c.fbusinessmodel as mappingbsmid ,a.fid as schemeid,a.fmodel as schememodelid,a.fbusinessmodel as schemebsmid from t_eb_recipientmapping c left join t_eb_warnningreceiver b on c.fid =b.fbasedataid left join t_eb_warnningscheme a on (b.fid =a.fid)";
        try (DataSet ds = DB.queryDataSet((String)"queryModel", (DBRoute)BgBaseConstant.epm, (String)sql);){
            if (ds != null) {
                list = CommonServiceHelper.transDataSet((DataSet)ds);
            }
        }
        Map<Long, Long> businessmodelsMap = this.getAnnualBusinessmodel(list.stream().map(k -> IDUtils.toLong(k.get("fmodel"))).collect(Collectors.toSet()));
        HashMap s = Maps.newHashMapWithExpectedSize((int)list.size());
        for (Object m : list) {
            Set a = s.getOrDefault(IDUtils.toLong(m.get("mappingid")), new HashSet());
            a.add(IDUtils.toLong(m.get("schemebsmid")));
            s.put(IDUtils.toLong(m.get("mappingid")), a);
        }
        ArrayList<Object[]> updates = new ArrayList<Object[]>();
        for (Map mappingdata : list) {
            Long modelId = IDUtils.toLong(mappingdata.get("fmodel"));
            if (mappingdata.get("mappingbsmid") != null && !"0".equals(mappingdata.get("mappingbsmid").toString())) continue;
            Long defaultBusinessModel = businessmodelsMap.containsKey(modelId) ? businessmodelsMap.get(modelId) : Long.valueOf(0L);
            boolean iscopy = false;
            if (mappingdata.get("schemeid") != null && mappingdata.get("schemebsmid") != null && !IDUtils.toLong(mappingdata.get("schemebsmid")).equals(defaultBusinessModel)) {
                try {
                    if (((Set)s.get(IDUtils.toLong(mappingdata.get("mappingid")))).size() > 1 && !IDUtils.toLong(mappingdata.get("mappingid")).equals(IDUtils.toLong(mappingdata.get("schemebsmid")))) {
                        iscopy = true;
                    }
                    if (!modelId.equals(IDUtils.toLong(mappingdata.get("schememodelid")))) continue;
                    this.copyReceptAmapping(IDUtils.toLong(mappingdata.get("mappingid")), IDUtils.toLong(mappingdata.get("schemebsmid")), IDUtils.toLong(mappingdata.get("schemeid")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (iscopy) continue;
            updates.add(new Object[]{defaultBusinessModel, mappingdata.get("mappingid")});
        }
        if (updates.size() > 0) {
            String updateSql = "update t_eb_recipientmapping set fbusinessmodel = ? where fid = ?";
            DB.executeBatch((DBRoute)new DBRoute("epm"), (String)updateSql, updates);
        }
        UpdateRecordHelper.addRecord((String)"receptMappingBusiness", null, null, (boolean)true);
        UpgradeResult result = new UpgradeResult();
        return result;
    }

    private void copyReceptAmapping(Long mappingId, Long newBusinessModelId, Long schemaId) {
        Long newMappingId = GlobalIdUtil.genGlobalLongId();
        String insertMappingSql = "insert into t_eb_recipientmapping (fid,forgtype,fnumber,fname,fbgorgmultiview,fdescription,fcreater,fcreatedate,fmodifier,fmodifydate,fmodel,fbusinessmodel)select " + newMappingId + ",forgtype,fnumber,fname,fbgorgmultiview,fdescription,fcreater,fcreatedate,fmodifier,fmodifydate,fmodel," + newBusinessModelId + " from t_eb_recipientmapping where fid =" + mappingId + "";
        String insertMappingLangSql = "insert into t_eb_recipientmapping_l (fpkid,fid,flocaleid,fname,fdescription) select '" + GlobalIdUtil.genStringId() + "'," + newMappingId + ",flocaleid,fname,fdescription  from t_eb_recipientmapping_l where fid =" + mappingId + " and flocaleid = 'zh_CN'";
        String insertMappingEntrySql = "insert into t_eb_recipientmapentry (fid,fentryid,fseq,forgtypeitem,fbgorgview,fstatus,forg) select " + newMappingId + ",(fentryid+10000),fseq,forgtypeitem,fbgorgview,fstatus,forg from t_eb_recipientmapentry where fid =" + mappingId;
        String insertPersionBasedataSql = "insert into t_eb_recipientmapperson (fpkid,fentryid,fbasedataid) select (fentryid+10000),(fentryid+10000),fbasedataid from t_eb_recipientmapperson where fentryid in (select fentryid from t_eb_recipientmapentry where fid = " + mappingId + ")";
        String clearWarnningreceiver = "delete from t_eb_warnningreceiver where fid = " + schemaId + " and fbasedataid=" + mappingId;
        String insertWarnningSchemaMappingSql = "insert into t_eb_warnningreceiver (fpkid,fid,fbasedataid) values (" + GlobalIdUtil.genGlobalLongId() + "," + schemaId + "," + newMappingId + ");";
        try (TXHandle h = TX.requiresNew((String)"upgradereceptmapping");){
            DB.execute((DBRoute)BgBaseConstant.epm, (String)insertMappingSql);
            DB.execute((DBRoute)BgBaseConstant.epm, (String)insertMappingLangSql);
            DB.execute((DBRoute)BgBaseConstant.epm, (String)insertMappingEntrySql);
            DB.execute((DBRoute)BgBaseConstant.epm, (String)insertPersionBasedataSql);
            DB.execute((DBRoute)BgBaseConstant.epm, (String)clearWarnningreceiver);
            DB.execute((DBRoute)BgBaseConstant.epm, (String)insertWarnningSchemaMappingSql);
        }
    }

    private Map<Long, Long> getAnnualBusinessmodel(Set<Long> modelId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fmodelid ,fid from t_eb_businessmodel where", new Object[0]);
        sql.appendIn("fmodelid", modelId.toArray());
        sql.append("and fissyspreset = '1'", new Object[0]);
        List list = new ArrayList();
        try (DataSet ds = DB.queryDataSet((String)"queryModel", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                list = CommonServiceHelper.transDataSet((DataSet)ds);
            }
        }
        return list.stream().collect(Collectors.toMap(k -> IDUtils.toLong(k.get("fmodelid")), v -> IDUtils.toLong(v.get("fid"))));
    }
}

