/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.control;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.constant.BgControlConstant;
import kd.epm.eb.common.ebcommon.common.Tuple;
import kd.epm.eb.common.utils.SqlBatchUtils;

public class UpgradeControlRecordImpl
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        Set<String> crTables = UpgradeControlRecordImpl.getCrTable();
        for (String crTable : crTables) {
            if (!SqlBatchUtils.hasTable((String)crTable)) continue;
            for (Tuple col : BgControlConstant.addCRCols) {
                if (SqlBatchUtils.hasColumn((String)crTable, (String)((String)col.p1))) continue;
                String sql = "alter table " + crTable + " add (" + (String)col.p1 + " " + (String)col.p2 + " default " + (String)col.p3 + " not null)";
                TXHandle tx = TX.requiresNew((String)("checkExist" + crTable + (String)col.p1));
                Throwable throwable = null;
                try {
                    try {
                        DB.execute((DBRoute)BgBaseConstant.epm, (String)sql);
                    }
                    catch (Exception e) {
                        tx.markRollback();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            DB.execute((DBRoute)BgBaseConstant.epm, (String)String.format("EXEC p_AlterColumn '%s', 'FENTRYID', 'VARCHAR(50)', 'NOT NULL', '1111', ''' '''", crTable));
        }
        return result;
    }

    public static Set<String> getCrTable() {
        HashSet<String> crTables = new HashSet<String>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fmodel,fbasedatafield from t_eb_bgmcontroldimension ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"UpgradeControlRecordImpl", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                if (row.getString("fbasedatafield") == null || row.getString("fbasedatafield").equals("0")) continue;
                crTables.add("t_eb_cr" + row.getString("fbasedatafield"));
            }
        }
        return crTables;
    }
}

