/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.controlUpgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.ParamTreeTypeEnum;

public class BudgetControlUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(BudgetControlUpgradeServiceImpl.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"BudgetControlUpgradeServiceImpl");){
            try {
                log.info("budget-control-update begin");
                Long nodeId = this.getNodeId();
                log.info("budget-control-update nodeId=" + nodeId);
                StringBuilder insertSql = new StringBuilder();
                insertSql.append("insert into t_eb_param_setting(fid,fnodeid,fmodelid,fparams,fcreatedate,fmodifydate) values (?,?,?,?,?,?)");
                ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(16);
                Map<Long, String> paramMap = this.getReduceOccupation();
                log.info("budget-control-update paramMap size={}", (Object)paramMap.size());
                for (Map.Entry<Long, String> entry : paramMap.entrySet()) {
                    Long modelId = entry.getKey();
                    String paramJson = entry.getValue();
                    Date date = new Date();
                    sqlParams.add(new Object[]{DBServiceHelper.genGlobalLongId(), nodeId, modelId, paramJson, date, date});
                }
                log.info("budget-control-update sqlParams size={}", (Object)sqlParams.size());
                if (!sqlParams.isEmpty()) {
                    DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)insertSql.toString(), sqlParams);
                }
                result.setSuccess(true);
                log.info("budget-control-update end");
            }
            catch (Throwable ex) {
                log.error(ex);
                tx.markRollback();
                result.setErrorInfo(ex.getMessage());
                result.setSuccess(false);
            }
        }
        return result;
    }

    private Map<Long, String> getReduceOccupation() {
        HashMap<Long, String> paramMap = new HashMap<Long, String>(16);
        String sql = "select fmodelid, freduceadjust, freduceredistribute from t_eb_reduce_occupation where fbussinessmodelid = 0";
        try (DataSet ds = DB.queryDataSet((String)this.getClass().toString(), (DBRoute)BgBaseConstant.epm, (String)sql);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long modelId = row.getLong("fmodelid");
                if (this.checkParamExist(modelId)) continue;
                boolean reduceAdjust = "1".equals(row.getString("freduceadjust"));
                boolean reduceRedistribute = "1".equals(row.getString("freduceredistribute"));
                HashMap<String, Boolean> reduceMap = new HashMap<String, Boolean>(2);
                reduceMap.put("reduce_adjust", reduceAdjust);
                reduceMap.put("reduce_redistribute", reduceRedistribute);
                String paramJson = SerializationUtils.toJsonString(reduceMap);
                paramMap.put(modelId, paramJson);
            }
        }
        return paramMap;
    }

    private boolean checkParamExist(Long modelId) {
        String sql = "select ps.fid from t_eb_param_setting ps, t_eb_param_tree pt where ps.fnodeid=pt.fid and ps.fmodelid = ? and pt.fcode = ?";
        DataSet dataSet = DB.queryDataSet((String)"BudgetControlUpgradeImpl.checkParamExist", (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{modelId, ParamTreeTypeEnum.BUDGET_CONTROL.getCode()});
        return dataSet != null && !dataSet.isEmpty() && dataSet.hasNext();
    }

    private Long getNodeId() {
        Long nodeId = 0L;
        String sql = "select fid from t_eb_param_tree where fcode = ?";
        try (DataSet ds = DB.queryDataSet((String)"BudgetControlUpgradeImpl.getNodeId", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{ParamTreeTypeEnum.BUDGET_CONTROL.getCode()});){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                nodeId = row.getLong("fid");
            }
        }
        return nodeId;
    }
}

