/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.controlUpgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.lang.StringUtils;

public class ControlColumFilterServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"controlcolumfilter");){
            try {
                result = this.updateShowAccountName(result);
                result.setSuccess(true);
            }
            catch (Throwable ex) {
                tx.markRollback();
                result.setErrorInfo(ex.getMessage());
                result.setSuccess(false);
            }
        }
        return result;
    }

    private UpgradeResult updateShowAccountName(UpgradeResult upgradeResult) {
        LinkedList<Long> mainIds = new LinkedList<Long>();
        String sql = "select distinct fid from t_eb_controlruleaccount ";
        try (DataSet ds = DB.queryDataSet((String)"queryAccount", (DBRoute)BgBaseConstant.epm, (String)sql);){
            for (Row row : ds) {
                mainIds.add(row.getLong("fid"));
            }
        }
        QFilter qFilter = new QFilter("id", "in", mainIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgcontrolrulemain", (String)"id,accounts.account.name", (QFilter[])new QFilter[]{qFilter});
        Map<Long, String> maps = query.stream().filter(k -> StringUtils.isNotEmpty((String)k.getString("accounts.account.name"))).collect(Collectors.groupingBy(k -> k.getLong("id"), Collectors.mapping(k -> k.getString("accounts.account.name"), Collectors.joining(","))));
        maps.forEach((k, v) -> {
            String updatesql = "update t_eb_controlrulemain set fshowaccount = ? where fid = ?";
            Object[] param = new Object[]{v, k};
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)v) && v.length() < 600) {
                try {
                    DB.execute((DBRoute)BgBaseConstant.epm, (String)updatesql, (Object[])param);
                }
                catch (Exception e) {
                    upgradeResult.setErrorInfo(e.getMessage());
                    upgradeResult.setLog(upgradeResult.getLog() + e.getMessage());
                    upgradeResult.setSuccess(Boolean.FALSE.booleanValue());
                }
            }
        });
        LinkedList<Long> allMainIds = new LinkedList<Long>();
        sql = "select distinct fid from t_eb_controlrulemain ";
        try (DataSet ds = DB.queryDataSet((String)"queryOrg", (DBRoute)BgBaseConstant.epm, (String)sql);){
            for (Row row : ds) {
                allMainIds.add(row.getLong("fid"));
            }
        }
        List<Map<String, String>> allotorgList = ControlColumFilterServiceImpl.getAllotorgList(allMainIds);
        Map<Long, String> orgRanges = allotorgList.stream().filter(item -> StringUtils.isNotEmpty((String)((String)item.get("orgName")))).collect(Collectors.groupingBy(k -> IDUtils.toLong(k.get("controlrulemainid")), Collectors.mapping(item -> (String)item.get("orgName"), Collectors.joining(","))));
        orgRanges.forEach((k, v) -> {
            String updatesql = "update t_eb_controlrulemain set fshoworgrange = ? where fid = ?";
            Object[] param = new Object[]{v, k};
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)v) && v.length() < 600) {
                try {
                    DB.execute((DBRoute)BgBaseConstant.epm, (String)updatesql, (Object[])param);
                }
                catch (Exception e) {
                    upgradeResult.setErrorInfo(e.getMessage());
                    upgradeResult.setLog(upgradeResult.getLog() + e.getMessage());
                    upgradeResult.setSuccess(Boolean.FALSE.booleanValue());
                }
            }
        });
        return upgradeResult;
    }

    private static List<Map<String, String>> getAllotorgList(List<Long> allMainIds) {
        ArrayList<Map<String, String>> collections = new ArrayList<Map<String, String>>(16);
        try {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select a.fcontrolrulemainid as controlrulemainid,a.fid,c.fid as viewid,c.fname as viewname,c.fnumber as viewnumber,b.fid as dimid,", new Object[0]);
            sqlBuilder.append("b.fnumber as dimname,d.fname as dimname from t_eb_controlruleallot a left join t_eb_structofent b on (a.fallotedorgid = b.fid) ", new Object[0]);
            sqlBuilder.append("left join t_eb_structofent_l d on (b.fid=d.fid ) left join t_eb_viewmember c on (a.fviewid = c.fid ) and ", new Object[0]);
            sqlBuilder.appendIn("a.fcontrolrulemainid", (Object[])allMainIds.toArray(new Long[0]));
            DB.query((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder, doc -> {
                while (doc.next()) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("controlrulemainid", doc.getString("controlrulemainid"));
                    map.put("id", doc.getString("id"));
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)doc.getString("viewname")) && !"0".equals(doc.getString("viewid"))) {
                        map.put("orgId", doc.getString("viewid"));
                        map.put("orgName", doc.getString("viewname"));
                        map.put("orgNumber", doc.getString("viewnumber"));
                        map.put("isView", "1");
                        collections.add(map);
                        continue;
                    }
                    if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)doc.getString("dimname"))) continue;
                    map.put("orgId", doc.getString("dimid"));
                    map.put("orgName", doc.getString("dimname"));
                    map.put("orgNumber", doc.getString("dimnumber"));
                    map.put("isView", "0");
                    collections.add(map);
                }
                return collections;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return collections;
    }
}

