/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.controlUpgrade;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.ebcommon.common.enums.StorageTypeEnum;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.SqlBatchUtils;

public class ControlRecordServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(ControlRecordServiceImpl.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"controlRecordUpdate");){
            try {
                result = this.update(result);
                result.setSuccess(true);
            }
            catch (Throwable ex) {
                tx.markRollback();
                result.setErrorInfo(ex.getMessage());
                result.setSuccess(false);
            }
        }
        return result;
    }

    public void updateRecord() {
        try (TXHandle tx = TX.requiresNew((String)"controlRecordUpdate");){
            try {
                this.update(null);
            }
            catch (Throwable ex) {
                tx.markRollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult update(UpgradeResult result) {
        block64: {
            if (result == null) {
                result = new UpgradeResult();
            }
            LogStats stats = new LogStats("budget-update-log : ");
            stats.addInfo("begin-update-bgControlRecord.");
            LinkedHashSet accounts = Sets.newLinkedHashSet();
            try {
                String sql = "select distinct faccountid from t_eb_bgcontrolrecord where faccountid not in (select fid from t_eb_structofaccount)";
                try (DataSet ds = DB.queryDataSet((String)"queryAccount", (DBRoute)BgBaseConstant.epm, (String)sql);){
                    for (Row row : ds) {
                        accounts.add(row.getLong("faccountid"));
                    }
                }
                sql = "select distinct freqaccountid from t_eb_bgcontrolrecord where freqaccountid not in (select fid from t_eb_structofaccount)";
                ds = DB.queryDataSet((String)"queryAccount", (DBRoute)BgBaseConstant.epm, (String)sql);
                var6_6 = null;
                try {
                    for (Row row : ds) {
                        accounts.add(row.getLong("freqaccountid"));
                    }
                }
                catch (Throwable throwable) {
                    var6_6 = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (var6_6 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                var6_6.addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                if (!accounts.isEmpty()) {
                    stats.addInfo("share member size = " + accounts.size());
                    LinkedHashMap shareMembers = Maps.newLinkedHashMap();
                    Map shareMember = null;
                    LinkedHashMap noShareMembers = Maps.newLinkedHashMap();
                    Map noShareMember = null;
                    Long modelId = null;
                    if (SqlBatchUtils.hasTable((DBRoute)BgBaseConstant.bcm, (String)"t_bcm_structofaccount")) {
                        Object row;
                        SqlBuilder sqlBuilder = new SqlBuilder();
                        sqlBuilder.append("select fid, fnumber, fmodelid from t_bcm_structofaccount where FStorageType = '" + StorageTypeEnum.SHARE.getOIndex() + "' and ", new Object[0]);
                        sqlBuilder.appendIn("fid", (Object[])accounts.toArray(new Long[accounts.size()]));
                        Throwable throwable = null;
                        try (DataSet ds = DB.queryDataSet((String)"queryShareMember", (DBRoute)DBRoute.of((String)"bcm"), (SqlBuilder)sqlBuilder);){
                            Iterator iterator = ds.iterator();
                            while (iterator.hasNext()) {
                                row = (Row)iterator.next();
                                shareMember = shareMembers.computeIfAbsent(row.getLong("fmodelid"), f -> Maps.newLinkedHashMap());
                                shareMember.put(row.getString("fnumber"), row.getLong("fid"));
                            }
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3 = throwable2;
                            throw throwable2;
                        }
                        for (Map.Entry entry : shareMembers.entrySet()) {
                            modelId = (Long)entry.getKey();
                            shareMember = (Map)entry.getValue();
                            sqlBuilder = new SqlBuilder();
                            sqlBuilder.append("select fid, fnumber from t_bcm_structofaccount where ", new Object[0]);
                            sqlBuilder.append("fmodelid = ?", new Object[]{modelId});
                            sqlBuilder.append(" and FStorageType <> '" + StorageTypeEnum.SHARE.getOIndex() + "' and ", new Object[0]);
                            sqlBuilder.appendIn("fnumber", (Object[])shareMember.keySet().toArray(new String[shareMember.size()]));
                            DataSet ds = DB.queryDataSet((String)"queryShareMember", (DBRoute)DBRoute.of((String)"bcm"), (SqlBuilder)sqlBuilder);
                            row = null;
                            try {
                                for (Row row2 : ds) {
                                    noShareMember = noShareMembers.computeIfAbsent(modelId, f -> Maps.newLinkedHashMap());
                                    noShareMember.put(row2.getString("fnumber"), row2.getLong("fid"));
                                }
                            }
                            catch (Throwable throwable4) {
                                row = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (ds == null) continue;
                                if (row != null) {
                                    try {
                                        ds.close();
                                    }
                                    catch (Throwable throwable5) {
                                        ((Throwable)row).addSuppressed(throwable5);
                                    }
                                    continue;
                                }
                                ds.close();
                            }
                        }
                    }
                    ArrayList<Object[]> arrayList = new ArrayList<Object[]>(shareMembers.size());
                    for (Map.Entry model : shareMembers.entrySet()) {
                        modelId = (Long)model.getKey();
                        shareMember = (Map)model.getValue();
                        noShareMember = (Map)noShareMembers.get(modelId);
                        if (shareMember == null || noShareMember == null) continue;
                        for (Map.Entry sMember : shareMember.entrySet()) {
                            Long sId = (Long)sMember.getValue();
                            Long nsId = (Long)noShareMember.get(sMember.getKey());
                            if (sId == null || sId == 0L || nsId == null || nsId == 0L) continue;
                            arrayList.add(new Object[]{nsId, modelId, sId});
                        }
                    }
                    if (!arrayList.isEmpty()) {
                        stats.addInfo("update-size = " + arrayList.size());
                        sql = "update t_eb_bgcontrolrecord set faccountid = ? where fmodelid = ? and faccountid = ?";
                        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, arrayList);
                        sql = "update t_eb_bgcontrolrecord set freqaccountid = ? where fmodelid = ? and freqaccountid = ?";
                        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, arrayList);
                    } else {
                        stats.addInfo("no update size.");
                    }
                    break block64;
                }
                stats.addInfo("no share Member.");
            }
            finally {
                stats.addInfo("end-update-bgControlRecord.");
                result.setLog(stats.toString());
                log.info(result.getLog());
            }
        }
        return result;
    }
}

