/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.controlUpgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.billlist.BillListUtil;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;

public class FieldRegisterUpgradeServiceImpl
implements IUpgradeService {
    private static final Map<String, List<Map<String, String>>> PRESETBILLSETS = new LinkedHashMap(){
        {
            this.put("er_dailyreimbursebill", Lists.newArrayList((Object[])new 1[]{new HashMap(){
                {
                    this.put("number", "BXUP");
                    this.put("name", ResManager.loadKDString((String)"\u8d39\u7528\u62a5\u9500\u5355\u51b2\u9500\u65b9\u6848\uff08\u5347\u7ea7\uff09", (String)"WriteoffSchemePlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.put("writeoffbill", "er_dailyloanbill");
                    this.put("writeoffsourcebillentry", "expenseentryentity");
                    this.put("writeoffsourcebill", "writeoffmoney.sourcebillid");
                    this.put("writeoffentry", "writeoffmoney.sourceentryid");
                    this.put("writeofftype", "occupationwriteoff");
                    this.put("writeoffvalue", "writeoffmoney.accloanamount");
                }
            }}));
            this.put("er_publicreimbursebill", Lists.newArrayList((Object[])new 2[]{new HashMap(){
                {
                    this.put("number", "DGBXUP");
                    this.put("name", ResManager.loadKDString((String)"\u5bf9\u516c\u62a5\u9500\u5355\u51b2\u9500\u65b9\u6848\uff08\u5347\u7ea7\uff09", (String)"WriteoffSchemePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.put("writeoffbill", "er_dailyloanbill");
                    this.put("writeoffsourcebillentry", "expenseentryentity");
                    this.put("writeoffsourcebill", "writeoffmoney.sourcebillid");
                    this.put("writeoffentry", "writeoffmoney.sourceentryid");
                    this.put("writeofftype", "occupationwriteoff");
                    this.put("writeoffvalue", "writeoffmoney.accloanamount");
                }
            }}));
            this.put("er_tripreimbursebill", Lists.newArrayList((Object[])new 3[]{new HashMap(){
                {
                    this.put("number", "CLBXUP");
                    this.put("name", ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u5355\u51b2\u9500\u65b9\u6848\uff08\u5347\u7ea7\uff09", (String)"WriteoffSchemePlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.put("writeoffbill", "er_dailyloanbill");
                    this.put("writeoffsourcebillentry", "expenseentryentity");
                    this.put("writeoffsourcebill", "clearloanentry.loanbillid");
                    this.put("writeoffentry", "clearloanentry.reqaccountentryid");
                    this.put("writeofftype", "occupationwriteoff");
                    this.put("writeoffvalue", "clearloanentry.loanclearoriamount");
                }
            }}));
        }
    };

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"fieldregisterupgrade");){
            try {
                DataSet allpresetdatas = DB.queryDataSet((String)"presetdatas", (DBRoute)DBRoute.of((String)"epm"), (String)"select distinct billnumber,controldim,columnnum,columnname,isprefab from t_eb_presetbillField", (Object[])new Object[0]);
                LinkedList<2> al = new LinkedList<2>();
                while (allpresetdatas.hasNext()) {
                    final Row next = allpresetdatas.next();
                    al.add(new HashMap(){
                        {
                            this.put("billnumber", next.getString("billnumber"));
                            this.put("controlDim", next.getString("controldim"));
                            this.put("column", next.getString("columnnum"));
                            this.put("columnName", next.getString("columnname"));
                            this.put("isprefab", next.getString("isprefab"));
                        }
                    });
                }
                allpresetdatas.close();
                Map<String, List<Map>> billnumber = al.stream().collect(Collectors.groupingBy(k -> (String)k.get("billnumber")));
                Iterator<Map.Entry<String, List<Map>>> iterator = billnumber.entrySet().iterator();
                LinkedList<Object[]> conbizRegDataParam = new LinkedList<Object[]>();
                LinkedList<Object[]> conbizRegEntityParam = new LinkedList<Object[]>();
                LinkedList<Object[]> controlBizRegParam = new LinkedList<Object[]>();
                LinkedList<Object[]> controlBizRegLanguageParam = new LinkedList<Object[]>();
                while (iterator.hasNext()) {
                    Map.Entry<String, List<Map>> next = iterator.next();
                    String billNumber = next.getKey();
                    List<Map> cols = next.getValue();
                    HashMap<String, Long> parentBill = new HashMap<String, Long>(16);
                    Long billId = this.getregistBillId(billNumber, parentBill);
                    Long applicationId = (Long)parentBill.get("bill");
                    String applicationNumber = this.getApplicationByBillNumber(billNumber);
                    if (IDUtils.isEmptyLong((Long)billId).booleanValue()) continue;
                    String controlbizregSql = "select t1.fid,t1.ffielddimension ,t1.fbill ,t1.ffieldtable,t2.fnumber from t_eb_conbizregdata t1 left join t_eb_conbizregentity t2 on t1.fid = t2.fid where t1.fbill = ? and t1.ffielddimension = ?";
                    cols.forEach(map -> {
                        Long bizregDataId;
                        String typeName = BillFieldTypeEmum.getNameByNumber((String)((String)map.get("controlDim")));
                        DataSet dataSet = DB.queryDataSet((String)"controlbizreg", (DBRoute)DBRoute.of((String)"epm"), (String)controlbizregSql, (Object[])new Object[]{billId, typeName});
                        ArrayList<3> bizreg = new ArrayList<3>(16);
                        for (final Row row : dataSet) {
                            bizreg.add(new HashMap(){
                                {
                                    this.put("id", row.getString("fid"));
                                    this.put("billId", row.getString("fbill"));
                                    this.put("number", row.getString("fnumber"));
                                }
                            });
                        }
                        if (!CollectionUtils.isEmpty(bizreg)) {
                            if (!bizreg.stream().anyMatch(item -> ((String)map.get("column")).equalsIgnoreCase((String)item.get("number")))) {
                                bizregDataId = IDUtils.toLong(((Map)bizreg.get(0)).get("id"));
                                Long bizregEntityId = DBServiceHelper.genGlobalLongId();
                                Long bizregId = DBServiceHelper.genGlobalLongId();
                                conbizRegEntityParam.add(new Object[]{bizregDataId, bizregEntityId, map.get("column"), map.get("columnName"), map.get("isprefab")});
                                controlBizRegParam.add(new Object[]{bizregId, map.get("column"), map.get("column"), applicationId, BillListUtil.getResName((String)applicationNumber), billId, BillListUtil.getResName((String)billNumber), billNumber, map.get("controlDim"), typeName, map.get("isprefab"), TimeServiceHelper.now()});
                                String uid = UUID.randomUUID().toString().substring(0, 20);
                                controlBizRegLanguageParam.add(new Object[]{bizregId, uid, "zh_CN", map.get("columnName")});
                            }
                        } else {
                            bizregDataId = 0L;
                            List objects = conbizRegDataParam.stream().filter(o -> billId.equals(o[2]) && typeName.equals(o[1])).collect(Collectors.toList());
                            if (CollectionUtils.isEmpty(objects)) {
                                bizregDataId = DBServiceHelper.genGlobalLongId();
                                conbizRegDataParam.add(new Object[]{bizregDataId, typeName, billId, billNumber});
                            } else {
                                bizregDataId = IDUtils.toLong((Object)((Object[])objects.get(0))[0]);
                            }
                            Long bizregEntityId = DBServiceHelper.genGlobalLongId();
                            Long bizregId = DBServiceHelper.genGlobalLongId();
                            conbizRegEntityParam.add(new Object[]{bizregDataId, bizregEntityId, map.get("column"), map.get("columnName"), map.get("isprefab")});
                            controlBizRegParam.add(new Object[]{bizregId, map.get("column"), map.get("column"), applicationId, BillListUtil.getResName((String)applicationNumber), billId, BillListUtil.getResName((String)billNumber), billNumber, map.get("controlDim"), typeName, map.get("isprefab"), TimeServiceHelper.now()});
                            String uid = UUID.randomUUID().toString().substring(0, 20);
                            controlBizRegLanguageParam.add(new Object[]{bizregId, uid, "zh_CN", map.get("columnName")});
                        }
                    });
                }
                this.saveField(conbizRegDataParam, conbizRegEntityParam, controlBizRegParam, controlBizRegLanguageParam);
                DataSet dataSet = DB.queryDataSet((String)"queryAllBillId", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fnumber from t_eb_structofbill where fbilltype = 'bill'");
                LinkedList<4> allBill = new LinkedList<4>();
                while (dataSet.hasNext()) {
                    final Row next = dataSet.next();
                    allBill.add(new HashMap(){
                        {
                            this.put("fid", next.getString("fid"));
                            this.put("fnumber", next.getString("fnumber"));
                        }
                    });
                }
                HashMap billNummapping = new HashMap(allBill.size());
                allBill.forEach(bill -> billNummapping.put(bill.get("fnumber"), IDUtils.toLong(bill.get("fid"))));
                DataSet bizreg = DB.queryDataSet((String)"querywriteoffbizreg", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fnumber,ffieldtable from t_eb_bgcontrolbizreg where ftype = 'WRITEOFFFIELD'");
                LinkedList<5> bizregmap = new LinkedList<5>();
                while (bizreg.hasNext()) {
                    final Row next = bizreg.next();
                    bizregmap.add(new HashMap(){
                        {
                            this.put("fid", next.getString("fid"));
                            this.put("fnumber", next.getString("fnumber"));
                            this.put("ffieldtable", next.getString("ffieldtable"));
                        }
                    });
                }
                Map<String, Long> bizregmapping = bizregmap.stream().collect(Collectors.toMap(k -> (String)k.get("ffieldtable") + "##" + (String)k.get("fnumber"), v -> IDUtils.toLong(v.get("fid")), BinaryOperator.maxBy(Comparator.comparingLong(v -> v))));
                Long w1 = DBServiceHelper.genGlobalLongId();
                String random = UUID.randomUUID().toString();
                String prex = "BXCX-" + random.substring(random.length() - 6).toUpperCase();
                String currentBill = "er_dailyreimbursebill";
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffscheme (fid,fnumber,fname,fbill) values (?,?,?,?);", (Object[])new Object[]{w1, prex, ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u9884\u7f6e\u51b2\u9500\u65b9\u6848", (String)"FieldRegisterUpgradeServiceImpl_28", (String)"epm-eb-mservice", (Object[])new Object[0]), billNummapping.get(currentBill)});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffscheme_l (fid,fpkid,flocaleid,fname) values (?,?,?,?);", (Object[])new Object[]{w1, DBServiceHelper.genStringId(), "zh_CN", ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u9884\u7f6e\u51b2\u9500\u65b9\u6848", (String)"FieldRegisterUpgradeServiceImpl_28", (String)"epm-eb-mservice", (Object[])new Object[0])});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffinfoselect (fid,fentryid,fwriteoffbill,fwriteoffsourcebillentry,fwriteoffsourcebill,fwriteoffentry,fwriteofftype,fwriteoffvalue) values (?,?,?,?,?,?,?,?);", (Object[])new Object[]{w1, DBServiceHelper.genGlobalLongId(), billNummapping.get("er_dailyloanbill"), bizregmapping.get("er_dailyloanbill##expenseentryentity"), bizregmapping.get(currentBill + "##writeoffmoney.sourcebillid"), bizregmapping.get(currentBill + "##writeoffmoney.sourceentryid"), "occupationwriteoff", bizregmapping.get(currentBill + "##writeoffmoney.accloanamount")});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffinfoselect (fid,fentryid,fwriteoffbill,fwriteoffsourcebillentry,fwriteoffsourcebill,fwriteoffentry,fwriteofftype,fwriteoffvalue) values (?,?,?,?,?,?,?,?);", (Object[])new Object[]{w1, DBServiceHelper.genGlobalLongId(), billNummapping.get("er_dailyapplybill"), bizregmapping.get("er_dailyapplybill##expenseentryentity"), bizregmapping.get(currentBill + "##writeoffapply.sourceapplybillid"), bizregmapping.get(currentBill + "##writeoffapply.sourceapplyentryid"), "occupationwriteoff", bizregmapping.get(currentBill + "##writeoffapply.reimbursedamount")});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffinfoselect (fid,fentryid,fwriteoffbill,fwriteoffsourcebillentry,fwriteoffsourcebill,fwriteoffentry,fwriteofftype,fwriteoffvalue) values (?,?,?,?,?,?,?,?);", (Object[])new Object[]{w1, DBServiceHelper.genGlobalLongId(), billNummapping.get("er_tripreqbill"), bizregmapping.get("er_tripreqbill##tripentry"), bizregmapping.get(currentBill + "##writeoffmoney.sourcebillid"), bizregmapping.get(currentBill + "##writeoffmoney.sourceentryid"), "occupationwriteoff", bizregmapping.get(currentBill + "##writeoffmoney.accloanamount")});
                Long w2 = DBServiceHelper.genGlobalLongId();
                random = UUID.randomUUID().toString();
                prex = "DGBXCX-" + random.substring(random.length() - 6).toUpperCase();
                currentBill = "er_publicreimbursebill";
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffscheme (fid,fnumber,fname,fbill) values (?,?,?,?);", (Object[])new Object[]{w2, prex, ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u9884\u7f6e\u51b2\u9500\u65b9\u6848", (String)"FieldRegisterUpgradeServiceImpl_28", (String)"epm-eb-mservice", (Object[])new Object[0]), billNummapping.get(currentBill)});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffscheme_l (fid,fpkid,flocaleid,fname) values (?,?,?,?);", (Object[])new Object[]{w2, DBServiceHelper.genStringId(), "zh_CN", ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u9884\u7f6e\u51b2\u9500\u65b9\u6848", (String)"FieldRegisterUpgradeServiceImpl_28", (String)"epm-eb-mservice", (Object[])new Object[0])});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffinfoselect (fid,fentryid,fwriteoffbill,fwriteoffsourcebillentry,fwriteoffsourcebill,fwriteoffentry,fwriteofftype,fwriteoffvalue) values (?,?,?,?,?,?,?,?);", (Object[])new Object[]{w2, DBServiceHelper.genGlobalLongId(), billNummapping.get("er_dailyloanbill"), bizregmapping.get("er_dailyloanbill##expenseentryentity"), bizregmapping.get(currentBill + "##writeoffmoney.sourcebillid"), bizregmapping.get(currentBill + "##writeoffmoney.sourceentryid"), "occupationwriteoff", bizregmapping.get(currentBill + "##writeoffmoney.accloanamount")});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffinfoselect (fid,fentryid,fwriteoffbill,fwriteoffsourcebillentry,fwriteoffsourcebill,fwriteoffentry,fwriteofftype,fwriteoffvalue) values (?,?,?,?,?,?,?,?);", (Object[])new Object[]{w2, DBServiceHelper.genGlobalLongId(), billNummapping.get("er_dailyapplybill"), bizregmapping.get("er_dailyapplybill##expenseentryentity"), bizregmapping.get(currentBill + "##writeoffapply.sourceapplybillid"), bizregmapping.get(currentBill + "##writeoffapply.sourceapplyentryid"), "occupationwriteoff", bizregmapping.get(currentBill + "##writeoffapply.reimbursedamount")});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffinfoselect (fid,fentryid,fwriteoffbill,fwriteoffsourcebillentry,fwriteoffsourcebill,fwriteoffentry,fwriteofftype,fwriteoffvalue) values (?,?,?,?,?,?,?,?);", (Object[])new Object[]{w2, DBServiceHelper.genGlobalLongId(), billNummapping.get("er_prepaybill"), bizregmapping.get("er_prepaybill##expenseentryentity"), bizregmapping.get(currentBill + "##writeoffmoney.sourcebillid"), bizregmapping.get(currentBill + "##writeoffmoney.sourceentryid"), "occupationwriteoff", bizregmapping.get(currentBill + "##writeoffmoney.accloanamount")});
                Long w3 = DBServiceHelper.genGlobalLongId();
                random = UUID.randomUUID().toString();
                prex = "KDCCX-" + random.substring(random.length() - 6).toUpperCase();
                currentBill = "er_tripreimbursebill";
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffscheme (fid,fnumber,fname,fbill) values (?,?,?,?);", (Object[])new Object[]{w3, prex, ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u9884\u7f6e\u51b2\u9500\u65b9\u6848", (String)"FieldRegisterUpgradeServiceImpl_28", (String)"epm-eb-mservice", (Object[])new Object[0]), billNummapping.get(currentBill)});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffscheme_l (fid,fpkid,flocaleid,fname) values (?,?,?,?);", (Object[])new Object[]{w3, DBServiceHelper.genStringId(), "zh_CN", ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u9884\u7f6e\u51b2\u9500\u65b9\u6848", (String)"FieldRegisterUpgradeServiceImpl_28", (String)"epm-eb-mservice", (Object[])new Object[0])});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffinfoselect (fid,fentryid,fwriteoffbill,fwriteoffsourcebillentry,fwriteoffsourcebill,fwriteoffentry,fwriteofftype,fwriteoffvalue) values (?,?,?,?,?,?,?,?);", (Object[])new Object[]{w3, DBServiceHelper.genGlobalLongId(), billNummapping.get("er_dailyloanbill"), bizregmapping.get("er_dailyloanbill##expenseentryentity"), bizregmapping.get(currentBill + "##clearloanentry.loanbillid"), bizregmapping.get(currentBill + "##clearloanentry.reqaccountentryid"), "occupationwriteoff", bizregmapping.get(currentBill + "##clearloanentry.loanclearoriamount")});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffinfoselect (fid,fentryid,fwriteoffbill,fwriteoffsourcebillentry,fwriteoffsourcebill,fwriteoffentry,fwriteofftype,fwriteoffvalue) values (?,?,?,?,?,?,?,?);", (Object[])new Object[]{w3, DBServiceHelper.genGlobalLongId(), billNummapping.get("er_tripreqbill"), bizregmapping.get("er_tripreqbill##tripentry"), bizregmapping.get(currentBill + "##sourcebillid"), 0L, "occupationwriteoff", bizregmapping.get(currentBill + "##writeoffapply.applyamount")});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffinfoselect (fid,fentryid,fwriteoffbill,fwriteoffsourcebillentry,fwriteoffsourcebill,fwriteoffentry,fwriteofftype,fwriteoffvalue) values (?,?,?,?,?,?,?,?);", (Object[])new Object[]{w3, DBServiceHelper.genGlobalLongId(), billNummapping.get("er_tripreqbill"), bizregmapping.get("er_tripreqbill##tripentry"), bizregmapping.get(currentBill + "##clearloanentry.loanbillid"), bizregmapping.get(currentBill + "##clearloanentry.reqaccountentryid"), "occupationwriteoff", bizregmapping.get(currentBill + "##clearloanentry.loanclearoriamount")});
                Long w4 = DBServiceHelper.genGlobalLongId();
                random = UUID.randomUUID().toString();
                prex = "FTCX-" + random.substring(random.length() - 6).toUpperCase();
                currentBill = "er_expensesharebill";
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffscheme (fid,fnumber,fname,fbill) values (?,?,?,?);", (Object[])new Object[]{w4, prex, ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u9884\u7f6e\u51b2\u9500\u65b9\u6848", (String)"FieldRegisterUpgradeServiceImpl_28", (String)"epm-eb-mservice", (Object[])new Object[0]), billNummapping.get(currentBill)});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffscheme_l (fid,fpkid,flocaleid,fname) values (?,?,?,?);", (Object[])new Object[]{w4, DBServiceHelper.genStringId(), "zh_CN", ResManager.loadKDString((String)"\u8d39\u7528\u5355\u636e\u9884\u7f6e\u51b2\u9500\u65b9\u6848", (String)"FieldRegisterUpgradeServiceImpl_28", (String)"epm-eb-mservice", (Object[])new Object[0])});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffinfoselect (fid,fentryid,fwriteoffbill,fwriteoffsourcebillentry,fwriteoffsourcebill,fwriteoffentry,fwriteofftype,fwriteoffvalue) values (?,?,?,?,?,?,?,?);", (Object[])new Object[]{w4, DBServiceHelper.genGlobalLongId(), billNummapping.get("er_dailyreimbursebill"), bizregmapping.get("er_dailyreimbursebill##expenseentryentity"), bizregmapping.get(currentBill + "##expenseentryentity_wait.sourcebillid"), bizregmapping.get(currentBill + "##expenseentryentity_wait.sourceentryid"), "excutewriteoff", bizregmapping.get(currentBill + "##expenseentryentity_wait.expenseamount_wait")});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffinfoselect (fid,fentryid,fwriteoffbill,fwriteoffsourcebillentry,fwriteoffsourcebill,fwriteoffentry,fwriteofftype,fwriteoffvalue) values (?,?,?,?,?,?,?,?);", (Object[])new Object[]{w4, DBServiceHelper.genGlobalLongId(), billNummapping.get("er_tripreimbursebill"), bizregmapping.get("er_tripreimbursebill##tripentry"), bizregmapping.get(currentBill + "##expenseentryentity_wait.sourcebillid"), bizregmapping.get(currentBill + "##expenseentryentity_wait.sourceentryid"), "excutewriteoff", bizregmapping.get(currentBill + "##expenseentryentity_wait.expenseamount_wait")});
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffinfoselect (fid,fentryid,fwriteoffbill,fwriteoffsourcebillentry,fwriteoffsourcebill,fwriteoffentry,fwriteofftype,fwriteoffvalue) values (?,?,?,?,?,?,?,?);", (Object[])new Object[]{w4, DBServiceHelper.genGlobalLongId(), billNummapping.get("er_publicreimbursebill"), bizregmapping.get("er_publicreimbursebill##expenseentryentity"), bizregmapping.get(currentBill + "##expenseentryentity_wait.sourcebillid"), bizregmapping.get(currentBill + "##expenseentryentity_wait.sourceentryid"), "excutewriteoff", bizregmapping.get(currentBill + "##expenseentryentity_wait.expenseamount_wait")});
                try {
                    Object[] billids = new Object[]{billNummapping.get("er_dailyreimbursebill"), billNummapping.get("er_publicreimbursebill"), billNummapping.get("er_tripreimbursebill")};
                    Iterator<Map.Entry<String, List<Map<String, String>>>> it = PRESETBILLSETS.entrySet().iterator();
                    ArrayList<Object[]> writeoffs = new ArrayList<Object[]>();
                    ArrayList<Object[]> writeoffselect = new ArrayList<Object[]>();
                    ArrayList<Object[]> processs = new ArrayList<Object[]>();
                    while (it.hasNext()) {
                        Map.Entry<String, List<Map<String, String>>> next = it.next();
                        String billNumber = next.getKey();
                        DataSet processentitys = DB.queryDataSet((String)"querycontrolprocess", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fentryid,fbill,fwriteoffs,fwriteoffsfield,fwriteoffsfieldcn from t_eb_bgconprocessentry where fbill = ? and fwriteoffs = '1';", (Object[])new Object[]{billNummapping.get(billNumber)});
                        while (processentitys.hasNext()) {
                            Row processentity = processentitys.next();
                            if (!"1".equals(processentity.getString("fwriteoffs"))) continue;
                            Long writeoffId = DBServiceHelper.genGlobalLongId();
                            Map<String, String> schemeMap = PRESETBILLSETS.get(billNumber).get(0);
                            String r = UUID.randomUUID().toString();
                            String p = "-" + r.substring(r.length() - 6).toUpperCase();
                            String schemeName = schemeMap.get("name") + p;
                            String scheNumber = schemeMap.get("number") + p;
                            Long fbill = processentity.getLong("fbill");
                            String writeoffsfield = processentity.getString("fwriteoffsfield");
                            Long writeoffValue = 0L;
                            writeoffValue = writeoffsfield != null && !"".equals(writeoffsfield) ? (bizregmapping.containsKey(billNumber + "##" + writeoffsfield) ? bizregmapping.get(billNumber + "##" + writeoffsfield) : bizregmapping.get(billNumber + "##" + schemeMap.get("writeoffvalue"))) : bizregmapping.get(billNumber + "##" + schemeMap.get("writeoffvalue"));
                            writeoffs.add(new Object[]{writeoffId, scheNumber, schemeName, schemeName, fbill});
                            Long entryid = DBServiceHelper.genGlobalLongId();
                            String writeoffBill = schemeMap.get("writeoffbill");
                            writeoffselect.add(new Object[]{writeoffId, entryid, billNummapping.get(writeoffBill), schemeMap.get("writeofftype"), bizregmapping.get(billNumber + "##" + schemeMap.get("writeoffsourcebill")), bizregmapping.get(billNumber + "##" + schemeMap.get("writeoffentry")), writeoffValue, bizregmapping.get(writeoffBill + "##" + schemeMap.get("writeoffsourcebillentry"))});
                            processs.add(new Object[]{writeoffId, schemeName, processentity.getLong("fentryid")});
                        }
                    }
                    if (writeoffs.size() > 0) {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffscheme (fid,fnumber,fname,fremark,fbill) values (?,?,?,?,?)", writeoffs);
                    }
                    if (writeoffselect.size() > 0) {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)"insert into t_eb_writeoffinfoselect (fid,fentryid,fwriteoffbill,fwriteofftype,fwriteoffsourcebill,fwriteoffentry,fwriteoffvalue,fwriteoffsourcebillentry ) values (?,?,?,?,?,?,?,?)", writeoffselect);
                    }
                    if (processs.size() > 0) {
                        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)"update t_eb_bgconprocessentry set fwriteoffscheme = ?,fwriteoffschemecn=? where fentryid = ?", processs);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                result.setSuccess(true);
            }
            catch (Throwable ex) {
                tx.markRollback();
                result.setErrorInfo(CommonServiceHelper.getStackTraceStr((Throwable)ex));
                result.setSuccess(false);
            }
        }
        return result;
    }

    private Long getregistBillId(String billNumber, Map<String, Long> parentMap) {
        String billRegisterSql = "select fid,fnumber,fparentid from t_eb_structofbill where fnumber = ?";
        Long billId = (Long)DB.query((DBRoute)DBRoute.of((String)"epm"), (String)billRegisterSql, (Object[])new Object[]{billNumber}, rs -> {
            if (rs.next()) {
                parentMap.put("bill", rs.getLong("fparentid"));
                return rs.getLong("fid");
            }
            String parentBillNum = this.getApplicationByBillNumber(billNumber);
            String billType = "bill";
            if (Arrays.asList("ESC", "FI").contains(billNumber)) {
                billType = "cloud";
            } else if (Arrays.asList("exp", "tra", "em", "cal").contains(billNumber)) {
                billType = "application";
            }
            Long pBillId = this.getregistBillId(parentBillNum, new HashMap<String, Long>());
            Long bid = DBServiceHelper.genGlobalLongId();
            parentMap.put("bill", pBillId);
            return this.saveStructOfBill(bid, pBillId, billNumber, billType);
        });
        return billId;
    }

    private Long saveStructOfBill(Long id, Long parentId, String number, String billType) {
        String insertBillSql = " insert into t_eb_structofbill (fid,fparentid,fisleaf,flevel,fnumber,fstatus,fcreatetime,ffieldtable,fbilltype) values (?,?,?,?,?,?,?,?,?)";
        String isLeaf = "0";
        String fieldtable = "";
        int level = 0;
        if ("bill".equals(billType)) {
            isLeaf = "1";
            level = 3;
            fieldtable = number;
        } else if ("application".equals(billType)) {
            level = 2;
        } else if ("cloud".equals(billType)) {
            level = 1;
        }
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)insertBillSql, (Object[])new Object[]{id, parentId, isLeaf, level, number, "C", TimeServiceHelper.now(), fieldtable, billType});
        String uid = UUID.randomUUID().toString().substring(0, 20);
        String billName = BillListUtil.getResName((String)number);
        String insertBillLanguageSql = " insert into t_eb_structofbill_l (fpkid,fid,flocaleid,fname) values (?,?,?,?)";
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)insertBillLanguageSql, (Object[])new Object[]{uid, id, "zh_CN", billName});
        return id;
    }

    private String getApplicationByBillNumber(String billNumber) {
        String parentBillNum = null;
        if (Arrays.asList("er_dailyapplybill", "er_dailyloanbill", "er_dailyreimbursebill").contains(billNumber)) {
            parentBillNum = "exp";
        } else if (Arrays.asList("er_tripreqbill", "er_tripreimbursebill").contains(billNumber)) {
            parentBillNum = "tra";
        } else if (Arrays.asList("er_publicreimbursebill", "er_withholdingbill", "er_costestimatebill", "er_prepaybill", "er_expensesharebill", "er_applyprojectbill", "er_expensesharebill").contains(billNumber)) {
            parentBillNum = "em";
        } else if ("cal_costestimatebill".equals(billNumber)) {
            parentBillNum = "cal";
        } else if (Arrays.asList("exp", "tra").contains(billNumber)) {
            parentBillNum = "ESC";
        } else if (Arrays.asList("em", "cal").contains(billNumber)) {
            parentBillNum = "FI";
        }
        return Optional.ofNullable(parentBillNum).orElse("");
    }

    private Object saveField(List<Object[]> conbizRegDataParam, List<Object[]> conbizRegEntityParam, List<Object[]> controlBizRegParam, List<Object[]> controlBizRegLanguageParam) {
        String insertconbizRegDataSql = "insert into t_eb_conbizregdata (fid,ffielddimension,fbill,ffieldtable) values (?,?,?,?);";
        String insertconbizRegEntitySql = "insert into t_eb_conbizregentity (fid,fentryid,fnumber,fname,fisprefab ) values (?,?,?,?,?);";
        String insertcontrolBizRegSql = "insert into t_eb_bgcontrolbizreg (fid,fnumber,ffieldalias,fbizsystemid,fbizsystemalias,fbizunitid,fbizunitalias,ffieldtable,ftype ,ftypename,fisprefab,fcreatetime) values (?,?,?,?,?,?,?,?,?,?,?,?)";
        String insertcontrolBizRegLanguageSql = "insert into t_eb_bgcontrolbizreg_l (fid,fpkid,flocaleid,fname) values (?,?,?,?)";
        if (conbizRegDataParam.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertconbizRegDataSql, conbizRegDataParam);
        }
        if (conbizRegEntityParam.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertconbizRegEntitySql, conbizRegEntityParam);
        }
        if (controlBizRegParam.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertcontrolBizRegSql, controlBizRegParam);
        }
        if (controlBizRegLanguageParam.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertcontrolBizRegLanguageSql, controlBizRegLanguageParam);
        }
        return controlBizRegParam.size() > 0 ? controlBizRegParam.get(0)[0] : null;
    }
}

