/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.controlUpgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class RegistFileldUpgradeServiceImpl
implements IUpgradeService {
    public static final String esc = "ESC";
    public static final String exp = "exp";
    public static final String tra = "tra";
    public static final String em = "em";
    public static final String dailyapplybill = "er_dailyapplybill";
    public static final String dailyloanbill = "er_dailyloanbill";
    public static final String dailyreimbursebill = "er_dailyreimbursebill";
    public static final String tripreqbill = "er_tripreqbill";
    public static final String tripreimbursebill = "er_tripreimbursebill";
    public static final String publicreimbursebill = "er_publicreimbursebill";
    public static final String expensesharebill = "er_expensesharebill";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        this.updateParentId(result);
        return result;
    }

    private Map<String, Long> getStructOfBill() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        StringBuilder sb = new StringBuilder();
        String fields = "fid,fnumber";
        String billTypeStr = String.format("'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s'", esc, exp, tra, em, dailyapplybill, dailyloanbill, dailyreimbursebill, tripreqbill, tripreimbursebill, publicreimbursebill, expensesharebill);
        String whereStr = " where fnumber in (" + billTypeStr + ") ";
        sb.append("select ").append(fields).append(" from t_eb_structofbill ").append(whereStr);
        try (DataSet ds = DB.queryDataSet((String)"RegistFileldUpgradeServiceImpl_getStructOfBill", (DBRoute)DBRoute.of((String)"epm"), (String)sb.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                result.put(row.getString("fnumber"), row.getLong("fid"));
            }
        }
        return result;
    }

    public void updateParentId(UpgradeResult result) {
        try (TXHandle tx = TX.requiresNew((String)"RegistFileldUpgradeServiceImpl");){
            try {
                Object[] param;
                Map<String, Long> structOfBillMap = this.getStructOfBill();
                ArrayList<Object[]> batchParams = new ArrayList<Object[]>();
                if (structOfBillMap.containsKey(exp) && structOfBillMap.containsKey(dailyapplybill)) {
                    param = new Object[]{structOfBillMap.get(dailyapplybill), dailyapplybill};
                    batchParams.add(param);
                }
                if (structOfBillMap.containsKey(exp) && structOfBillMap.containsKey(dailyloanbill)) {
                    param = new Object[]{structOfBillMap.get(dailyloanbill), dailyloanbill};
                    batchParams.add(param);
                }
                if (structOfBillMap.containsKey(exp) && structOfBillMap.containsKey(dailyreimbursebill)) {
                    param = new Object[]{structOfBillMap.get(dailyreimbursebill), dailyreimbursebill};
                    batchParams.add(param);
                }
                if (structOfBillMap.containsKey(tra) && structOfBillMap.containsKey(tripreqbill)) {
                    param = new Object[]{structOfBillMap.get(tripreqbill), tripreqbill};
                    batchParams.add(param);
                }
                if (structOfBillMap.containsKey(tra) && structOfBillMap.containsKey(tripreimbursebill)) {
                    param = new Object[]{structOfBillMap.get(tripreimbursebill), tripreimbursebill};
                    batchParams.add(param);
                }
                if (structOfBillMap.containsKey(exp) && structOfBillMap.containsKey(publicreimbursebill)) {
                    param = new Object[]{structOfBillMap.get(publicreimbursebill), publicreimbursebill};
                    batchParams.add(param);
                }
                if (structOfBillMap.containsKey(exp) && structOfBillMap.containsKey(expensesharebill)) {
                    param = new Object[]{structOfBillMap.get(expensesharebill), expensesharebill};
                    batchParams.add(param);
                }
                String baseUpdateSql2 = "update t_eb_conbizregdata set fbill= ? where FFIELDTABLE = ? ";
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)baseUpdateSql2, batchParams);
                result.setSuccess(true);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
            }
        }
    }
}

