/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.controlUpgrade;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.business.billlist.BillListUtil;

public class StructOfBillServiceImp
implements IUpgradeService {
    public static final String dailyapplybill = "er_dailyapplybill";
    public static final String dailyloanbill = "er_dailyloanbill";
    public static final String dailyreimbursebill = "er_dailyreimbursebill";
    public static final String tripreqbill = "er_tripreqbill";
    public static final String tripreimbursebill = "er_tripreimbursebill";
    public static final String publicreimbursebill = "er_publicreimbursebill";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        this.updateParentId(result);
        return result;
    }

    private Map<String, Long> getStructOfBill() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        StringBuilder sb = new StringBuilder();
        String fields = "fid,fnumber";
        String billTypeStr = String.format("'%s','%s','%s','%s','%s','%s'", dailyapplybill, dailyloanbill, dailyreimbursebill, tripreqbill, tripreimbursebill, publicreimbursebill);
        String whereStr = " where fnumber in (" + billTypeStr + ") ";
        sb.append("select ").append(fields).append(" from t_eb_structofbill ").append(whereStr);
        try (DataSet ds = DB.queryDataSet((String)"StructOfBillServiceImp_getStructOfBill", (DBRoute)DBRoute.of((String)"epm"), (String)sb.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                result.put(row.getString("fnumber"), row.getLong("fid"));
            }
        }
        return result;
    }

    public void updateParentId(UpgradeResult result) {
        try (TXHandle tx = TX.requiresNew((String)"StructOfBillServiceImp");){
            try {
                Map<String, Long> structOfBillMap = this.getStructOfBill();
                if (structOfBillMap.isEmpty()) {
                    BillListUtil.presetField();
                    structOfBillMap = this.getStructOfBill();
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
            }
        }
    }
}

