/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.controlUpgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class StructOfBillUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        Map<String, Long> presetBill = this.getPresetBill();
        StructTree root = this.getInsideNodeTree();
        this.update(root, presetBill, result);
        return result;
    }

    private StructTree getInsideNodeTree() {
        StructTree root = new StructTree("INSIDE_NODE");
        StructTree esc = new StructTree("ESC");
        root.addChild(esc);
        StructTree fi = new StructTree("FI");
        root.addChild(fi);
        StructTree exp = new StructTree("exp");
        esc.addChild(exp);
        StructTree tra = new StructTree("tra");
        esc.addChild(tra);
        exp.addChild(new StructTree("er_dailyapplybill"));
        exp.addChild(new StructTree("er_dailyloanbill"));
        exp.addChild(new StructTree("er_dailyreimbursebill"));
        tra.addChild(new StructTree("er_tripreqbill"));
        tra.addChild(new StructTree("er_tripreimbursebill"));
        StructTree em = new StructTree("em");
        fi.addChild(em);
        em.addChild(new StructTree("er_publicreimbursebill"));
        return root;
    }

    private Map<String, Long> getPresetBill() {
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        map.put("INSIDE_NODE", 1019491572468680704L);
        map.put("ESC", 1019491572477068288L);
        map.put("er_dailyapplybill", 1019491572477068289L);
        map.put("exp", 1019491572477069312L);
        map.put("er_dailyloanbill", 1019491574783936525L);
        map.put("er_dailyreimbursebill", 1019491575438246923L);
        map.put("tra", 1019491576151278606L);
        map.put("er_tripreqbill", 1019491576151279630L);
        map.put("er_tripreimbursebill", 1019491576654596096L);
        map.put("FI", 1019491577250186249L);
        map.put("em", 1019491577250187273L);
        map.put("er_publicreimbursebill", 1019491577258574848L);
        map.put("OUTER_NODE", 1019491577896109066L);
        return map;
    }

    private void update(StructTree insideNode, Map<String, Long> presetBill, UpgradeResult result) {
        HashSet<Long> needDelete = new HashSet<Long>();
        this.putNeedDelete(insideNode, presetBill, needDelete);
        if (this.checkBillDouble("OUTER_NODE", presetBill.get("OUTER_NODE"))) {
            needDelete.add(presetBill.get("OUTER_NODE"));
        }
        for (Long billId : needDelete) {
            this.deleteBillByFid(billId);
        }
    }

    private void putNeedDelete(StructTree insideNode, Map<String, Long> presetBill, Set<Long> needDelete) {
        if (insideNode == null) {
            return;
        }
        String number = insideNode.getNumber();
        if (this.checkBillDouble(number, presetBill.get(number))) {
            needDelete.add(presetBill.get(number));
        }
        for (StructTree structTree : insideNode.getChild()) {
            this.putNeedDelete(structTree, presetBill, needDelete);
        }
    }

    private boolean checkBillDouble(String bill, Long fid) {
        if (bill == null || bill.length() == 0 || fid == null || fid == 0L) {
            return false;
        }
        String billSql = "SELECT fid FROM T_EB_STRUCTOFBILL WHERE FNUMBER='" + bill + "' and fid !=" + fid;
        ArrayList<Long> existsIds = new ArrayList<Long>();
        try (DataSet ds = DB.queryDataSet((String)"StructOfBillUpgradeServiceImpl", (DBRoute)DBRoute.of((String)"epm"), (String)billSql, null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                existsIds.add(row.getLong("fid"));
            }
        }
        return existsIds.size() > 0;
    }

    private void deleteBillByFid(Long fid) {
        String sql1 = String.format("DELETE FROM T_EB_CONBIZREGENTITY WHERE FID IN (SELECT FID FROM T_EB_CONBIZREGDATA WHERE FBILL = %s)", fid);
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql1);
        String sql2 = String.format("DELETE FROM T_EB_CONBIZREGDATA WHERE FBILL = %s", fid);
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql2);
        String sql3 = String.format("DELETE FROM T_EB_BGCONTROLBIZREG_L WHERE FID IN (SELECT FID FROM T_EB_BGCONTROLBIZREG WHERE FBIZUNITID = %s)", fid);
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql3);
        String sql4 = String.format("DELETE FROM T_EB_BGCONTROLBIZREG WHERE FBIZUNITID = %s", fid);
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql4);
        String sql5 = String.format("DELETE FROM T_EB_STRUCTOFBILL_L WHERE FID = %s", fid);
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql5);
        String sql6 = String.format("DELETE FROM T_EB_STRUCTOFBILL WHERE FID = %s", fid);
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql6);
    }

    private static class StructTree {
        private String number;
        private List<StructTree> child;

        public StructTree(String number) {
            this.number = number;
        }

        public String getNumber() {
            return this.number;
        }

        public void addChild(StructTree child) {
            this.getChild().add(child);
        }

        public List<StructTree> getChild() {
            if (this.child == null) {
                this.child = new ArrayList<StructTree>(16);
            }
            return this.child;
        }
    }
}

