/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.controlUpgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class WarningUpgradeServiceImpl
implements IUpgradeService {
    public static final String esc = "ESC";
    public static final String exp = "exp";
    public static final String tra = "tra";
    public static final String em = "em";
    public static final String dailyapplybill = "er_dailyapplybill";
    public static final String dailyloanbill = "er_dailyloanbill";
    public static final String dailyreimbursebill = "er_dailyreimbursebill";
    public static final String tripreqbill = "er_tripreqbill";
    public static final String tripreimbursebill = "er_tripreimbursebill";
    public static final String publicreimbursebill = "er_publicreimbursebill";
    public static final String expensesharebill = "er_expensesharebill";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        this.updateParentId(result);
        return result;
    }

    private Map<String, Long> getStructOfBill() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        StringBuilder sb = new StringBuilder();
        String fields = "fid,fnumber";
        String billTypeStr = String.format("'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s'", esc, exp, tra, em, dailyapplybill, dailyloanbill, dailyreimbursebill, tripreqbill, tripreimbursebill, publicreimbursebill, expensesharebill);
        String whereStr = " where fnumber in (" + billTypeStr + ") ";
        sb.append("select ").append(fields).append(" from t_eb_structofbill ").append(whereStr);
        try (DataSet ds = DB.queryDataSet((String)"WarningUpgradeServiceImpl_getStructOfBill", (DBRoute)DBRoute.of((String)"epm"), (String)sb.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                result.put(row.getString("fnumber"), row.getLong("fid"));
            }
        }
        return result;
    }

    public void updateParentId(UpgradeResult result) {
        try (TXHandle tx = TX.requiresNew((String)"WarningUpgradeServiceImpl");){
            try {
                Object[] param;
                String curSql;
                String updateSql;
                Map<String, Long> structOfBillMap = this.getStructOfBill();
                if (structOfBillMap.containsKey(exp)) {
                    updateSql = "UPDATE T_EB_STRUCTOFBILL SET FPARENTID=? WHERE FNUMBER = 'er_publicreimbursebill' ";
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, (Object[])new Object[]{structOfBillMap.get(exp)});
                }
                if (structOfBillMap.containsKey(exp)) {
                    updateSql = "UPDATE T_EB_STRUCTOFBILL SET FPARENTID=? WHERE FNUMBER = 'er_expensesharebill' ";
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, (Object[])new Object[]{structOfBillMap.get(exp)});
                }
                ArrayList<Object[]> batchParams = new ArrayList<Object[]>();
                String baseUpdateSql = "update T_EB_BGCONTROLBIZREG set fisprefab= ? ,FBIZSYSTEMID= ?,FBIZUNITID= ? ";
                if (structOfBillMap.containsKey(exp) && structOfBillMap.containsKey(dailyapplybill)) {
                    curSql = baseUpdateSql + String.format("  where FTYPE='WARNING' AND FID = %s", "906306271139990551");
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)curSql, (Object[])new Object[]{"1", structOfBillMap.get(exp), structOfBillMap.get(dailyapplybill)});
                    param = new Object[]{structOfBillMap.get(dailyapplybill), dailyapplybill};
                    batchParams.add(param);
                }
                if (structOfBillMap.containsKey(exp) && structOfBillMap.containsKey(dailyloanbill)) {
                    curSql = baseUpdateSql + String.format(" where FTYPE='WARNING'  AND FID = %s", "906306495493311513");
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)curSql, (Object[])new Object[]{"1", structOfBillMap.get(exp), structOfBillMap.get(dailyloanbill)});
                    param = new Object[]{structOfBillMap.get(dailyloanbill), dailyloanbill};
                    batchParams.add(param);
                }
                if (structOfBillMap.containsKey(exp) && structOfBillMap.containsKey(dailyreimbursebill)) {
                    curSql = baseUpdateSql + String.format(" where FTYPE='WARNING'  AND FID = %s", "906306776729783324");
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)curSql, (Object[])new Object[]{"1", structOfBillMap.get(exp), structOfBillMap.get(dailyreimbursebill)});
                    param = new Object[]{structOfBillMap.get(dailyreimbursebill), dailyreimbursebill};
                    batchParams.add(param);
                }
                if (structOfBillMap.containsKey(tra) && structOfBillMap.containsKey(tripreqbill)) {
                    curSql = baseUpdateSql + String.format(" where FTYPE='WARNING'  AND FID = %s", "906306982552563740");
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)curSql, (Object[])new Object[]{"1", structOfBillMap.get(tra), structOfBillMap.get(tripreqbill)});
                    param = new Object[]{structOfBillMap.get(tripreqbill), tripreqbill};
                    batchParams.add(param);
                }
                if (structOfBillMap.containsKey(tra) && structOfBillMap.containsKey(tripreimbursebill)) {
                    curSql = baseUpdateSql + String.format(" where FTYPE='WARNING'  AND FID = %s", "906307179676568586");
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)curSql, (Object[])new Object[]{"1", structOfBillMap.get(tra), structOfBillMap.get(tripreimbursebill)});
                    param = new Object[]{structOfBillMap.get(tripreimbursebill), tripreimbursebill};
                    batchParams.add(param);
                }
                if (structOfBillMap.containsKey(exp) && structOfBillMap.containsKey(publicreimbursebill)) {
                    curSql = baseUpdateSql + String.format(" where FTYPE='WARNING'  AND FID = %s", "906349596094001181");
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)curSql, (Object[])new Object[]{"1", structOfBillMap.get(exp), structOfBillMap.get(publicreimbursebill)});
                    param = new Object[]{structOfBillMap.get(publicreimbursebill), publicreimbursebill};
                    batchParams.add(param);
                }
                if (structOfBillMap.containsKey(exp) && structOfBillMap.containsKey(expensesharebill)) {
                    curSql = baseUpdateSql + String.format(" where ffieldtable='%s'", expensesharebill);
                    DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)curSql, (Object[])new Object[]{"1", structOfBillMap.get(exp), structOfBillMap.get(expensesharebill)});
                    param = new Object[]{structOfBillMap.get(expensesharebill), expensesharebill};
                    batchParams.add(param);
                }
                String sql = "update T_EB_CONBIZREGENTITY set FISPREFAB=?  where fnumber='isoverbudget'";
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{"1"});
                if (batchParams.size() > 0) {
                    String baseUpdateSql2 = "update t_eb_conbizregdata set fbill= ? where FFIELDTABLE = ? ";
                    DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)baseUpdateSql2, batchParams);
                }
                this.clearPresetExpenseshareBill(expensesharebill, 957026506926808065L);
                this.clearWarningField();
                result.setSuccess(true);
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
            }
        }
    }

    private void clearPresetExpenseshareBill(String bill, Long fid) {
        String billSql = "SELECT fid FROM T_EB_STRUCTOFBILL WHERE FFIELDTABLE='er_expensesharebill' and fid !=" + fid;
        ArrayList<Long> existsIds = new ArrayList<Long>();
        try (DataSet ds = DB.queryDataSet((String)"WarningUpgradeServiceImpl_clearPresetBill", (DBRoute)DBRoute.of((String)"epm"), (String)billSql, null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                existsIds.add(row.getLong("fid"));
            }
        }
        if (existsIds.size() > 0) {
            String sql1 = String.format("DELETE FROM T_EB_CONBIZREGENTITY WHERE FID IN (SELECT FID FROM T_EB_CONBIZREGDATA WHERE FBILL = %s)", fid);
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql1);
            String sql2 = String.format("DELETE FROM T_EB_CONBIZREGDATA WHERE FBILL = %s", fid);
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql2);
            String sql3 = String.format("DELETE FROM T_EB_BGCONTROLBIZREG_L WHERE FID IN (SELECT FID FROM T_EB_BGCONTROLBIZREG WHERE FBIZUNITID = %s)", fid);
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql3);
            String sql4 = String.format("DELETE FROM T_EB_BGCONTROLBIZREG WHERE FBIZUNITID = %s", fid);
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql4);
            String sql5 = String.format("DELETE FROM T_EB_STRUCTOFBILL_L WHERE FID = %s", fid);
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql5);
            String sql6 = String.format("DELETE FROM T_EB_STRUCTOFBILL WHERE FID = %s", fid);
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql6);
        }
    }

    private void clearWarningField() {
        String type = "WARNING";
        this.clearWarningFieldByBill(dailyapplybill, type, 906306271139990551L, 906306420188777472L);
        this.clearWarningFieldByBill(dailyloanbill, type, 906306495493311513L, 906306595082865664L);
        this.clearWarningFieldByBill(dailyreimbursebill, type, 906306776729783324L, 906306921802370048L);
        this.clearWarningFieldByBill(tripreqbill, type, 906306982552563740L, 906307085170510848L);
        this.clearWarningFieldByBill(tripreimbursebill, type, 906307179676568586L, 906307256012901376L);
        this.clearWarningFieldByBill(publicreimbursebill, type, 906349596094001181L, 906349788872707072L);
    }

    private void clearWarningFieldByBill(String bill, String type, Long bizRegId, Long bizRegDataId) {
        String billSql = String.format("SELECT fid FROM T_EB_BGCONTROLBIZREG WHERE FFIELDTABLE='%s' AND FTYPE='%s' AND fid !=%s", bill, type, bizRegId);
        ArrayList<Long> existsId = new ArrayList<Long>();
        try (DataSet ds = DB.queryDataSet((String)"WarningUpgradeServiceImpl_clearWarningField", (DBRoute)DBRoute.of((String)"epm"), (String)billSql, null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                existsId.add(row.getLong("fid"));
            }
        }
        if (existsId.size() > 0) {
            String sql1 = String.format("DELETE FROM T_EB_CONBIZREGENTITY WHERE FID = %s", bizRegDataId);
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql1);
            String sql2 = String.format("DELETE FROM T_EB_CONBIZREGDATA WHERE FID = %s", bizRegDataId);
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql2);
            String sql3 = String.format("DELETE FROM T_EB_BGCONTROLBIZREG_L WHERE FID = %s", bizRegId);
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql3);
            String sql4 = String.format("DELETE FROM T_EB_BGCONTROLBIZREG WHERE FID = %s", bizRegId);
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql4);
        }
    }
}

