/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.crosslibupdate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.crosslibupdate.UpgradeInfo;
import kd.epm.eb.common.crosslibupdate.UpgradeSqlDetail;
import kd.epm.eb.common.crosslibupdate.UpgradeTableInfo;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class AbstractDataUpgrade
implements IUpgradeService {
    private static final Log baseLog = LogFactory.getLog(AbstractDataUpgrade.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(false);
        UpgradeInfo upgradeInfo = this.getUpgradeInfo();
        if (upgradeInfo == null) {
            return result;
        }
        String toUpgradeSign = upgradeInfo.getUpgradeSign();
        if (StringUtils.isEmpty((String)toUpgradeSign) || !UpdateRecordHelper.isUpdated((String)toUpgradeSign)) {
            UpgradeTableInfo multiTable;
            UpgradeTableInfo refTable;
            DBRoute toUpgradeRoute = upgradeInfo.getRoute();
            ArrayList<UpgradeSqlDetail> details = new ArrayList<UpgradeSqlDetail>(16);
            UpgradeTableInfo mainTable = upgradeInfo.getMainTable();
            if (mainTable != null) {
                UpgradeSqlDetail sqlDetail = this.getSqlDetail(mainTable, toUpgradeRoute, toUpgradeSign);
                if (sqlDetail == null) {
                    return result;
                }
                details.add(sqlDetail);
            }
            if ((refTable = upgradeInfo.getRefTable()) != null) {
                UpgradeSqlDetail sqlDetail = this.getSqlDetail(refTable, toUpgradeRoute, toUpgradeSign);
                if (sqlDetail == null) {
                    return result;
                }
                details.add(sqlDetail);
            }
            if ((multiTable = upgradeInfo.getMultiTable()) != null) {
                UpgradeSqlDetail sqlDetail = this.getSqlDetail(multiTable, toUpgradeRoute, toUpgradeSign);
                if (sqlDetail == null) {
                    return result;
                }
                details.add(sqlDetail);
            }
            try (TXHandle tx = TX.required((String)(StringUtils.isEmpty((String)toUpgradeSign) ? "AbstractDataUpgrade" : toUpgradeSign));){
                String curTable = "";
                try {
                    for (UpgradeSqlDetail detail : details) {
                        curTable = detail.getTable();
                        this.logInfo(toUpgradeSign, curTable + " --- start_execute_sql");
                        this.logSqlDetail(toUpgradeSign, detail);
                        DB.execute((DBRoute)toUpgradeRoute, (String)detail.getDeleteSql(), (Object[])detail.getDeleteParam());
                        DB.executeBatch((DBRoute)toUpgradeRoute, (String)detail.getInsertSql(), (List)detail.getInsertParams());
                        this.logInfo(toUpgradeSign, curTable + " --- end_execute_sql");
                    }
                    result.setSuccess(true);
                }
                catch (Throwable ex) {
                    tx.markRollback();
                    this.logInfo(toUpgradeSign, curTable + " --- error_execute_sql");
                    this.getLog().error(ex);
                    result.setLog(CommonServiceHelper.getStackTraceStr((Throwable)ex));
                }
            }
            if (result.isSuccess() && StringUtils.isNotEmpty((String)toUpgradeSign)) {
                UpdateRecordHelper.addRecord((String)toUpgradeSign, null, null, (boolean)true);
            }
            this.getLog().info("end_execute_sql");
        } else {
            result.setSuccess(true);
        }
        return result;
    }

    private void logSqlDetail(String toUpgradeSign, UpgradeSqlDetail detail) {
        this.logInfo(toUpgradeSign, detail.getDeleteSql());
        this.logInfo(toUpgradeSign, Arrays.toString(detail.getDeleteParam()));
        this.logInfo(toUpgradeSign, detail.getInsertSql());
        this.logInfo(toUpgradeSign, detail.getInsertParams().stream().map(Arrays::toString).collect(Collectors.joining(";")));
    }

    private UpgradeSqlDetail getSqlDetail(UpgradeTableInfo tableInfo, DBRoute toUpgradeRoute, String toUpgradeSign) {
        this.logInfo(toUpgradeSign, "begin_build_sql_info");
        String toUpgradeTableName = tableInfo.getTableName();
        List toUpgradeFields = tableInfo.getUpgradeFields();
        List toUpgradeParams = tableInfo.getUpgradeParams();
        if (StringUtils.isEmpty((String)toUpgradeTableName) || toUpgradeRoute == null || toUpgradeFields == null || toUpgradeParams == null || toUpgradeFields.size() == 0 || toUpgradeParams.size() == 0) {
            this.logInfo(toUpgradeSign, "emptyTableInfo");
            return null;
        }
        List columnNames = DB.getColumnNames((DBRoute)toUpgradeRoute, (String)toUpgradeTableName);
        List columnNames_new = columnNames.stream().map(String::toLowerCase).collect(Collectors.toList());
        ArrayList<String> toUpgradeColumns = new ArrayList<String>(16);
        ArrayList<String> notExistColumnIndexes = new ArrayList<String>(16);
        for (int i = 0; i < toUpgradeFields.size(); ++i) {
            String toUpgradeField = ((String)toUpgradeFields.get(i)).toLowerCase();
            if (!columnNames_new.contains(toUpgradeField) || toUpgradeColumns.contains(toUpgradeField)) {
                notExistColumnIndexes.add(String.valueOf(i));
                continue;
            }
            toUpgradeColumns.add(toUpgradeField);
        }
        String toUpgradePkField = tableInfo.getPkField().toLowerCase();
        int pkIndex = toUpgradeColumns.indexOf(toUpgradePkField);
        if (pkIndex == -1) {
            this.logInfo(toUpgradeSign, "error pk --- " + ((Object)toUpgradeColumns).toString() + " --- " + toUpgradePkField + " --- " + columnNames_new);
            return null;
        }
        ArrayList<Object> pkIds = new ArrayList<Object>(16);
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Object[] toUpgradeParam : toUpgradeParams) {
            int length = toUpgradeParam.length;
            if (length != toUpgradeFields.size()) continue;
            Object[] param = new Object[toUpgradeColumns.size()];
            int index = 0;
            for (int i = 0; i < length; ++i) {
                if (notExistColumnIndexes.contains(String.valueOf(i))) continue;
                if (index == pkIndex) {
                    pkIds.add(toUpgradeParam[i]);
                }
                param[index++] = toUpgradeParam[i];
            }
            params.add(param);
        }
        this.logInfo(toUpgradeSign, "begin_build_sql");
        String deleteSql = "delete from " + toUpgradeTableName + " where " + toUpgradePkField + " in " + pkIds.stream().map(e -> "?").collect(Collectors.joining(",", "(", ")"));
        String insertSql = "insert into " + toUpgradeTableName + toUpgradeColumns.stream().collect(Collectors.joining(",", "(", ")")) + " values " + toUpgradeColumns.stream().map(e -> "?").collect(Collectors.joining(",", "(", ")"));
        UpgradeSqlDetail upgradeSqlDetail = new UpgradeSqlDetail();
        upgradeSqlDetail.setTable(tableInfo.getTableName());
        upgradeSqlDetail.setDeleteSql(deleteSql);
        upgradeSqlDetail.setDeleteParam(pkIds.toArray());
        upgradeSqlDetail.setInsertSql(insertSql);
        upgradeSqlDetail.setInsertParams(params);
        return upgradeSqlDetail;
    }

    protected UpgradeInfo getUpgradeInfo() {
        return null;
    }

    private void logInfo(String toUpgradeSign, String logInfo) {
        this.getLog().info(toUpgradeSign + " --- " + logInfo);
    }

    protected Log getLog() {
        return baseLog;
    }
}

