/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.currencyconvert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.StringUtils;

public class CurrencyServiceImpl
implements IUpgradeService {
    private StringBuilder sb = new StringBuilder();

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Throwable throwable;
        TXHandle tx;
        UpgradeResult result;
        block18: {
            UpgradeResult upgradeResult;
            block19: {
                block20: {
                    result = new UpgradeResult();
                    tx = TX.requiresNew((String)"BgmdTaskListUpgrade");
                    throwable = null;
                    String msg = this.checkTableExist();
                    if (StringUtils.isEmpty((String)msg)) break block18;
                    result.setSuccess(false);
                    result.setLog("table " + msg + " does't exist, so don't need upgrade.");
                    upgradeResult = result;
                    if (tx == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                this.upgradeTaskList(result);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }

    private String checkTableExist() {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_currencyconvertschem")) {
            return "t_eb_currencyconvertschem";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_structofcurrency")) {
            return "t_eb_structofcurrency";
        }
        return "";
    }

    private Map<Long, String> queryName() {
        HashMap<Long, String> nameList = new HashMap<Long, String>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryName", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fcurrencyraw,fcurrencyrate,fname,fmodelid from t_eb_currencyconvertschem", null);){
            while (ds != null && ds.hasNext()) {
                StringBuilder builder = new StringBuilder();
                Row row = ds.next();
                if (!StringUtils.isEmpty((String)row.getString("fname"))) continue;
                nameList.put(row.getLong("fid"), builder.append(row.getString("fcurrencyraw")).append("#").append(row.getString("fcurrencyrate")).toString());
            }
        }
        return nameList;
    }

    private void upgradeTaskList(UpgradeResult result) {
        Map<Long, String> nameList = this.queryName();
        HashSet raw = new HashSet(16);
        nameList.entrySet().forEach(name -> {
            String[] split = ((String)name.getValue()).split("#");
            if (split.length > 0) {
                raw.add(split[0]);
                raw.add(split[1]);
            }
        });
        HashMap<Long, String> modelMap = new HashMap<Long, String>(16);
        String modelStr = String.join((CharSequence)",", raw);
        this.sb.setLength(0);
        StringBuilder queryBizModel = new StringBuilder();
        queryBizModel.append("select fid,fname from t_eb_structofcurrency_l where fid in (");
        queryBizModel.append(modelStr);
        queryBizModel.append(')');
        this.sb.append((CharSequence)queryBizModel);
        try (DataSet ds = DB.queryDataSet((String)"queryCurrencyName", (DBRoute)DBRoute.of((String)"epm"), (String)queryBizModel.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long bizmodel = row.getLong("fid");
                String modelId = row.getString("fname");
                modelMap.put(bizmodel, modelId);
            }
        }
        catch (Exception e) {
            result.setLog(this.sb.toString());
        }
        if (modelMap.size() == 0) {
            return;
        }
        List<Object[]> list = this.packageDimEntry(nameList, modelMap);
        String updateSql = "update t_eb_currencyconvertschem set fname = ? where fid = ?";
        try {
            if (list.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<Object[]> packageDimEntry(Map<Long, String> nameList, Map<Long, String> map) {
        ArrayList<Object[]> ob = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, String> entry : nameList.entrySet()) {
            StringBuilder builder = new StringBuilder();
            ArrayList<Object> ob1 = new ArrayList<Object>();
            String[] split = entry.getValue().split("#");
            if (split.length <= 0) continue;
            String currency1 = map.get(Long.parseLong(split[0]));
            String currency2 = map.get(Long.parseLong(split[1]));
            ob1.add(builder.append(currency1).append(" \u2192 ").append(currency2).toString());
            ob1.add(entry.getKey());
            ob.add(ob1.toArray(new Object[0]));
        }
        return ob;
    }
}

