/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.dataintegration;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.apiservice.SyncCommonService;
import kd.epm.eb.business.dataintegration.DataIntegrationStart;
import kd.epm.eb.business.dataintegration.entity.ExecuteCondition;
import kd.epm.eb.business.dataintegration.service.DataIntegrationService;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.service.dataintegration.DataIntegrationMSService;
import kd.epm.eb.service.entity.MsResult;
import org.apache.commons.lang3.StringUtils;

public class DataIntegrationMSServiceImpl
implements DataIntegrationMSService {
    private static final Log log = LogFactory.getLog(DataIntegrationMSServiceImpl.class);

    public String executeInTask(String json) {
        log.info("executeInTask param:" + json);
        try {
            Req req = (Req)JSON.parseObject((String)json, Req.class);
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{req.getModelNumber(), req.getNumber()})) {
                return JSONUtils.toString((Object)new MsResult(false, "error param"));
            }
            DynamicObject model = SyncCommonService.getInstance().getModelObj(req.getModelNumber());
            long modelId = model.getLong("id");
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            QFilter qFilter = new QFilter("number", "=", (Object)req.getNumber());
            qFilter.and("modelid", "=", (Object)modelId);
            qFilter.and("type", "=", (Object)"input");
            qFilter.and("status", "=", (Object)true);
            DynamicObject inObj = QueryServiceHelper.queryOne((String)"eb_integration", (String)"id,number,name,status,modelid.id,triggerid.id,datasetid", (QFilter[])qFilter.toArray());
            if (inObj == null) {
                return JSONUtils.toString((Object)new MsResult(false, "invalid number"));
            }
            long datasetid = inObj.getLong("datasetid");
            HashMap<String, List<Member>> replaceMembers = new HashMap<String, List<Member>>(16);
            List dataIntegrationQueryList = null;
            ExecuteCondition executeCondition = new ExecuteCondition();
            Map dimensionMap = modelCache.getDimensionMap(Long.valueOf(datasetid));
            Map views = modelCache.getViewsByDataSet(Long.valueOf(datasetid));
            if (StringUtils.equals((CharSequence)req.getQueryModel(), (CharSequence)"1")) {
                DynamicObject exeQuery = this.getExeQuery(req, inObj);
                if (exeQuery == null) {
                    return JSONUtils.toString((Object)new MsResult(false, "invalid executeQueryNumber"));
                }
                dataIntegrationQueryList = DataIntegrationService.getDataIntegrationQueryList((DynamicObject)exeQuery, (IModelCacheHelper)modelCache, (Map)views);
            } else if (StringUtils.equals((CharSequence)req.getQueryModel(), (CharSequence)"3")) {
                DynamicObject exeQuery = this.getExeQuery(req, inObj);
                if (exeQuery == null) {
                    return JSONUtils.toString((Object)new MsResult(false, "invalid executeQueryNumber"));
                }
                dataIntegrationQueryList = DataIntegrationService.getDataIntegrationQueryList((DynamicObject)exeQuery, (IModelCacheHelper)modelCache, (Map)views);
                Map<String, List<String>> executeCriteria = req.getExecuteCriteria();
                String checkResult = this.checkAndSelectFilterMembers(executeCriteria, replaceMembers, dimensionMap, views, false);
                if (checkResult != null) {
                    return checkResult;
                }
            } else {
                boolean del;
                Map<String, List<String>> executeCriteria = req.getExecuteCriteria();
                String checkResult = this.checkAndSelectFilterMembers(executeCriteria, replaceMembers, dimensionMap, views, del = StringUtils.equals((CharSequence)req.getDeleteOldData(), (CharSequence)"1"));
                if (checkResult != null) {
                    return checkResult;
                }
                executeCondition.setDelOldData(del);
            }
            executeCondition.setFilters(dataIntegrationQueryList);
            executeCondition.setTargetSchemeIds(Collections.singleton(inObj.getLong("id")));
            executeCondition.setModelId(Long.valueOf(modelId));
            executeCondition.setBizModelId(DatasetServiceHelper.getBusModelIdByDataset((Long)datasetid));
            executeCondition.setActionId(Long.valueOf(GlobalIdUtil.genGlobalLongId()));
            executeCondition.setReplaceMembers(replaceMembers);
            executeCondition.setOut(false);
            DataIntegrationStart.getInstance((ExecuteCondition)executeCondition).run(req.isAsync());
            return JSONUtils.toString((Object)new MsResult());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return JSONUtils.toString((Object)new MsResult(false, e.getMessage()));
        }
    }

    private String checkAndSelectFilterMembers(Map<String, List<String>> executeCriteria, Map<String, List<Member>> filterMembers, Map<String, Dimension> dimensionMap, Map<String, Long> views, boolean checkForDel) {
        if (executeCriteria != null) {
            HashSet<String> checkedDimNum = new HashSet<String>(dimensionMap.keySet());
            for (Map.Entry<String, List<String>> entry : executeCriteria.entrySet()) {
                String dim = entry.getKey();
                Dimension dimension = dimensionMap.get(dim);
                if (dimension == null) {
                    return JSONUtils.toString((Object)new MsResult(false, "invalid dimNumber:" + dim));
                }
                Long viewId = views.get(dim);
                List<String> memList = entry.getValue();
                if (memList.isEmpty()) {
                    return JSONUtils.toString((Object)new MsResult(false, "empty Members:" + dim));
                }
                ArrayList<Member> members = new ArrayList<Member>(memList.size());
                for (String mem : memList) {
                    Member member = dimension.getMember(viewId, mem);
                    if (member == null) {
                        return JSONUtils.toString((Object)new MsResult(false, "invalid Member:" + mem));
                    }
                    members.add(member);
                }
                filterMembers.put(dim, members);
                checkedDimNum.remove(dim);
            }
            if (checkForDel && checkedDimNum.size() > 0) {
                return JSONUtils.toString((Object)new MsResult(false, "dimension " + checkedDimNum + " must have members"));
            }
        }
        return null;
    }

    public DynamicObject getExeQuery(Req req, DynamicObject inObj) {
        List conditionIdsBySchemes = EASDataIntegrationUtil.getConditionIdsBySchemes(Collections.singleton(inObj.getLong("id")));
        QFilter qFilter2 = new QFilter("id", "in", (Object)conditionIdsBySchemes);
        qFilter2.and("number", "=", (Object)req.getExecuteQueryNumber());
        return QueryServiceHelper.queryOne((String)"eb_integration_query", (String)"id,number,name,queryjson,datasetid,isdeletedata", (QFilter[])qFilter2.toArray());
    }

    public static class Req {
        private String modelNumber;
        private String number;
        private String queryModel;
        private String executeQueryNumber;
        private Map<String, List<String>> executeCriteria = new HashMap<String, List<String>>(16);
        private String deleteOldData;
        private boolean async;

        public boolean isAsync() {
            return this.async;
        }

        public void setAsync(boolean async) {
            this.async = async;
        }

        public String getModelNumber() {
            return this.modelNumber;
        }

        public void setModelNumber(String modelNumber) {
            this.modelNumber = modelNumber;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getQueryModel() {
            return this.queryModel;
        }

        public void setQueryModel(String queryModel) {
            this.queryModel = queryModel;
        }

        public String getExecuteQueryNumber() {
            return this.executeQueryNumber;
        }

        public void setExecuteQueryNumber(String executeQueryNumber) {
            this.executeQueryNumber = executeQueryNumber;
        }

        public String getDeleteOldData() {
            return this.deleteOldData;
        }

        public void setDeleteOldData(String deleteOldData) {
            this.deleteOldData = deleteOldData;
        }

        public Map<String, List<String>> getExecuteCriteria() {
            return this.executeCriteria;
        }

        public void setExecuteCriteria(Map<String, List<String>> executeCriteria) {
            this.executeCriteria = executeCriteria;
        }
    }
}

