/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;

public class AddDefaultDimServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(AddDefaultDimServiceImpl.class);

    private String checkTableExist() {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_datasetdim")) {
            return "t_eb_datasetdim";
        }
        return "";
    }

    private List<Long> queryModelIds() {
        ArrayList<Long> modelIds = new ArrayList<Long>();
        try (DataSet ds = DB.queryDataSet((String)"createbizModel_queryEpmBizModel", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid from t_eb_model where freporttype='7'", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                modelIds.add(row.getLong("fid"));
            }
        }
        return modelIds;
    }

    private void upgradeDataDimEntry(List<Long> modelIds) {
        Long modelId;
        Object dimId;
        if (modelIds.size() == 0) {
            return;
        }
        StringBuilder modelStr = new StringBuilder();
        for (Long aLong : modelIds) {
            modelStr.append(aLong).append(",");
        }
        if (modelStr.length() < 1) {
            return;
        }
        modelStr.deleteCharAt(modelStr.length() - 1);
        HashMap dimMap = new HashMap();
        StringBuilder queryDimSql = new StringBuilder();
        queryDimSql.append("select fid,fnumber,fmodelid from t_eb_dimension where fmodelid in (");
        queryDimSql.append((CharSequence)modelStr);
        queryDimSql.append(") and fnumber in ('Metric')");
        StringBuilder dimString = new StringBuilder();
        try (DataSet ds = DB.queryDataSet((String)"queryDimension", (DBRoute)DBRoute.of((String)"epm"), (String)queryDimSql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long modelId2 = row.getLong("fmodelid");
                dimString.append(row.getLong("fid")).append(",");
                if (dimMap.containsKey(modelId2)) {
                    ((Set)dimMap.get(modelId2)).add(row.getLong("fid"));
                    continue;
                }
                dimId = new HashSet<Long>();
                dimId.add(row.getLong("fid"));
                dimMap.put(modelId2, dimId);
            }
        }
        if (dimString.length() >= 1) {
            dimString.deleteCharAt(dimString.length() - 1);
        }
        StringBuilder deleteSql = new StringBuilder();
        deleteSql.append("delete from t_eb_datasetdim where fdatasetdim in (");
        deleteSql.append((CharSequence)dimString);
        deleteSql.append(')');
        try {
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)deleteSql.toString(), null);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        HashMap datasetMap = new HashMap();
        StringBuilder sql = new StringBuilder();
        sql.append("select fid,fmodel from t_eb_dataset where fmodel in (");
        sql.append((CharSequence)modelStr);
        sql.append(')');
        DataSet ds = DB.queryDataSet((String)"queryDimEntry", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);
        dimId = null;
        try {
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                modelId = row.getLong("fmodel");
                if (datasetMap.containsKey(modelId)) {
                    ((Set)datasetMap.get(modelId)).add(row.getLong("fid"));
                    continue;
                }
                HashSet<Long> dataset = new HashSet<Long>();
                dataset.add(row.getLong("fid"));
                datasetMap.put(modelId, dataset);
            }
        }
        catch (Throwable throwable) {
            dimId = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (dimId != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)dimId).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (Map.Entry entry : datasetMap.entrySet()) {
            modelId = (Long)entry.getKey();
            for (Long datasetid : (Set)entry.getValue()) {
                list.addAll(this.packageDimEntry(datasetid, (Set)dimMap.get(modelId)));
            }
        }
        String insertSql = "insert into t_eb_datasetdim(fid,fentryid,fseq,fdatasetdim) values(?,?,?,?)";
        try {
            if (list != null && list.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertSql, list);
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
        }
    }

    private List<Object[]> packageDimEntry(Long datasetId, Set<Long> dimsId) {
        ArrayList<Object[]> ob = new ArrayList<Object[]>(16);
        if (dimsId == null) {
            return ob;
        }
        long[] ids = DB.genGlobalLongIds((int)dimsId.size());
        int i = 0;
        for (Long aLong : dimsId) {
            ArrayList<Number> ob1 = new ArrayList<Number>();
            ob1.add(datasetId);
            ob1.add(ids[i]);
            ob1.add(0);
            ob1.add(aLong);
            ob.add(ob1.toArray(new Object[ob1.size()]));
            ++i;
        }
        return ob;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Throwable throwable;
        TXHandle tx;
        UpgradeResult result;
        block18: {
            UpgradeResult upgradeResult;
            block19: {
                block20: {
                    result = new UpgradeResult();
                    tx = TX.requiresNew((String)"BgmdDataSetUpgrade");
                    throwable = null;
                    String msg = this.checkTableExist();
                    if (StringUtils.isEmpty((String)msg)) break block18;
                    result.setSuccess(false);
                    result.setLog("table " + msg + " does't exist, so don't need upgrade.");
                    upgradeResult = result;
                    if (tx == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                List<Long> modelIds = this.queryModelIds();
                this.upgradeDataDimEntry(modelIds);
                result.setSuccess(true);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }
}

