/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.dataset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.ApplicationScenarioEnum;
import kd.epm.eb.common.enums.BizModelEnum;
import kd.epm.eb.common.enums.DimensionViewEnum;
import kd.epm.eb.service.dataset.SimpleDimension;

public class DataSetUpgradeServiceImpl
implements IUpgradeService {
    private static final String CATALOG_ROOT = "datasetroot";
    private static final String CATALOG_DEFAULT = "default";

    private String checkTableExist() {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_applicationscenario")) {
            return "t_eb_applicationscenario";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_businessmodel")) {
            return "t_eb_businessmodel";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_datasetcatalog")) {
            return "t_eb_datasetcatalog";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_dataset")) {
            return "t_eb_dataset";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_structofaccount")) {
            return "t_eb_structofaccount";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_datasetdim")) {
            return "t_eb_datasetdim";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_dimensionview")) {
            return "t_eb_dimensionview";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_dimension")) {
            return "t_eb_dimension";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_scenarioentry")) {
            return "t_eb_scenarioentry";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_viewentry")) {
            return "t_eb_viewentry";
        }
        return "";
    }

    private Map<Long, Long> queryModelIds() {
        HashMap<Long, Long> modelIds = new HashMap<Long, Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"createbizModel_queryEpmBizModel", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fcreatorid from t_eb_model where freporttype='7'", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                modelIds.put(row.getLong("fid"), row.getLong("fcreatorid"));
            }
        }
        return modelIds;
    }

    private void createAppScenario(Map<Long, Long> modelIds) {
        if (modelIds == null || modelIds.isEmpty()) {
            return;
        }
        HashSet<Long> existModel = new HashSet<Long>(16);
        StringBuilder querysql = new StringBuilder();
        querysql.append("select fid,fnumber,fmodelid from t_eb_applicationscenario where fnumber in ('001','002') and fmodelid in (");
        for (Long l : modelIds.keySet()) {
            querysql.append(l).append(",");
        }
        querysql.deleteCharAt(querysql.length() - 1).append(")");
        Throwable exception = null;
        try (DataSet ds = DB.queryDataSet((String)"createBizModel_queryBizModel", (DBRoute)DBRoute.of((String)"epm"), (String)querysql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                existModel.add(row.getLong("fmodelid"));
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Long> entry : modelIds.entrySet()) {
            if (existModel.contains(entry.getKey())) continue;
            List<Object[]> list = this.packageAppScenario(entry.getKey(), entry.getValue());
            paramsList.addAll(list);
        }
        try {
            String string = String.join((CharSequence)",", this.appScenarioFields());
            String string2 = "insert into t_eb_applicationscenario(" + string + ") values(?,?,?,?,?,?,?,?,?,?)";
            if (paramsList != null && paramsList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)string2, paramsList);
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private List<Object[]> packageAppScenario(Long modelId, Long creatorId) {
        ArrayList<Object[]> ob = new ArrayList<Object[]>(16);
        List list = ApplicationScenarioEnum.getAll();
        long[] ids = DB.genGlobalLongIds((int)list.size());
        int i = 0;
        for (ApplicationScenarioEnum applicationScenarioEnum : list) {
            ArrayList<Object> ob1 = new ArrayList<Object>(16);
            ob1.add(ids[i]);
            ob1.add(applicationScenarioEnum.getNumber());
            ob1.add(applicationScenarioEnum.getName());
            ob1.add("");
            ob1.add(TimeServiceHelper.now());
            ob1.add(creatorId);
            ob1.add(TimeServiceHelper.now());
            ob1.add(creatorId);
            ob1.add(modelId);
            ob1.add(Integer.parseInt(applicationScenarioEnum.getIsSysPreset()));
            ob.add(ob1.toArray(new Object[ob1.size()]));
            ++i;
        }
        return ob;
    }

    private List<String> appScenarioFields() {
        ArrayList<String> appScenarioFields = new ArrayList<String>(16);
        appScenarioFields.add("fid");
        appScenarioFields.add("fnumber");
        appScenarioFields.add("fname");
        appScenarioFields.add("fdescription");
        appScenarioFields.add("fmodifytime");
        appScenarioFields.add("fmodifierid");
        appScenarioFields.add("fcreatetime");
        appScenarioFields.add("fcreatorid");
        appScenarioFields.add("fmodelid");
        appScenarioFields.add("fissyspreset");
        return appScenarioFields;
    }

    private void createDimensionView(Map<Long, Long> modelIds) {
        if (modelIds == null || modelIds.isEmpty()) {
            return;
        }
        HashMap<Long, Long> allModelIds = new HashMap<Long, Long>(modelIds);
        StringBuilder queryExistView = new StringBuilder();
        queryExistView.append("select fid,fnumber,fmodelid from t_eb_dimensionview where fsource = '1' and  fmodelid in (");
        for (Serializable aLong : allModelIds.keySet()) {
            queryExistView.append(aLong).append(',');
        }
        queryExistView.deleteCharAt(queryExistView.length() - 1).append(')');
        try {
            Serializable aLong;
            DataSet ds = DB.queryDataSet((String)"queryView", (DBRoute)DBRoute.of((String)"epm"), (String)queryExistView.toString(), null);
            aLong = null;
            try {
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    if (!allModelIds.containsKey(row.getLong("fmodelid"))) continue;
                    allModelIds.remove(row.getLong("fmodelid"));
                }
            }
            catch (Throwable row) {
                aLong = row;
                throw row;
            }
            finally {
                if (ds != null) {
                    if (aLong != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)aLong).addSuppressed(row);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (Exception ds) {
            // empty catch block
        }
        if (allModelIds.size() == 0) {
            return;
        }
        ArrayList<SimpleDimension> list = new ArrayList<SimpleDimension>(16);
        List numbers = DimensionViewEnum.getAllNumber();
        StringBuilder querysql = new StringBuilder();
        querysql.append("select d.fid,d.fnumber,dl.fname,d.fshortnumber,d.fmodelid,d.fissysdimension from t_eb_dimension d left join t_eb_dimension_l dl on d.fid=dl.fid where dl.flocaleid = 'zh_CN' and  fmodelid in (");
        for (Serializable aLong : allModelIds.keySet()) {
            querysql.append(aLong).append(",");
        }
        querysql.deleteCharAt(querysql.length() - 1).append(")");
        try {
            Serializable aLong;
            DataSet ds = DB.queryDataSet((String)"queryDimension", (DBRoute)DBRoute.of((String)"epm"), (String)querysql.toString(), null);
            aLong = null;
            try {
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    Long modelId = row.getLong("fmodelid");
                    String number = row.getString("fnumber");
                    String isSys = row.getString("fissysdimension");
                    if (!numbers.contains(number) && !"0".equals(isSys)) continue;
                    SimpleDimension dimension = new SimpleDimension(row.getLong("fid"), number, row.getString("fname"), row.getString("fshortnumber"), modelId, isSys);
                    list.add(dimension);
                }
            }
            catch (Throwable throwable) {
                aLong = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (aLong != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)aLong).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (Exception ds) {
            // empty catch block
        }
        try {
            String addViewSql = "insert into t_eb_dimensionview(" + this.dimensionViewField() + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            List<Object[]> paramList = this.packageDimensionView(list, allModelIds);
            if (paramList != null && paramList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)addViewSql, paramList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<Object[]> packageDimensionView(List<SimpleDimension> dimensions, Map<Long, Long> modelIds) {
        List enums = DimensionViewEnum.getAll();
        HashMap<String, DimensionViewEnum> map = new HashMap<String, DimensionViewEnum>(enums.size());
        for (DimensionViewEnum anEnum : enums) {
            map.put(anEnum.getDimensionNumber(), anEnum);
        }
        ArrayList<Object[]> obs = new ArrayList<Object[]>(16);
        long[] ids = DB.genGlobalLongIds((int)dimensions.size());
        int i = 0;
        for (SimpleDimension dimension : dimensions) {
            ArrayList<Object> ob = new ArrayList<Object>(16);
            ob.add(ids[i]);
            if (map.get(dimension.getNumber()) != null && StringUtils.isNotEmpty((String)((DimensionViewEnum)map.get(dimension.getNumber())).getNumber())) {
                ob.add(((DimensionViewEnum)map.get(dimension.getNumber())).getNumber());
                ob.add(((DimensionViewEnum)map.get(dimension.getNumber())).getName());
            } else {
                ob.add(dimension.getShortNumber() + "001");
                ob.add(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u57fa\u51c6\u89c6\u56fe", (String)"DataSetUpgradeServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[]{dimension.getName()}));
            }
            Long modelId = dimension.getModelId();
            ob.add(modelId);
            ob.add(dimension.getId());
            ob.add(1);
            ob.add(1);
            ob.add("!" + dimension.getNumber());
            ob.add("1");
            ob.add("1");
            ob.add(0L);
            ob.add("0");
            ob.add(0L);
            ob.add(modelIds.get(modelId));
            ob.add(TimeServiceHelper.now());
            ob.add(modelIds.get(modelId));
            ob.add(TimeServiceHelper.now());
            ob.add("");
            obs.add(ob.toArray(new Object[ob.size()]));
            ++i;
        }
        return obs;
    }

    private String dimensionViewField() {
        String field = "fid,fnumber,fname,fmodelid,fdimensionid,flevel,fdseq,flongnumber,fisleaf,fsource,fparentid,fusage,fbaseviewid,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fdescription";
        return field;
    }

    private Map<Long, Long> upgradeBusinessModel(Map<Long, Long> modelIds) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        if (modelIds == null || modelIds.isEmpty()) {
            return map;
        }
        Map<Long, Long> bizSuccess = this.updateBizModel(modelIds);
        this.updateScenarioEntry(bizSuccess);
        this.updateViewEntry(bizSuccess);
        return bizSuccess;
    }

    private Map<Long, Long> updateBizModel(Map<Long, Long> modelIds) {
        HashMap<Long, Long> bizMap = new HashMap<Long, Long>(16);
        ArrayList<Long> notExistBizList = new ArrayList<Long>(16);
        StringBuilder querysql = new StringBuilder();
        querysql.append("select fid,fnumber,fmodelid from t_eb_businessmodel where fnumber = 'AunnalBudget'and fmodelid in (");
        for (Long l : modelIds.keySet()) {
            querysql.append(l).append(",");
        }
        querysql.deleteCharAt(querysql.length() - 1).append(")");
        Throwable throwable = null;
        try (DataSet ds = DB.queryDataSet((String)"queryBizModel", (DBRoute)DBRoute.of((String)"epm"), (String)querysql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long modelId = row.getLong("fmodelid");
                if (!modelIds.containsKey(modelId)) continue;
                bizMap.put(row.getLong("fid"), modelId);
            }
        }
        catch (Throwable row) {
            Throwable throwable2 = row;
            throw row;
        }
        for (Map.Entry entry : modelIds.entrySet()) {
            if (bizMap.containsValue(entry.getKey())) continue;
            notExistBizList.add((Long)entry.getKey());
        }
        HashMap<Long, Long> successMap = new HashMap<Long, Long>(16);
        String string = this.getBizModelFields();
        try {
            String addViewSql = "insert into t_eb_businessmodel(" + string + ") values(?,?,?,?,?,?,?,?,?)";
            List<Object[]> paramsList = this.packBizModel(notExistBizList, modelIds, successMap);
            if (paramsList != null && paramsList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)addViewSql, paramsList);
            }
        }
        catch (Exception e) {
            successMap.clear();
        }
        successMap.putAll(bizMap);
        return successMap;
    }

    private List<Object[]> packBizModel(List<Long> modelIds, Map<Long, Long> modelIdUserMap, Map<Long, Long> successMap) {
        ArrayList<Object[]> objects = new ArrayList<Object[]>(16);
        BizModelEnum preset = BizModelEnum.AUNNALBUDGET;
        long[] ids = DB.genGlobalLongIds((int)modelIds.size());
        int i = 0;
        for (Long modelId : modelIds) {
            ArrayList<Object> objectList = new ArrayList<Object>(16);
            Long id = ids[i];
            objectList.add(id);
            objectList.add(preset.getNumber());
            objectList.add(preset.getName());
            objectList.add(modelId);
            objectList.add(preset.getIsSysPreset());
            objectList.add(modelIdUserMap.get(modelId));
            objectList.add(modelIdUserMap.get(modelId));
            objectList.add(TimeServiceHelper.now());
            objectList.add(TimeServiceHelper.now());
            objects.add(objectList.toArray(new Object[objectList.size()]));
            successMap.put(id, modelId);
            ++i;
        }
        return objects;
    }

    private String getBizModelFields() {
        String fields = "fid,fnumber,fname,fmodelid,fissyspreset,fcreatorid,fmodifierid,fcreatetime,fmodifytime";
        return fields;
    }

    private void updateScenarioEntry(Map<Long, Long> bizIdMap) {
        boolean bl;
        HashMap scenarioMap = new HashMap(16);
        HashMap<Long, Set<Long>> entryMap = new HashMap<Long, Set<Long>>(16);
        StringBuilder querysql = new StringBuilder();
        querysql.append("select fid,fnumber,fmodelid from t_eb_applicationscenario where fnumber in ('001','002') and fmodelid in (");
        for (Map.Entry<Long, Long> entry : bizIdMap.entrySet()) {
            querysql.append(entry.getValue()).append(",");
        }
        querysql.deleteCharAt(querysql.length() - 1).append(")");
        Throwable throwable = null;
        try (DataSet ds = DB.queryDataSet((String)"queryScenario", (DBRoute)DBRoute.of((String)"epm"), (String)querysql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long l = row.getLong("fmodelid");
                if (scenarioMap.containsKey(l)) {
                    ((Set)scenarioMap.get(l)).add(row.getLong("fid"));
                    continue;
                }
                HashSet<Long> scenarioId = new HashSet<Long>(16);
                scenarioId.add(row.getLong("fid"));
                scenarioMap.put(l, scenarioId);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Map.Entry entry : bizIdMap.entrySet()) {
            if (!scenarioMap.containsKey(entry.getValue())) continue;
            entryMap.put((Long)entry.getKey(), (Set<Long>)scenarioMap.get(entry.getValue()));
        }
        if (entryMap.size() == 0) {
            return;
        }
        StringBuilder querysql2 = new StringBuilder();
        querysql2.append("delete from t_eb_scenarioentry where fid in (");
        for (Map.Entry entry : entryMap.entrySet()) {
            querysql2.append(entry.getKey()).append(",");
        }
        querysql2.deleteCharAt(querysql2.length() - 1).append(")");
        querysql2.append(" and fappscenarioid in (");
        boolean bl2 = false;
        for (Map.Entry entry : entryMap.entrySet()) {
            if (entry.getValue() == null || ((Set)entry.getValue()).size() <= 0) continue;
            for (Long aLong : (Set)entry.getValue()) {
                querysql2.append(aLong).append(",");
            }
            bl = true;
            break;
        }
        querysql2.deleteCharAt(querysql2.length() - 1).append(")");
        if (bl) {
            try {
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)querysql2.toString(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        List<Object[]> list = this.packageScenarioEntry(entryMap);
        try {
            String string = this.getScenarioEntryFields();
            String insertSql = "insert into t_eb_scenarioentry(" + string + ") values(?,?,?,?)";
            if (list != null && list.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertSql, list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<Object[]> packageScenarioEntry(Map<Long, Set<Long>> entryMap) {
        ArrayList<Object[]> ob = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Set<Long>> entry : entryMap.entrySet()) {
            int i = 0;
            for (Long aLong : entry.getValue()) {
                ArrayList<Number> ob1 = new ArrayList<Number>(16);
                ob1.add(entry.getKey());
                ob1.add(this.getGlobalId());
                ob1.add(i);
                ob1.add(aLong);
                ++i;
                ob.add(ob1.toArray(new Object[ob1.size()]));
            }
        }
        return ob;
    }

    private long getGlobalId() {
        long id = DB.genGlobalLongId();
        return id;
    }

    private String getScenarioEntryFields() {
        String fields = "fid,fentryid,fseq,fappscenarioid";
        return fields;
    }

    private String getModelString(Set<Long> modelIds) {
        StringBuilder modelIdStr = new StringBuilder();
        for (Long modelId : modelIds) {
            modelIdStr.append(modelId).append(",");
        }
        modelIdStr.deleteCharAt(modelIdStr.length() - 1);
        return modelIdStr.toString();
    }

    private void updateViewEntry(Map<Long, Long> bizIdMap) {
        Object row32;
        Object row222;
        HashMap<Long, Set<SimpleDimension>> viewMap = new HashMap<Long, Set<SimpleDimension>>(16);
        HashMap<Long, Set<SimpleDimension>> dimMap = new HashMap<Long, Set<SimpleDimension>>(16);
        HashSet<Long> modelIdSet = new HashSet<Long>(bizIdMap.values());
        HashMap<Long, Long> bizNotExistMap = new HashMap<Long, Long>(16);
        String modelString = this.getModelString(modelIdSet);
        StringBuilder querysql2 = new StringBuilder();
        querysql2.append("select fid,fmodelid from t_eb_businessmodel a where not exists(select 1 from t_eb_viewentry b where a.fid=b.fid) and fmodelid in (");
        for (Map.Entry<Long, Long> entry : bizIdMap.entrySet()) {
            querysql2.append(entry.getValue()).append(",");
        }
        querysql2.deleteCharAt(querysql2.length() - 1).append(")");
        Throwable throwable = null;
        try (DataSet ds = DB.queryDataSet((String)"queryViewExist", (DBRoute)DBRoute.of((String)"epm"), (String)querysql2.toString(), null);){
            while (ds != null && ds.hasNext()) {
                row222 = ds.next();
                if (!bizIdMap.containsValue(row222.getLong("fmodelid"))) continue;
                bizNotExistMap.put(row222.getLong("fid"), row222.getLong("fmodelid"));
            }
        }
        catch (Throwable row222) {
            Throwable throwable2 = row222;
            throw row222;
        }
        StringBuilder queryViewsql = new StringBuilder();
        queryViewsql.append("select fid,fdimensionid,fmodelid from t_eb_dimensionview where fsource = '1' and fnumber not in('");
        queryViewsql.append(DimensionViewEnum.CTVIEW.getNumber());
        queryViewsql.append("','");
        queryViewsql.append(DimensionViewEnum.TRAILVIEW.getNumber());
        queryViewsql.append("') and fmodelid in (");
        queryViewsql.append(modelString).append(")");
        DataSet dataSet = DB.queryDataSet((String)"queryView", (DBRoute)DBRoute.of((String)"epm"), (String)queryViewsql.toString(), null);
        row222 = null;
        try {
            while (dataSet != null && dataSet.hasNext()) {
                row32 = dataSet.next();
                Long modelId = row32.getLong("fmodelid");
                if (viewMap.containsKey(modelId)) {
                    ((Set)viewMap.get(modelId)).add(new SimpleDimension(row32.getLong("fdimensionid"), row32.getLong("fid"), row32.getLong("fmodelid")));
                    continue;
                }
                HashSet<SimpleDimension> viewDimension = new HashSet<SimpleDimension>(16);
                viewDimension.add(new SimpleDimension(row32.getLong("fdimensionid"), row32.getLong("fid"), row32.getLong("fmodelid")));
                viewMap.put(modelId, viewDimension);
            }
        }
        catch (Throwable row32) {
            row222 = row32;
            throw row32;
        }
        finally {
            if (dataSet != null) {
                if (row222 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row32) {
                        ((Throwable)row222).addSuppressed(row32);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select fid,fmodelid from t_eb_dimension where fmodelid in(").append(modelString).append(")");
        DataSet ds3 = DB.queryDataSet((String)"queryDim", (DBRoute)DBRoute.of((String)"epm"), (String)stringBuilder.toString(), null);
        row32 = null;
        try {
            while (ds3 != null && ds3.hasNext()) {
                Row row4 = ds3.next();
                Long modelId = row4.getLong("fmodelid");
                if (dimMap.containsKey(modelId)) {
                    ((Set)dimMap.get(modelId)).add(new SimpleDimension(row4.getLong("fid"), 0L, row4.getLong("fmodelid")));
                    continue;
                }
                HashSet<SimpleDimension> dim = new HashSet<SimpleDimension>(16);
                dim.add(new SimpleDimension(row4.getLong("fid"), 0L, row4.getLong("fmodelid")));
                dimMap.put(modelId, dim);
            }
        }
        catch (Throwable row4) {
            row32 = row4;
            throw row4;
        }
        finally {
            if (ds3 != null) {
                if (row32 != null) {
                    try {
                        ds3.close();
                    }
                    catch (Throwable row4) {
                        ((Throwable)row32).addSuppressed(row4);
                    }
                } else {
                    ds3.close();
                }
            }
        }
        List<Object[]> paramsList = this.packageViewEntry(viewMap, dimMap, bizNotExistMap);
        try {
            String fields = this.getViewEntryFields();
            String insertSql = "insert into t_eb_viewentry(" + fields + ") values(?,?,?,?,?)";
            if (paramsList != null && paramsList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertSql, paramsList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<Object[]> packageViewEntry(Map<Long, Set<SimpleDimension>> viewMap, Map<Long, Set<SimpleDimension>> dimMap, Map<Long, Long> bizIdMap) {
        ArrayList<Object[]> ob = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Long> entry : bizIdMap.entrySet()) {
            if (viewMap.get(entry.getValue()) == null) continue;
            Set<SimpleDimension> viewSet = viewMap.get(entry.getValue());
            Set<SimpleDimension> dimSet = dimMap.get(entry.getValue());
            HashSet<SimpleDimension> set = new HashSet<SimpleDimension>(16);
            for (SimpleDimension dimension : dimSet) {
                boolean isAddToSet = false;
                for (SimpleDimension simpleDimension : viewSet) {
                    if (!dimension.getId().equals(simpleDimension.getId())) continue;
                    set.add(simpleDimension);
                    isAddToSet = true;
                    break;
                }
                if (isAddToSet) continue;
                set.add(dimension);
            }
            long[] ids = this.getIds(set.size());
            int index = 0;
            for (SimpleDimension dimension : set) {
                ArrayList<Number> list = new ArrayList<Number>(16);
                list.add(entry.getKey());
                list.add(ids[index]);
                list.add(0);
                list.add(dimension.getId());
                list.add(dimension.getViewId());
                ++index;
                ob.add(list.toArray(new Object[0]));
            }
        }
        return ob;
    }

    private long[] getIds(int size) {
        long[] ids = DB.genGlobalLongIds((int)size);
        return ids;
    }

    private String getViewEntryFields() {
        String fields = "fid,fentryid,fseq,fdimensionid,fviewid";
        return fields;
    }

    private Map<Long, Object> createDatasetCatalog(Map<Long, Long> modelIds) {
        HashMap<Long, Object> resultmap = new HashMap<Long, Object>(16);
        if (modelIds == null || modelIds.isEmpty()) {
            return resultmap;
        }
        HashSet<Long> existModel = new HashSet<Long>(16);
        StringBuilder querysql = new StringBuilder();
        querysql.append("select fid,fnumber,fmodelid from t_eb_datasetcatalog where fnumber in ('default','datasetroot') and fmodelid in (");
        for (Long l : modelIds.keySet()) {
            querysql.append(l).append(",");
        }
        querysql.deleteCharAt(querysql.length() - 1).append(")");
        Throwable throwable = null;
        try (DataSet ds = DB.queryDataSet((String)"createDataSetCatalog_queryDataSetCatalog", (DBRoute)DBRoute.of((String)"epm"), (String)querysql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                existModel.add(row.getLong("fmodelid"));
            }
        }
        catch (Throwable row) {
            Throwable throwable2 = row;
            throw row;
        }
        HashMap<Long, Object> map = new HashMap<Long, Object>(16);
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(16);
        for (Map.Entry entry : modelIds.entrySet()) {
            if (existModel.contains(entry.getKey())) continue;
            List<Object[]> params = this.preDataSetCatalog((Long)entry.getKey(), (Long)entry.getValue());
            arrayList.addAll(params);
            map.put((Long)entry.getKey(), params.get(1)[0]);
        }
        if (arrayList.size() > 0) {
            String insertSql = "insert into t_eb_datasetcatalog(fid,fname,fnumber,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fmodelid,fparentid,flongname) values(?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertSql, arrayList);
        }
        return map;
    }

    private List<Object[]> preDataSetCatalog(Long modelId, Long creatorId) {
        ArrayList<Object[]> ob = new ArrayList<Object[]>(16);
        ArrayList<Object> ob1 = new ArrayList<Object>(16);
        Long rootId = DB.genGlobalLongId();
        ob1.add(rootId);
        ob1.add(ResManager.loadKDString((String)"\u6570\u636e\u96c6", (String)"DataSetUpgradeServiceImpl_1", (String)"epm-eb-mservice", (Object[])new Object[0]));
        ob1.add(CATALOG_ROOT);
        ob1.add(creatorId);
        ob1.add(TimeServiceHelper.now());
        ob1.add(creatorId);
        ob1.add(TimeServiceHelper.now());
        ob1.add(modelId);
        ob1.add(0L);
        ob1.add("");
        ob.add(ob1.toArray(new Object[0]));
        ArrayList<Object> ob2 = new ArrayList<Object>(16);
        ob2.add(DB.genGlobalLongId());
        ob2.add(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5206\u7c7b", (String)"DataSetUpgradeServiceImpl_2", (String)"epm-eb-mservice", (Object[])new Object[0]));
        ob2.add(CATALOG_DEFAULT);
        ob2.add(creatorId);
        ob2.add(TimeServiceHelper.now());
        ob2.add(creatorId);
        ob2.add(TimeServiceHelper.now());
        ob2.add(modelId);
        ob2.add(rootId);
        ob2.add("." + rootId.toString());
        ob.add(ob2.toArray(new Object[0]));
        return ob;
    }

    private Map<Long, Object> createDataSet(Map<Long, Long> modelIds, Map<Long, Object> map, Map<Long, Long> bizMap) {
        HashMap<Long, Object> resultmap = new HashMap<Long, Object>(16);
        if (modelIds.size() == 0 || map.size() == 0 || bizMap.size() == 0) {
            return resultmap;
        }
        HashMap<Long, Object> datasetIds = new HashMap<Long, Object>(16);
        HashSet<Long> existModel = new HashSet<Long>(16);
        StringBuilder querysql = new StringBuilder();
        querysql.append("select fid,fnumber,fmodel from t_eb_dataset where fnumber = 'default' and fmodel in (");
        for (Long l : modelIds.keySet()) {
            querysql.append(l).append(",");
        }
        querysql.deleteCharAt(querysql.length() - 1).append(")");
        Throwable exception = null;
        try (DataSet ds = DB.queryDataSet((String)"createDataSet_queryDataSet", (DBRoute)DBRoute.of((String)"epm"), (String)querysql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                existModel.add(row.getLong("fmodel"));
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Long> entry : modelIds.entrySet()) {
            if (existModel.contains(entry.getKey()) || map.get(entry.getKey()) == null) continue;
            for (Map.Entry<Long, Long> entry2 : bizMap.entrySet()) {
                if (!entry2.getValue().equals(entry.getKey())) continue;
                Object[] params = this.preDataSet(entry.getKey(), entry.getValue(), map.get(entry.getKey()), entry2.getKey());
                paramList.add(params);
                datasetIds.put(entry.getKey(), params[0]);
            }
        }
        try {
            if (paramList == null || paramList.size() == 0) {
                return datasetIds;
            }
            String string = "insert into t_eb_dataset(fid,fnumber,fname,fcatalog,fmodel,fcreator,fcreatedate,fmodifier,fmodifydate,fbizmodelid) values(?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)string, paramList);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return datasetIds;
    }

    private Object[] preDataSet(Long modelId, Long creatorId, Object parentId, Long bizmodelId) {
        ArrayList<Object> ob1 = new ArrayList<Object>(16);
        ob1.add(DB.genGlobalLongId());
        ob1.add(CATALOG_DEFAULT);
        ob1.add(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6570\u636e\u96c6", (String)"DataSetUpgradeServiceImpl_3", (String)"epm-eb-mservice", (Object[])new Object[0]));
        ob1.add(parentId);
        ob1.add(modelId);
        ob1.add(creatorId);
        ob1.add(TimeServiceHelper.now());
        ob1.add(creatorId);
        ob1.add(TimeServiceHelper.now());
        ob1.add(bizmodelId);
        return ob1.toArray(new Object[0]);
    }

    private void upgradeDataset(Map<Long, Long> modelIds, Map<Long, Long> bizMap) {
        if (modelIds.size() == 0 || bizMap.size() == 0) {
            return;
        }
        HashMap needUpdate = new HashMap(16);
        StringBuilder querysql = new StringBuilder();
        querysql.append("select fid,fnumber,fmodel from t_eb_dataset where fbizmodelid = 0 and fmodel in (");
        for (Long l : modelIds.keySet()) {
            querysql.append(l).append(",");
        }
        querysql.deleteCharAt(querysql.length() - 1).append(")");
        Throwable throwable = null;
        try (DataSet ds = DB.queryDataSet((String)"createDataSet_queryDataSet", (DBRoute)DBRoute.of((String)"epm"), (String)querysql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long modelId = row.getLong("fmodel");
                if (needUpdate.get(modelId) == null) {
                    HashSet<Long> set = new HashSet<Long>(16);
                    set.add(row.getLong("fid"));
                    needUpdate.put(modelId, set);
                    continue;
                }
                ((Set)needUpdate.get(modelId)).add(row.getLong("fid"));
            }
        }
        catch (Throwable row) {
            Throwable throwable2 = row;
            throw row;
        }
        if (needUpdate.size() == 0) {
            return;
        }
        for (Map.Entry entry : bizMap.entrySet()) {
            Long modelId = (Long)entry.getValue();
            Long bizModelId = (Long)entry.getKey();
            if (needUpdate.get(modelId) == null || ((Set)needUpdate.get(modelId)).size() <= 0) continue;
            StringBuilder idString = new StringBuilder();
            for (Long id : (Set)needUpdate.get(modelId)) {
                idString.append(id).append(",");
            }
            idString.deleteCharAt(idString.length() - 1);
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("update t_eb_dataset set fbizmodelid = ? where fid in (");
            insertSql.append((CharSequence)idString);
            insertSql.append(")");
            try {
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)insertSql.toString(), (Object[])new Object[]{bizModelId});
            }
            catch (Exception exception) {}
        }
    }

    private void upgradeDataDimEntry(Map<Long, Long> modelIds) {
        Long modelId;
        Object modelId2;
        if (modelIds.size() == 0) {
            return;
        }
        StringBuilder modelStr = new StringBuilder();
        for (Long aLong : modelIds.keySet()) {
            modelStr.append(aLong).append(",");
        }
        modelStr.deleteCharAt(modelStr.length() - 1);
        HashMap dimMap = new HashMap(16);
        StringBuilder queryDimSql = new StringBuilder();
        queryDimSql.append("select fid,fnumber,fmodelid from t_eb_dimension where fmodelid in (");
        queryDimSql.append((CharSequence)modelStr);
        queryDimSql.append(')');
        try (DataSet ds = DB.queryDataSet((String)"queryDimension", (DBRoute)DBRoute.of((String)"epm"), (String)queryDimSql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                modelId2 = row.getLong("fmodelid");
                if (dimMap.containsKey(modelId2)) {
                    ((Set)dimMap.get(modelId2)).add(row.getLong("fid"));
                    continue;
                }
                HashSet<Long> hashSet = new HashSet<Long>(16);
                hashSet.add(row.getLong("fid"));
                dimMap.put((Long)modelId2, hashSet);
            }
        }
        HashMap datasetMap = new HashMap(16);
        StringBuilder sql = new StringBuilder();
        sql.append("select fid,fmodel from t_eb_dataset a where not exists(select 1 from t_eb_datasetdim b where a.fid=b.fid) and fmodel in (");
        sql.append((CharSequence)modelStr);
        sql.append(')');
        DataSet ds = DB.queryDataSet((String)"queryDimEntry", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);
        modelId2 = null;
        try {
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                modelId = row.getLong("fmodel");
                if (datasetMap.containsKey(modelId)) {
                    ((Set)datasetMap.get(modelId)).add(row.getLong("fid"));
                    continue;
                }
                HashSet<Long> dataset = new HashSet<Long>(16);
                dataset.add(row.getLong("fid"));
                datasetMap.put(modelId, dataset);
            }
        }
        catch (Throwable throwable) {
            modelId2 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (modelId2 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable exception) {
                        ((Throwable)modelId2).addSuppressed(exception);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>(16);
        for (Map.Entry entry : datasetMap.entrySet()) {
            modelId = (Long)entry.getKey();
            for (Long datasetid : (Set)entry.getValue()) {
                list.addAll(this.packageDimEntry(datasetid, (Set)dimMap.get(modelId)));
            }
        }
        String insertSql = "insert into t_eb_datasetdim(fid,fentryid,fseq,fdatasetdim) values(?,?,?,?)";
        try {
            if (list != null && list.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertSql, list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<Object[]> packageDimEntry(Long datasetId, Set<Long> dimsId) {
        ArrayList<Object[]> ob = new ArrayList<Object[]>(16);
        if (dimsId == null) {
            return ob;
        }
        for (Long aLong : dimsId) {
            ArrayList<Number> ob1 = new ArrayList<Number>(16);
            ob1.add(datasetId);
            ob1.add(this.getGlobalId());
            ob1.add(0);
            ob1.add(aLong);
            ob.add(ob1.toArray(new Object[ob1.size()]));
        }
        return ob;
    }

    private void updateAccount(Map<Long, Long> modelIds) {
        Serializable modelId;
        if (modelIds.size() == 0) {
            return;
        }
        HashMap accountMap = new HashMap(16);
        StringBuilder modelStr = new StringBuilder();
        for (Long aLong : modelIds.keySet()) {
            modelStr.append(aLong).append(",");
        }
        modelStr.deleteCharAt(modelStr.length() - 1);
        StringBuilder querysql = new StringBuilder();
        querysql.append("select fid,fnumber,fmodelid,fdataset from t_eb_structofaccount where fnumber != 'Account' and fdataset = 0 and fmodelid in (");
        querysql.append((CharSequence)modelStr).append(")");
        try (DataSet ds = DB.queryDataSet((String)"queryAccount", (DBRoute)DBRoute.of((String)"epm"), (String)querysql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                modelId = row.getLong("fmodelid");
                if (accountMap.containsKey(modelId)) {
                    ((Set)accountMap.get(modelId)).add(row.getLong("fid"));
                    continue;
                }
                HashSet<Long> accountId = new HashSet<Long>(16);
                accountId.add(row.getLong("fid"));
                accountMap.put((Long)modelId, accountId);
            }
        }
        HashMap<Long, Long> datasetMap = new HashMap<Long, Long>(16);
        StringBuilder sql = new StringBuilder();
        sql.append("select fid,fmodel from t_eb_dataset where fnumber='default' and fmodel in (");
        sql.append((CharSequence)modelStr);
        sql.append(")");
        DataSet ds = DB.queryDataSet((String)"queryDimEntry", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);
        modelId = null;
        try {
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long modelId2 = row.getLong("fmodel");
                datasetMap.put(modelId2, row.getLong("fid"));
            }
        }
        catch (Throwable row) {
            modelId = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (modelId != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)modelId).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        for (Map.Entry entry : datasetMap.entrySet()) {
            if (!accountMap.containsKey(entry.getKey())) continue;
            StringBuilder updateSql = new StringBuilder();
            updateSql.append("update t_eb_structofaccount set fdataset = ");
            updateSql.append(entry.getValue());
            updateSql.append(" where fid in (");
            for (Long aLong : (Set)accountMap.get(entry.getKey())) {
                updateSql.append(aLong).append(",");
            }
            updateSql.deleteCharAt(updateSql.length() - 1).append(")");
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)updateSql.toString(), null);
        }
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Map<Long, Long> modelMap;
        Throwable throwable;
        TXHandle tx;
        UpgradeResult result;
        block24: {
            UpgradeResult upgradeResult;
            block25: {
                block26: {
                    block21: {
                        UpgradeResult upgradeResult2;
                        block22: {
                            block23: {
                                result = new UpgradeResult();
                                tx = TX.requiresNew((String)"BgmdDataSetUpgrade");
                                throwable = null;
                                String msg = this.checkTableExist();
                                if (StringUtils.isEmpty((String)msg)) break block21;
                                result.setSuccess(false);
                                result.setLog("table " + msg + " does't exist, so don't need upgrade.");
                                upgradeResult2 = result;
                                if (tx == null) break block22;
                                if (throwable == null) break block23;
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block22;
                            }
                            tx.close();
                        }
                        return upgradeResult2;
                    }
                    modelMap = this.queryModelIds();
                    if (modelMap != null && modelMap.size() != 0) break block24;
                    upgradeResult = result;
                    if (tx == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                this.createAppScenario(modelMap);
                this.createDimensionView(modelMap);
                Map<Long, Long> bizMap = this.upgradeBusinessModel(modelMap);
                Map<Long, Object> catalogModelMap = this.createDatasetCatalog(modelMap);
                this.createDataSet(modelMap, catalogModelMap, bizMap);
                this.upgradeDataset(modelMap, bizMap);
                this.upgradeDataDimEntry(modelMap);
                this.updateAccount(modelMap);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }
}

