/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;
import kd.epm.eb.service.dataset.SimpleChangeType;

public class UpdateAccountAddFormulaImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Throwable throwable;
        TXHandle tx;
        UpgradeResult result;
        block18: {
            UpgradeResult upgradeResult;
            block19: {
                block20: {
                    result = new UpgradeResult();
                    tx = TX.requiresNew((String)"BgmdAccountUpgrade");
                    throwable = null;
                    String msg = this.checkTableExist();
                    if (StringUtils.isEmpty((String)msg)) break block18;
                    result.setSuccess(false);
                    result.setLog("table " + msg + " does't exist, so don't need upgrade.");
                    upgradeResult = result;
                    if (tx == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                List<Long> models = this.queryModelIds();
                Map<Long, Long> map = this.queryDimensionByNumber(models);
                this.updateAccount(map);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }

    private Map<Long, Long> queryDimensionByNumber(List<Long> modelIds) {
        if (modelIds.size() == 0) {
            return null;
        }
        StringBuilder modelStr = new StringBuilder();
        for (Long aLong : modelIds) {
            modelStr.append(aLong).append(",");
        }
        if (modelStr.length() < 1) {
            return null;
        }
        modelStr.deleteCharAt(modelStr.length() - 1);
        HashMap<Long, Long> dimMap = new HashMap<Long, Long>(16);
        StringBuilder queryDimSql = new StringBuilder();
        queryDimSql.append("select fid,fnumber,fmodelid from t_eb_dimension where fmodelid in (");
        queryDimSql.append((CharSequence)modelStr);
        queryDimSql.append(") and fnumber = 'ChangeType'");
        try (DataSet ds = DB.queryDataSet((String)"queryDimension", (DBRoute)DBRoute.of((String)"epm"), (String)queryDimSql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                dimMap.put(row.getLong("fmodelid"), row.getLong("fid"));
            }
        }
        return dimMap;
    }

    private void updateAccount(Map<Long, Long> modelIds) {
        if (modelIds == null) {
            return;
        }
        StringBuilder dimStr = new StringBuilder();
        for (Map.Entry<Long, Long> entry : modelIds.entrySet()) {
            dimStr.append(entry.getValue()).append(",");
        }
        dimStr.deleteCharAt(dimStr.length() - 1);
        HashMap<Long, Long> dimMap = new HashMap<Long, Long>(16);
        StringBuilder queryDimSql = new StringBuilder();
        queryDimSql.append("select fid,fmodelid from t_eb_dimensionview where fsource='1' and  fdimensionid in (");
        queryDimSql.append((CharSequence)dimStr);
        queryDimSql.append(')');
        StringBuilder viewString = new StringBuilder();
        try (DataSet ds = DB.queryDataSet((String)"queryView", (DBRoute)DBRoute.of((String)"epm"), (String)queryDimSql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                viewString.append(row.getLong("fid")).append(",");
                dimMap.put(row.getLong("fmodelid"), row.getLong("fid"));
            }
        }
        if (dimMap.size() == 0) {
            return;
        }
        if (viewString.length() >= 1) {
            viewString.deleteCharAt(viewString.length() - 1);
        }
        ArrayList<SimpleChangeType> list = new ArrayList<SimpleChangeType>(16);
        StringBuilder queryCTSql = new StringBuilder();
        queryCTSql.append("select fid,fviewid,fmodelid from t_eb_structofchangetype where fnumber='EndingBalance' and  fviewid in (");
        queryCTSql.append((CharSequence)viewString);
        queryCTSql.append(')');
        try (DataSet ds = DB.queryDataSet((String)"queryCT", (DBRoute)DBRoute.of((String)"epm"), (String)queryCTSql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                list.add(new SimpleChangeType(row.getLong("fid"), row.getLong("fviewid"), row.getLong("fmodelid")));
            }
        }
        if (list.size() == 0) {
            return;
        }
        List<Object[]> obList = this.packageDimEntry(list);
        String insertSql = "update t_eb_structofaccount set fctview= ? ,fctmemberid= ? where fmodelid= ?";
        try {
            if (obList != null && obList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertSql, obList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<Object[]> packageDimEntry(List<SimpleChangeType> list) {
        ArrayList<Object[]> ob = new ArrayList<Object[]>(16);
        if (list == null) {
            return ob;
        }
        for (SimpleChangeType type : list) {
            ArrayList<Long> ob1 = new ArrayList<Long>(16);
            ob1.add(type.getViewid());
            ob1.add(type.getId());
            ob1.add(type.getModelId());
            ob.add(ob1.toArray(new Object[ob1.size()]));
        }
        return ob;
    }

    private String checkTableExist() {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_structofaccount")) {
            return "t_eb_structofaccount";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_model")) {
            return "t_eb_model";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_structofchangetype")) {
            return "t_eb_structofchangetype";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_dimensionview")) {
            return "t_eb_dimensionview";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_dimension")) {
            return "t_eb_dimension";
        }
        return "";
    }

    private List<Long> queryModelIds() {
        ArrayList<Long> modelIds = new ArrayList<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryModel", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid from t_eb_model where freporttype='7'", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                modelIds.add(row.getLong("fid"));
            }
        }
        return modelIds;
    }
}

