/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.defined;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import org.apache.commons.lang3.StringUtils;

public class AdjustRuleEntityUpgradeServiceImpl
implements IUpgradeService {
    private static final DBRoute DB_EPM = DBRoute.of((String)"epm");
    private static final String PLANT_KEY = "AdjustRuleEntityUpgrade";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"AdjustRuleEntityUpgradeService");){
            if (!UpdateRecordHelper.isUpdated((String)PLANT_KEY)) {
                int size = this.doUpgrade();
                if (size > 0) {
                    result.setLog("upgrade success.");
                    UpdateRecordHelper.addRecord((String)PLANT_KEY, null, null, (boolean)true);
                } else {
                    result.setLog("table t_eb_adjustrule_detail don't need upgrade.");
                }
            } else {
                result.setLog("this script had invoke.");
            }
            result.setSuccess(true);
            UpgradeResult size = result;
            return size;
        }
        catch (Exception e) {
            result.setSuccess(false);
            StackTraceElement[] arr = e.getStackTrace();
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement ele : arr) {
                sb.append(ele.toString()).append("\r\n");
            }
            result.setLog(e.getMessage());
            result.setErrorInfo(sb.toString());
            tx.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return result;
    }

    private int doUpgrade() {
        String sql = "select fid,fentity from t_eb_adjustrule_detail where fid in (select fid from t_eb_adjustrule)";
        HashMap oldEntityMap = new HashMap(16);
        DB.query((DBRoute)DB_EPM, (String)sql, rs -> {
            while (rs.next()) {
                long fid = rs.getLong("fid");
                String fentity = rs.getString("fentity");
                if (!StringUtils.isNotEmpty((CharSequence)fentity)) continue;
                oldEntityMap.put(fid, fentity);
            }
            return oldEntityMap;
        });
        HashMap<Object, String> newEntityMap = new HashMap<Object, String>(16);
        if (oldEntityMap.size() > 0) {
            for (Map.Entry entry : oldEntityMap.entrySet()) {
                Long key = (Long)entry.getKey();
                String string = (String)entry.getValue();
                String[] split = string.split(";");
                ArrayList<String> member = new ArrayList<String>(10);
                for (String s : split) {
                    String[] strings;
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!StringUtils.isNotEmpty((CharSequence)s) || (strings = s.split("!!")).length != 3) continue;
                    for (int i = 0; i < strings.length; ++i) {
                        if (i == 1) {
                            stringBuilder.append("1").append("!!");
                        }
                        if (i == strings.length - 1) {
                            stringBuilder.append(strings[i]);
                            continue;
                        }
                        stringBuilder.append(strings[i]).append("!!");
                    }
                    member.add(stringBuilder.toString());
                }
                if (member.size() <= 0) continue;
                newEntityMap.put(key, StringUtils.join(member, (String)";"));
            }
        }
        if (newEntityMap.size() > 0) {
            String updateSql = "update t_eb_adjustrule_detail set fentity = ? where fid = ?";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(newEntityMap.size());
            for (Map.Entry entry : newEntityMap.entrySet()) {
                Object[] objects = new Object[]{entry.getValue(), entry.getKey()};
                paramList.add(objects);
            }
            int[] ints = DB.executeBatch((DBRoute)DB_EPM, (String)updateSql, paramList);
            return ints.length;
        }
        return 0;
    }
}

