/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.defined;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.lang.Lang;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.business.examine.ExamineServiceHelper;
import kd.epm.eb.common.centralapproval.SimpleMemberDto;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import org.apache.commons.lang3.StringUtils;

public class ExamineEntityUpgradeServiceImpl
implements IUpgradeService {
    private static final DBRoute DB_EPM = DBRoute.of((String)"epm");
    private static final String PLANT_KEY = "ExamineEntityUpgrade";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"ExamineEntityUpgradeService");){
            if (!UpdateRecordHelper.isUpdated((String)PLANT_KEY)) {
                int size = this.doUpgrade();
                if (size > 0) {
                    result.setLog("upgrade success.");
                    UpdateRecordHelper.addRecord((String)PLANT_KEY, null, null, (boolean)true);
                } else {
                    result.setLog("table t_eb_examine don't need upgrade.");
                }
            } else {
                result.setLog("this script had invoke.");
            }
            result.setSuccess(true);
            UpgradeResult size = result;
            return size;
        }
        catch (Exception e) {
            result.setSuccess(false);
            StackTraceElement[] arr = e.getStackTrace();
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement ele : arr) {
                sb.append(ele.toString()).append("\r\n");
            }
            result.setLog(e.getMessage());
            result.setErrorInfo(sb.toString());
            tx.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return result;
    }

    private int doUpgrade() {
        int executeRows = 0;
        String sql = "select fid,fmodelid,frangediminfo from t_eb_examine where 1=1;";
        ArrayList needUpgradeModel = new ArrayList(10);
        DB.query((DBRoute)DB_EPM, (String)sql, rs -> {
            while (rs.next()) {
                long modelId = rs.getLong("fmodelid");
                String rangeDimInfo = rs.getString("frangediminfo");
                if (!StringUtils.isNotBlank((CharSequence)rangeDimInfo) || !rangeDimInfo.contains("|")) continue;
                needUpgradeModel.add(modelId);
            }
            return needUpgradeModel;
        });
        for (Long aLong : needUpgradeModel) {
            executeRows += this.doUpgrade(aLong);
        }
        return executeRows;
    }

    private int doUpgrade(Long modelId) {
        String sql = "select fid,frangediminfo from t_eb_examine where fmodelid =  " + modelId + " ;";
        HashMap<Long, String> needUpgradeData = new HashMap<Long, String>(16);
        DB.query((DBRoute)DB_EPM, (String)sql, rs -> {
            while (rs.next()) {
                long fid = rs.getLong("fid");
                String rangeDimInfo = rs.getString("frangediminfo");
                if (!StringUtils.isNotEmpty((CharSequence)rangeDimInfo) || !rangeDimInfo.contains("|")) continue;
                needUpgradeData.put(fid, rangeDimInfo);
            }
            return needUpgradeData;
        });
        if (needUpgradeData.size() > 0) {
            Map<String, Map<String, SimpleMemberDto>> needDimMemberData = this.getNeedDimMemberData(modelId, needUpgradeData);
            String updateSql = "update t_eb_examine set frangediminfo = ? where fid = ?";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(needUpgradeData.size());
            for (Map.Entry entry : needUpgradeData.entrySet()) {
                Object[] objects = new Object[]{this.upgradeRangeDimInfo((String)entry.getValue(), needDimMemberData), entry.getKey()};
                paramList.add(objects);
            }
            int[] ints = DB.executeBatch((DBRoute)DB_EPM, (String)updateSql, paramList);
            return ints.length;
        }
        return 0;
    }

    private Map<String, Map<String, SimpleMemberDto>> getNeedDimMemberData(Long modelId, Map<Long, String> needUpgradeData) {
        HashMap<String, Map<String, SimpleMemberDto>> needDimMemberData = new HashMap<String, Map<String, SimpleMemberDto>>(16);
        HashMap<String, Set> dimRangeMemberNumber = new HashMap<String, Set>(16);
        for (Map.Entry<Long, String> entry : needUpgradeData.entrySet()) {
            String dimRangeStr = entry.getValue();
            Map dimRangeDataMap = ExamineServiceHelper.parseDimRangeStr2Map((String)dimRangeStr);
            for (Map.Entry dimRangeDataEntry : dimRangeDataMap.entrySet()) {
                String dimNumber = (String)dimRangeDataEntry.getKey();
                List memNumberScopes = (List)dimRangeDataEntry.getValue();
                if (CollectionUtils.isEmpty((Collection)memNumberScopes)) continue;
                Set memberNumbers = dimRangeMemberNumber.computeIfAbsent(dimNumber, e -> new HashSet(16));
                for (Pair pair : memNumberScopes) {
                    memberNumbers.add("'" + (String)pair.getKey() + "'");
                }
            }
        }
        if (dimRangeMemberNumber.size() > 0) {
            for (Map.Entry<Long, String> entry : dimRangeMemberNumber.entrySet()) {
                String dimNumber = (String)((Object)entry.getKey());
                Set memNums = (Set)((Object)entry.getValue());
                Map<String, SimpleMemberDto> dimMemberData = this.getDimMemberData(dimNumber, modelId, memNums);
                needDimMemberData.put(dimNumber, dimMemberData);
            }
        }
        return needDimMemberData;
    }

    private Map<String, SimpleMemberDto> getDimMemberData(String dimNumber, Long modelId, Set<String> memNums) {
        HashMap<String, SimpleMemberDto> dimMemberData = new HashMap<String, SimpleMemberDto>(16);
        String memberTable = SysDimensionEnum.getMemberTableByNumber((String)dimNumber);
        String memberTable_l = memberTable + "_l";
        Lang lang = Lang.get();
        String sql = "select a.fid,a.fnumber,b.fname from " + memberTable + " a left join " + memberTable_l + " b on a.fid = b.fid  AND B.FLocaleId = '" + lang.name() + "' where a.fmodelid = " + modelId + " and a.fnumber in (" + String.join((CharSequence)",", memNums) + ");";
        try (DataSet ds = DB.queryDataSet((String)"getNeedModelDimMemData", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long id = row.getLong("fid");
                String number = row.getString("fnumber");
                String name = row.getString("fname");
                dimMemberData.put(number, new SimpleMemberDto(id, name, number));
            }
        }
        return dimMemberData;
    }

    private String upgradeRangeDimInfo(String dimRangeStr, Map<String, Map<String, SimpleMemberDto>> needDimMemberData) {
        HashMap dimMemberConditionMap = new HashMap(16);
        Map dimRangeDataMap = ExamineServiceHelper.parseDimRangeStr2Map((String)dimRangeStr);
        for (Map.Entry entry : dimRangeDataMap.entrySet()) {
            String dimNumber = (String)entry.getKey();
            List memNumberScopes = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)memNumberScopes)) continue;
            ArrayList<MemberCondition> memberConditions = new ArrayList<MemberCondition>(memNumberScopes.size());
            for (Pair memNumberScope : memNumberScopes) {
                String memNumber = (String)memNumberScope.getKey();
                String scope = (String)memNumberScope.getValue();
                if (needDimMemberData.get(dimNumber) != null && needDimMemberData.get(dimNumber).get(memNumber) != null) {
                    SimpleMemberDto simpleMemberDto = needDimMemberData.get(dimNumber).get(memNumber);
                    MemberCondition memberCondition = new MemberCondition();
                    memberConditions.add(memberCondition);
                    memberCondition.setId(String.valueOf(simpleMemberDto.getId()));
                    memberCondition.setName(simpleMemberDto.getName());
                    memberCondition.setNumber(simpleMemberDto.getNumber());
                    memberCondition.setRange(scope);
                }
                needDimMemberData.get(dimNumber);
            }
            dimMemberConditionMap.put(dimNumber, memberConditions);
        }
        return SerializationUtils.toJsonString(dimMemberConditionMap);
    }
}

