/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.enums.dimensionEnums.ChangeTypeFormulaEnum;

public class ChangeTypeUpgradeService2Impl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(ChangeTypeUpgradeService2Impl.class);
    private static List<String> numbers = new ArrayList<String>(10);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"changetytpeUpgrade2");){
            try {
                this.deleteFormulaData();
                this.addFormulaForCommon();
                ArrayList<String> presetIds = new ArrayList<String>(10);
                ArrayList<String> delPresetIds = new ArrayList<String>(10);
                ArrayList<FormulaEntity> updateFormula = new ArrayList<FormulaEntity>(10);
                DataSet dataSet = this.getChangeTypeViews();
                if (!dataSet.isEmpty()) {
                    while (dataSet.hasNext()) {
                        this.getDimMemberIds(dataSet.next(), presetIds, delPresetIds, updateFormula);
                    }
                }
                this.updatePresetViewid(presetIds);
                this.deletePresetMember(delPresetIds);
                for (FormulaEntity formulaEntity : updateFormula) {
                    this.insertFormula(formulaEntity);
                }
                result.setSuccess(Boolean.TRUE.booleanValue());
            }
            catch (Exception e) {
                log.error((Throwable)e);
                result.setSuccess(Boolean.FALSE.booleanValue());
                StackTraceElement[] arr = e.getStackTrace();
                String message = e.getMessage();
                if (message == null) {
                    message = "error :";
                }
                StringBuilder sb = new StringBuilder(message);
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(sb.toString());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    private DataSet getChangeTypeViews() {
        String sql = "select fid ,fsource from t_eb_dimensionview where fdimensionid in (select fid from t_eb_dimension where fnumber = 'ChangeType' )";
        DataSet dataSet = DB.queryDataSet((String)"ChangeTypeUpgradeService2Impl.getChangeTypeViews", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        return dataSet;
    }

    private void getDimMemberIds(Row row, List<String> presetIds, List<String> delPresetIds, List<FormulaEntity> formulaEntities) {
        long viewid = row.getLong("fid");
        if (viewid == 0L) {
            return;
        }
        String source = row.getString("fsource");
        String sql = "select fid,fnumber from t_eb_structofchangetype where fviewid = " + viewid + " and fnumber in ('" + String.join((CharSequence)"','", numbers) + " ')";
        DataSet dataSet = DB.queryDataSet((String)"ChangeTypeUpgradeService2Impl.handleBaseViewData", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (!dataSet.isEmpty()) {
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                String number = next.getString("fnumber");
                String id = next.getString("fid");
                if ("1".equals(source)) {
                    presetIds.add(id);
                    List formula = ChangeTypeFormulaEnum.getFormulaData((String)number);
                    if (formula == null) continue;
                    formulaEntities.add(new FormulaEntity(Long.parseLong(id), viewid, (String)formula.get(0), (String)formula.get(1)));
                    continue;
                }
                delPresetIds.add(id);
            }
        }
    }

    private void updatePresetViewid(List<String> presetIds) {
        if (presetIds.size() == 0) {
            return;
        }
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)("update t_eb_structofchangetype set fviewid = 0 where fid in ( " + String.join((CharSequence)",", presetIds) + " )"));
    }

    private void deletePresetMember(List<String> presetIds) {
        if (presetIds.size() == 0) {
            return;
        }
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)("delete from t_eb_structofchangetype  where fid in ( " + String.join((CharSequence)",", presetIds) + " )"));
    }

    private void insertFormula(FormulaEntity entity) {
        String sql = "insert into t_eb_changetypeformula (fid,fentryid,fseq,fformulviewid,fformula,fformulaname) values ";
        StringBuilder sb = new StringBuilder(sql);
        sb.append("( ");
        sb.append(entity.getFid());
        sb.append(", ");
        sb.append(entity.getFentryid());
        sb.append(", ");
        sb.append("1");
        sb.append(", ");
        sb.append(entity.getFformulviewid());
        sb.append(", '");
        sb.append(entity.getFformula());
        sb.append("', '");
        sb.append(entity.getFformulaname());
        sb.append("')");
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sb.toString());
    }

    private void deleteFormulaData() {
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_changetypeformula")) {
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)"delete from t_eb_changetypeformula where 1 = 1");
        }
    }

    private void addFormulaForCommon() {
        List<Long> dimIds = this.getDimension();
        ArrayList<FormulaEntity> formulaEntities = new ArrayList<FormulaEntity>(10);
        String querySql = "select fid,fnumber from t_eb_structofchangetype where fviewid = 0 and fnumber in ('CurrentPeriod' , 'EndingBalance') and fdimensionid = ";
        for (long dimId : dimIds) {
            DataSet dataSet;
            long baseviewid = this.queryBaseViewId(dimId);
            if (baseviewid == 0L || (dataSet = this.queryChangeType(querySql, dimId)).isEmpty()) continue;
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                String number = next.getString("fnumber");
                String id = next.getString("fid");
                List formula = ChangeTypeFormulaEnum.getFormulaData((String)number);
                if (formula == null) continue;
                formulaEntities.add(new FormulaEntity(Long.parseLong(id), baseviewid, (String)formula.get(0), (String)formula.get(1)));
            }
        }
        for (FormulaEntity formulaEntity : formulaEntities) {
            this.insertFormula(formulaEntity);
        }
    }

    private DataSet queryChangeType(String sql, long dimId) {
        StringBuilder sb = new StringBuilder(sql);
        sb.append(dimId);
        return DB.queryDataSet((String)"ChangeTypeUpgradeService2Impl.addFormulaForCommon", (DBRoute)DBRoute.of((String)"epm"), (String)sb.toString());
    }

    private List<Long> getDimension() {
        String sql = "select fid from t_eb_dimension where fnumber = 'ChangeType'";
        ArrayList<Long> list = new ArrayList<Long>(10);
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getSimpleName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            list.add(row.getLong("fid"));
        }
        return list;
    }

    private Long queryBaseViewId(long dimid) {
        String sql = "select fid from t_eb_dimensionview where fdimensionid = " + dimid + " and fsource = '1' ";
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getSimpleName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet != null && dataSet.hasNext()) {
            return dataSet.next().getLong("fid");
        }
        return 0L;
    }

    static {
        numbers.addAll(Arrays.asList("CurrentPeriod", "EndingBalance", "BOP", "YTD"));
    }

    static class FormulaEntity {
        private long fid;
        private long fentryid;
        private int seq = 1;
        private long fformulviewid;
        private String fformula;
        private String fformulaname;

        public FormulaEntity(long fid, long fformulviewid, String fformula, String fformulaname) {
            this.fid = fid;
            this.fentryid = DBServiceHelper.genGlobalLongId();
            this.fformulviewid = fformulviewid;
            this.fformula = fformula;
            this.fformulaname = fformulaname;
        }

        public long getFid() {
            return this.fid;
        }

        public void setFid(long fid) {
            this.fid = fid;
        }

        public long getFentryid() {
            return this.fentryid;
        }

        public void setFentryid(long fentryid) {
            this.fentryid = fentryid;
        }

        public int getSeq() {
            return this.seq;
        }

        public void setSeq(int seq) {
            this.seq = seq;
        }

        public long getFformulviewid() {
            return this.fformulviewid;
        }

        public void setFformulviewid(long fformulviewid) {
            this.fformulviewid = fformulviewid;
        }

        public String getFformula() {
            return this.fformula;
        }

        public void setFformula(String fformula) {
            this.fformula = fformula;
        }

        public String getFformulaname() {
            return this.fformulaname;
        }

        public void setFformulaname(String fformulaname) {
            this.fformulaname = fformulaname;
        }
    }
}

