/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.dimension;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.enums.dimensionEnums.ChangeTypeFormulaEnum;

public class ChangeTypeUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"changetytpeUpgrade");){
            try {
                List<DimensionEntity> dimension = this.getDimension();
                for (DimensionEntity dim : dimension) {
                    long baseviewid = this.queryBaseViewId(dim.getModelid(), dim.getDimensionId());
                    if (baseviewid == 0L) continue;
                    this.updateMembers(baseviewid, dim.getModelid(), dim.dimensionId);
                }
                result.setSuccess(Boolean.TRUE.booleanValue());
            }
            catch (Exception e) {
                tx.markRollback();
            }
        }
        return result;
    }

    private List<DimensionEntity> getDimension() {
        String sql = "select fid , fmodelid from t_eb_dimension where fnumber = 'ChangeType'";
        ArrayList<DimensionEntity> list = new ArrayList<DimensionEntity>(16);
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getSimpleName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            list.add(new DimensionEntity(row.getLong("fmodelid"), row.getLong("fid")));
        }
        return list;
    }

    private Long queryBaseViewId(long modelid, long dimid) {
        String sql = "select fid from t_eb_dimensionview where fmodelid = " + modelid + " and fdimensionid = " + dimid + " and fsource = '1' ";
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getSimpleName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet != null && dataSet.hasNext()) {
            return dataSet.next().getLong("fid");
        }
        return 0L;
    }

    private void updateMembers(long baseviewid, long modelid, long dimid) {
        String sql = "update t_eb_structofchangetype set fviewid = " + baseviewid + " where  fmodelid = " + modelid + " and fdimensionid = " + dimid + " and fnumber != 'ChangeType' and fviewid = 0";
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql);
    }

    private void updateFormual() {
        List currentPeriod = ChangeTypeFormulaEnum.getFormulaData((String)"CurrentPeriod");
        String sql = "update t_eb_structofchangetype set fformula = '" + (String)currentPeriod.get(0) + "' , fformulaname = '" + (String)currentPeriod.get(1) + "' where fnumber = 'CurrentPeriod' ";
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql);
        List EndingBalance = ChangeTypeFormulaEnum.getFormulaData((String)"EndingBalance");
        String sql1 = "update t_eb_structofchangetype set fformula = '" + (String)EndingBalance.get(0) + "' , fformulaname = '" + (String)EndingBalance.get(1) + "' where fnumber = 'EndingBalance' ";
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql1);
    }

    static class DimensionEntity {
        private long modelid;
        private long dimensionId;

        public DimensionEntity(long modelid, long dimensionId) {
            this.modelid = modelid;
            this.dimensionId = dimensionId;
        }

        public long getModelid() {
            return this.modelid;
        }

        public void setModelid(long modelid) {
            this.modelid = modelid;
        }

        public long getDimensionId() {
            return this.dimensionId;
        }

        public void setDimensionId(long dimensionId) {
            this.dimensionId = dimensionId;
        }
    }
}

