/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.dimension;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.common.enums.PropRangeEnum;
import kd.epm.eb.common.enums.RangeEnum;

public class DimRelationRangeUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"dimRelationRangeUpdate");){
            try {
                DBRoute route = DBRoute.of((String)"epm");
                String sql_relation = "select fid from t_eb_dimensionrelation";
                String sql_relation_e = "select fseq, fdimproperty from t_eb_dimensionrelation_e where fid=?";
                try (DataSet relationSet = DB.queryDataSet((String)"getDimRelation", (DBRoute)route, (String)sql_relation);){
                    for (Row row : relationSet) {
                        long relationId = row.getLong("fid");
                        DataSet relationDetailSet = this.queryRelationDetail(route, sql_relation_e, relationId);
                        Throwable throwable = null;
                        try {
                            if (relationDetailSet == null || relationDetailSet.isEmpty()) continue;
                            ArrayList<Object> paramList = new ArrayList<Object>(16);
                            StringBuilder updateRelMemSql = new StringBuilder("update t_eb_dimmemberrelation set ");
                            boolean canExec = true;
                            HashSet<String> fieldSet = new HashSet<String>(6);
                            for (Row detailRow : relationDetailSet) {
                                Integer seq = detailRow.getInteger("fseq");
                                Long dimProp = detailRow.getLong("fdimproperty");
                                if (seq == null) {
                                    canExec = false;
                                    break;
                                }
                                String rangeField = "fdimension" + seq + "range";
                                if (!fieldSet.add(rangeField)) continue;
                                if (dimProp == null || dimProp == 0L) {
                                    paramList.add(String.valueOf(RangeEnum.ALL.getIndex()));
                                } else {
                                    paramList.add(String.valueOf(PropRangeEnum.PROP_ALL.getIndex()));
                                }
                                updateRelMemSql.append(rangeField);
                                updateRelMemSql.append("=?,");
                            }
                            if (!canExec) continue;
                            String sql = updateRelMemSql.substring(0, updateRelMemSql.length() - 1);
                            sql = sql + " where frelationid=?";
                            paramList.add(relationId);
                            this.executeUpdate(route, sql, paramList);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (relationDetailSet == null) continue;
                            if (throwable != null) {
                                try {
                                    relationDetailSet.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            relationDetailSet.close();
                        }
                    }
                }
                result.setSuccess(Boolean.TRUE.booleanValue());
            }
            catch (Exception e) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                StackTraceElement[] arr = e.getStackTrace();
                String message = e.getMessage();
                if (message == null) {
                    message = "error :";
                }
                StringBuilder sb = new StringBuilder(message);
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(sb.toString());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        return result;
    }

    private DataSet queryRelationDetail(DBRoute route, String sql_relation_e, long relationId) {
        return DB.queryDataSet((String)"getDimRelationDetail", (DBRoute)route, (String)sql_relation_e, (Object[])new Object[]{relationId});
    }

    private void executeUpdate(DBRoute route, String sql, List<Object> paramList) {
        DB.execute((DBRoute)route, (String)sql, (Object[])paramList.toArray(new Object[0]));
    }
}

