/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class EbEntityCurrencyUpgradeServiceImpl
implements IUpgradeService {
    private static final DBRoute db_bcm = DBRoute.of((String)"bcm");
    private static final DBRoute db_epm = DBRoute.of((String)"epm");
    private static final String currencySql = "select fid,fnumber from t_eb_structofcurrency where fmodelid = %s ";
    private static final String updateSql = "update t_eb_structofent set fcurrencyid = ? where fnumber = ? and fmodelid = %s ";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Set<String> modelids;
        Throwable throwable;
        TXHandle tx;
        Map<String, String> dbCurrency;
        UpgradeResult result;
        block19: {
            UpgradeResult upgradeResult;
            block20: {
                block21: {
                    result = new UpgradeResult();
                    if (!this.checkTableExist(result)) {
                        return result;
                    }
                    dbCurrency = this.queryBaseCurrency();
                    tx = TX.requiresNew((String)"EbEntityCurrencyUpgrade");
                    throwable = null;
                    modelids = this.queryModelIds();
                    if (modelids.size() != 0 && dbCurrency.size() != 0) break block19;
                    result.setSuccess(true);
                    result.setLog("not  find  bcmModel or dbCurrency \u3002");
                    upgradeResult = result;
                    if (tx == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                for (String modelid : modelids) {
                    this.doUpgrade(modelid, dbCurrency);
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                tx.markRollback();
                result.setLog("share member errorinfo :" + e.getMessage());
                result.setErrorInfo(Arrays.toString(e.getStackTrace()));
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }

    private Set<String> queryModelIds() {
        HashSet<String> modelIds = new HashSet<String>(16);
        String sql = "select fid from t_bcm_model where freporttype = '4'";
        DataSet dataSet = DB.queryDataSet((String)"queryEbModelIds", (DBRoute)db_bcm, (String)sql);
        if (dataSet != null && !dataSet.isEmpty() && dataSet.hasNext()) {
            for (Row row : dataSet) {
                modelIds.add(row.getString("fid"));
            }
        }
        return modelIds;
    }

    private Map<String, String> queryBaseCurrency() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String sql = "select fid,fnumber from T_BD_Currency ";
        DataSet dataSet = DB.queryDataSet((String)"queryBaseCurrency", (DBRoute)DBRoute.of((String)"sys"), (String)sql);
        if (dataSet != null && !dataSet.isEmpty() && dataSet.hasNext()) {
            for (Row row : dataSet) {
                map.put(row.getString("fid"), row.getString("fnumber"));
            }
        }
        return map;
    }

    private Map<String, String> queryModelCurrency(String modelId) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String sql = String.format(currencySql, modelId);
        DataSet dataSet = DB.queryDataSet((String)"queryModelCurrency", (DBRoute)db_epm, (String)sql);
        if (dataSet != null && !dataSet.isEmpty() && dataSet.hasNext()) {
            for (Row row : dataSet) {
                map.put(row.getString("fnumber"), row.getString("fid"));
            }
        }
        return map;
    }

    private Map<String, String> queryEntityMap(String modelId, Collection<String> collections) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        StringBuilder sb = new StringBuilder("select fnumber,fcurrencyid from t_eb_structofent where fmodelid = ");
        sb.append(modelId).append(" and ");
        sb.append("fcurrencyid in (");
        sb.append(String.join((CharSequence)",", collections));
        sb.append(')');
        DataSet dataSet = DB.queryDataSet((String)"queryEntityNumbers", (DBRoute)db_epm, (String)sb.toString());
        if (dataSet != null && !dataSet.isEmpty() && dataSet.hasNext()) {
            for (Row row : dataSet) {
                map.put(row.getString("fnumber"), row.getString("fcurrencyid"));
            }
        }
        return map;
    }

    private void updateEntityCurrency(List<Object[]> params, String modelid) {
        String sql = String.format(updateSql, modelid);
        DB.executeBatch((DBRoute)db_epm, (String)sql, params);
    }

    private boolean checkTableExist(UpgradeResult result) {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"sys"), (String)"T_BD_Currency")) {
            result.setSuccess(false);
            result.setLog("T_BD_Currency does't exist, please check table.");
            return false;
        }
        if (!DB.exitsTable((DBRoute)db_bcm, (String)"t_bcm_model")) {
            result.setSuccess(true);
            result.setLog("t_bcm_model does't exist, don't need upgrade.");
            return false;
        }
        return true;
    }

    private void doUpgrade(String modelid, Map<String, String> dbCurrency) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        Map<String, String> modelCurrencyMap = this.queryModelCurrency(modelid);
        Map<String, String> queryEntityNumbers = this.queryEntityMap(modelid, dbCurrency.keySet());
        for (Map.Entry<String, String> entry : queryEntityNumbers.entrySet()) {
            String ebCurrencyId;
            Object[] param = new Object[2];
            String dbCurrencyNum = dbCurrency.get(entry.getValue());
            if (dbCurrencyNum == null || (ebCurrencyId = modelCurrencyMap.get(dbCurrencyNum)) == null) continue;
            param[0] = ebCurrencyId;
            param[1] = entry.getKey();
            params.add(param);
        }
        if (params.size() > 0) {
            this.updateEntityCurrency(params, modelid);
        }
    }

    public void updateEntityDefaultCurrency(String modelid) {
        Map<String, String> dbCurrency = this.queryBaseCurrency();
        if (dbCurrency.size() == 0) {
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"EbEntityCurrencyUpgrade");){
            try {
                this.doUpgrade(modelid, dbCurrency);
            }
            catch (Exception e) {
                tx.markRollback();
            }
        }
    }
}

