/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.dimension;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class EntityCurrencyUpgradeServiceImpl
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle tx = TX.requiresNew((String)"entityCurrencyUpdate");){
            try {
                List<Long> modelids = this.queryModel();
                for (Long modelid : modelids) {
                    long cnyId;
                    if (modelid == 0L || (cnyId = this.queryCurrencyCNYId(modelid).longValue()) == 0L) continue;
                    this.updateEntityCurrency(modelid, cnyId);
                }
                result.setSuccess(Boolean.TRUE.booleanValue());
            }
            catch (Exception e) {
                result.setSuccess(Boolean.FALSE.booleanValue());
                result.setLog(e.getMessage());
                tx.markRollback();
            }
        }
        return result;
    }

    private List<Long> queryModel() {
        String sql = "select fid from t_eb_model where freporttype = '7'";
        ArrayList<Long> modelIds = new ArrayList<Long>(10);
        DataSet dataSet = DB.queryDataSet((String)"EntityCurrencyUpgradeServiceImpl.queryModel", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (!dataSet.isEmpty()) {
            while (dataSet.hasNext()) {
                modelIds.add(dataSet.next().getLong("fid"));
            }
        }
        return modelIds;
    }

    private Long queryCurrencyCNYId(long modelid) {
        String sql = "select fid from t_eb_structofcurrency where fnumber = 'CNY' and fmodelid = " + modelid;
        DataSet dataSet = DB.queryDataSet((String)"EntityCurrencyUpgradeServiceImpl.queryCurrencyCNY", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet.isEmpty() || !dataSet.hasNext()) {
            return 0L;
        }
        return dataSet.next().getLong("fid");
    }

    private void updateEntityCurrency(long modelid, long cnyId) {
        String sql = "update t_eb_structofent set fcurrencyid = " + cnyId + " where fmodelid = " + modelid + " and fnumber != 'Entity'";
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql);
    }
}

