/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.dimension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.ICMemberEnum;

public class ICViewUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(ICViewUpgradeServiceImpl.class);

    private void upgradeICView(Map<Long, Long> modelIds) {
        if (modelIds.size() == 0) {
            return;
        }
        ArrayList<String> models = new ArrayList<String>(16);
        ArrayList<String> dims = new ArrayList<String>(16);
        for (Map.Entry<Long, Long> entry : modelIds.entrySet()) {
            models.add(String.valueOf(entry.getKey()));
        }
        StringBuilder entitySql = new StringBuilder();
        entitySql.append("select fid from t_eb_dimension where fnumber='Entity' and fmodelid in (");
        entitySql.append(String.join((CharSequence)",", models));
        entitySql.append(')');
        try (DataSet ds = DB.queryDataSet((String)"queryEntity", (DBRoute)DBRoute.of((String)"epm"), (String)entitySql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                dims.add(row.getString("fid"));
            }
        }
        if (dims.size() == 0) {
            return;
        }
        String viewSql = "select " + this.dimensionViewField() + " from t_eb_dimensionview where fnumber !='E001' and fdimensionid in (" + String.join((CharSequence)",", dims) + ")";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryView", (DBRoute)DBRoute.of((String)"epm"), (String)viewSql, null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Object[] params = this.packageDimensionView(row, modelIds.get(row.getLong("fmodelid")), false);
                if (params == null) continue;
                paramList.add(params);
            }
        }
        try {
            String addViewSql = "insert into t_eb_dimensionview(" + this.dimensionViewField() + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            if (paramList != null && paramList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)addViewSql, paramList);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private boolean queryIsExist(String number) {
        StringBuilder sb = new StringBuilder();
        sb.append("select fid from t_eb_dimensionview where fnumber ='").append(number).append("'");
        try (DataSet ds = DB.queryDataSet((String)"queryExistView", (DBRoute)DBRoute.of((String)"epm"), (String)sb.toString(), null);){
            if (ds != null && ds.hasNext()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void upgradeICViewMember(Map<Long, Long> modelIds) {
        if (modelIds.size() == 0) {
            return;
        }
        Map<Long, Set<Long>> viewMap = this.getViewMap(modelIds);
        if (viewMap.size() == 0) {
            return;
        }
        List numberList = ICMemberEnum.getAllNumber();
        StringBuilder queryICMember = new StringBuilder();
        String icSql = "select fid,fnumber,fmodifierid,flevel,fdimensionid,fmodelid from T_EB_STRUCTOFICENTITY where fnumber in('" + String.join((CharSequence)"','", numberList) + "') and fmodelid in (";
        queryICMember.append(icSql);
        for (Long aLong : modelIds.keySet()) {
            queryICMember.append(aLong).append(",");
        }
        queryICMember.deleteCharAt(queryICMember.length() - 1).append(") order by flevel asc");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        LinkedHashMap<Long, String> levelMap = new LinkedHashMap<Long, String>();
        try (DataSet ds = DB.queryDataSet((String)"queryICMember", (DBRoute)DBRoute.of((String)"epm"), (String)queryICMember.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Set<Long> viewIds;
                Row row = ds.next();
                ICMemberEnum ice = ICMemberEnum.getEnumByNumber((String)row.getString("fnumber"));
                if (ice == null || (viewIds = viewMap.get(row.getLong("fdimensionid"))) == null || viewIds.size() == 0) continue;
                for (Long viewId : viewIds) {
                    String[] arr;
                    Long parentId;
                    if (1 == row.getInteger("flevel")) {
                        Long id = this.packageViewMember(row, ice, paramList, 0L, viewId, row.getLong("fmodelid"), row.getLong("fdimensionid"));
                        levelMap.put(id, "2," + row.getString("fdimensionid") + "," + viewId);
                        continue;
                    }
                    if (2 == row.getInteger("flevel")) {
                        parentId = -1L;
                        for (Map.Entry entry : levelMap.entrySet()) {
                            arr = ((String)entry.getValue()).split(",");
                            if (!arr[0].equals("2") || !arr[1].equals(row.getString("fdimensionid")) || !arr[2].equals(String.valueOf(viewId))) continue;
                            parentId = (Long)entry.getKey();
                            break;
                        }
                        if (parentId == -1L) continue;
                        Long id = this.packageViewMember(row, ice, paramList, parentId, viewId, row.getLong("fmodelid"), row.getLong("fdimensionid"));
                        levelMap.put(id, "3," + row.getString("fdimensionid") + "," + viewId);
                        continue;
                    }
                    parentId = -1L;
                    for (Map.Entry entry : levelMap.entrySet()) {
                        arr = ((String)entry.getValue()).split(",");
                        if (!arr[0].equals("3") || !arr[1].equals(row.getString("fdimensionid")) || !arr[2].equals(String.valueOf(viewId))) continue;
                        parentId = (Long)entry.getKey();
                        break;
                    }
                    if (parentId == -1L) continue;
                    this.packageViewMember(row, ice, paramList, parentId, viewId, row.getLong("fmodelid"), row.getLong("fdimensionid"));
                }
            }
        }
        try {
            String addViewMemberSql = "insert into t_eb_viewmember(" + this.viewMemberField() + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            if (paramList != null && paramList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)addViewMemberSql, paramList);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private Map<Long, Set<Long>> getViewMap(Map<Long, Long> modelIds) {
        HashMap<Long, Set<Long>> viewIds = new HashMap<Long, Set<Long>>(16);
        ArrayList<String> dims = new ArrayList<String>(16);
        for (Map.Entry<Long, Long> entry : modelIds.entrySet()) {
            dims.add(String.valueOf(entry.getValue()));
        }
        StringBuilder entitySql = new StringBuilder();
        entitySql.append("select fid,fdimensionid from t_eb_dimensionview where fnumber !='IC_E001' and fdimensionId in (").append(String.join((CharSequence)",", dims)).append(')');
        try (DataSet ds = DB.queryDataSet((String)"queryICView", (DBRoute)DBRoute.of((String)"epm"), (String)entitySql.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                if (viewIds.get(row.getLong("fdimensionid")) == null) {
                    HashSet<Long> set = new HashSet<Long>(16);
                    set.add(row.getLong("fid"));
                    viewIds.put(row.getLong("fdimensionid"), set);
                    continue;
                }
                ((Set)viewIds.get(row.getLong("fdimensionid"))).add(row.getLong("fid"));
            }
        }
        return viewIds;
    }

    private Long packageViewMember(Row row, ICMemberEnum icMemberEnum, List<Object[]> paramList, Long parentId, Long viewId, Long modelId, Long dimId) {
        ArrayList<Object> ob = new ArrayList<Object>(16);
        Long id = DB.genGlobalLongId();
        ob.add(id);
        ob.add(row.get("fid"));
        ob.add(icMemberEnum.getNumber());
        ob.add(icMemberEnum.getLongnumber());
        ob.add(icMemberEnum.getName());
        ob.add(parentId);
        ob.add(viewId);
        ob.add(dimId);
        ob.add(modelId);
        ob.add("0");
        ob.add(icMemberEnum.isLeaf());
        ob.add(icMemberEnum.getDseq());
        ob.add(icMemberEnum.getLevel());
        ob.add(icMemberEnum.getAggoprt());
        ob.add(row.get("fmodifierid"));
        ob.add(TimeServiceHelper.now());
        ob.add("1");
        ob.add("C");
        ob.add("0");
        ob.add("0");
        ob.add("0");
        ob.add("0");
        paramList.add(ob.toArray(new Object[0]));
        return id;
    }

    private String viewMemberField() {
        String field = "fid,fmemberid,fnumber,flongnumber,fname,fparentid,fviewid,fdimensionid,fmodelid,fmembersource,fisleaf,fdseq,flevel,faggoprt,fmodifier,fmodifydate,fenable,fstatus,fisoffsetentry,fisinnerorg,fisouterorg,fmergernode";
        return field;
    }

    private void upgradeBaseICView(Map<Long, Long> modelIds) {
        if (modelIds.size() == 0) {
            return;
        }
        StringBuilder queryExistEntiyView = new StringBuilder();
        String viewSql = "select " + this.dimensionViewField() + " from t_eb_dimensionview where fnumber='E001' and  fmodelid in (";
        queryExistEntiyView.append(viewSql);
        for (Long aLong : modelIds.keySet()) {
            queryExistEntiyView.append(aLong).append(",");
        }
        queryExistEntiyView.deleteCharAt(queryExistEntiyView.length() - 1).append(")");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryView", (DBRoute)DBRoute.of((String)"epm"), (String)queryExistEntiyView.toString(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Object[] params = this.packageDimensionView(row, modelIds.get(row.getLong("fmodelid")), true);
                if (params == null) continue;
                paramList.add(params);
            }
        }
        try {
            String addViewSql = "insert into t_eb_dimensionview(" + this.dimensionViewField() + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            if (paramList != null && paramList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)addViewSql, paramList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object[] packageDimensionView(Row row, Long dimId, boolean isBase) {
        ArrayList<Object> ob = new ArrayList<Object>(16);
        ob.add(DB.genGlobalLongId());
        String number = "IC_" + row.getString("fnumber");
        if (this.queryIsExist(number)) {
            return null;
        }
        ob.add(number);
        if (isBase) {
            ob.add(ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7\u57fa\u51c6\u89c6\u56fe", (String)"ICViewUpgradeServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
        } else {
            ob.add(row.get("fname"));
        }
        ob.add(row.get("fmodelid"));
        ob.add(dimId);
        ob.add(1);
        ob.add(1);
        ob.add("!" + number);
        ob.add("1");
        if (isBase) {
            ob.add("1");
        } else {
            ob.add("0");
        }
        ob.add(0L);
        ob.add("0");
        ob.add(0L);
        ob.add(row.get("fcreatorid"));
        ob.add(TimeServiceHelper.now());
        ob.add(row.get("fmodifierid"));
        ob.add(TimeServiceHelper.now());
        ob.add("");
        return ob.toArray(new Object[0]);
    }

    private String dimensionViewField() {
        String field = "fid,fnumber,fname,fmodelid,fdimensionid,flevel,fdseq,flongnumber,fisleaf,fsource,fparentid,fusage,fbaseviewid,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fdescription";
        return field;
    }

    private Map<Long, Long> queryModelAndDimIds() {
        HashMap<Long, Long> modelMaps = new HashMap<Long, Long>(16);
        ArrayList<String> modelIds = new ArrayList<String>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryModel", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid from t_eb_model where freporttype='7'", null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                modelIds.add(row.getString("fid"));
            }
        }
        if (modelIds.size() == 0) {
            return modelMaps;
        }
        String ids = String.join((CharSequence)",", modelIds);
        String sql = "select fid,fmodelid from t_eb_dimension where fnumber ='InternalCompany' and fmodelid in (" + ids + ")";
        try (DataSet ds = DB.queryDataSet((String)"queryICDim", (DBRoute)DBRoute.of((String)"epm"), (String)sql, null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                modelMaps.put(row.getLong("fmodelid"), row.getLong("fid"));
            }
        }
        return modelMaps;
    }

    private String checkTableExist() {
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_dimension")) {
            return "t_eb_dimension";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_model")) {
            return "t_eb_model";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_dimensionview")) {
            return "t_eb_dimensionview";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"t_eb_viewmember")) {
            return "t_eb_viewmember";
        }
        if (!DB.exitsTable((DBRoute)DBRoute.of((String)"epm"), (String)"T_EB_STRUCTOFICENTITY")) {
            return "T_EB_STRUCTOFICENTITY";
        }
        return "";
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Throwable throwable;
        TXHandle tx;
        UpgradeResult result;
        block18: {
            UpgradeResult upgradeResult;
            block19: {
                block20: {
                    result = new UpgradeResult();
                    tx = TX.requiresNew((String)"BgmdCTViewUpgrade");
                    throwable = null;
                    String msg = this.checkTableExist();
                    if (StringUtils.isEmpty((String)msg)) break block18;
                    result.setSuccess(false);
                    result.setLog("table " + msg + " does't exist, so don't need upgrade.");
                    upgradeResult = result;
                    if (tx == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                tx.close();
            }
            return upgradeResult;
        }
        try {
            try {
                Map<Long, Long> modelIds = this.queryModelAndDimIds();
                this.upgradeBaseICView(modelIds);
                this.upgradeICView(modelIds);
                this.upgradeICViewMember(modelIds);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                StackTraceElement[] arr = e.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement ele : arr) {
                    sb.append(ele.toString()).append("\r\n");
                }
                result.setLog(e.getMessage());
                result.setErrorInfo(sb.toString());
                tx.markRollback();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return result;
    }
}

