/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.examine;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.examinev2.check.ExamineCheckAction;
import kd.epm.eb.business.examinev2.domain.ExamineBo;
import kd.epm.eb.business.examinev2.service.ExamineServiceImpl;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.TriggerEventEnum;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.request.ReportCheckRange;
import kd.epm.eb.service.examine.ExamineMSService;

public class ExamineMSServiceImpl
implements ExamineMSService {
    private static final Log log = LogFactory.getLog(ExamineMSServiceImpl.class);

    public ExamineCheckReport check(Long modelId, String triggerEventEnum, int processTypeEnum, Long executorId, ReportCheckRange reportCheckRange, List<ExamineBo> examineBoList, int pageSize) {
        try {
            ExamineCheckAction examineCheckAction = new ExamineCheckAction();
            examineCheckAction.setModelId(modelId);
            examineCheckAction.setTargetEvent(TriggerEventEnum.getTriggerEventEnum((String)triggerEventEnum));
            examineCheckAction.setProcessTypeEnum(ProcessTypeEnum.getProcessTypeByIndex((int)processTypeEnum));
            examineCheckAction.setExecutorId(executorId);
            examineCheckAction.setDatasetId(reportCheckRange.getDatasetId());
            examineCheckAction.setCheckRangeList(reportCheckRange.getCheckRangeList());
            examineCheckAction.setTemplateId(reportCheckRange.getTemplateId());
            examineCheckAction.setReportProcessId(reportCheckRange.getReportProcessId());
            examineCheckAction.setExamineBoList(examineBoList);
            examineCheckAction.setCartesian(reportCheckRange.getCartesian());
            examineCheckAction.setPageSize(pageSize);
            examineCheckAction.setApproveBillId(reportCheckRange.getApproveBillId());
            examineCheckAction.setBizModelId(reportCheckRange.getBizModelId());
            examineCheckAction.setCurrPeriodId(reportCheckRange.getCurrPeriodId());
            examineCheckAction.setDimRelMap(reportCheckRange.getDimRelMap());
            examineCheckAction.setDimRelList(reportCheckRange.getDimRelList());
            Map templateInfoMap = ExamineServiceImpl.getInstance().getTemplateInfoMap(modelId);
            examineCheckAction.setTemplateIdToNumMap(templateInfoMap);
            return examineCheckAction.doExamineCheck();
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u52fe\u7a3d\u68c0\u67e5\u5fae\u670d\u52a1\u8c03\u7528\u5931\u8d25", (String)"ExamineMSServiceImpl_0", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
    }
}

