/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.execAnalyse;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.execanalyse.SchemeDimension;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.service.execAnalyse.ControlBizModel;

public class AnalyseSchemePreSetServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(AnalyseSchemePreSetServiceImpl.class);
    private static final List<String> fieldKeys = Arrays.asList("fid", "fname", "fnumber", "fmodelid", "fbizmodelid", "ftype", "fstatus", "fdesc", "fispreset", "fmemberjson", "fcreatedate", "fmodifydate");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            List<ControlBizModel> controlBizModels = this.getAllControlBizModels();
            List<Object[]> schemeInfos = this.getSchemeSaveInfos(controlBizModels);
            this.batchSaveSchemes(schemeInfos);
            result.setSuccess(true);
        }
        catch (Exception exception) {
            result.setSuccess(false);
            result.setErrorInfo(CommonServiceHelper.getStackTraceStr((Throwable)exception));
            log.error((Throwable)exception);
        }
        return result;
    }

    private List<ControlBizModel> getAllControlBizModels() {
        ArrayList<ControlBizModel> controlBizModels = new ArrayList<ControlBizModel>(16);
        ArrayList<ControlBizModel> controlBizModels_tmp = new ArrayList<ControlBizModel>(16);
        String controlSql = "select fid, fmodel, fbasedatafield from t_eb_bgmcontroldimension where fmodel in (select fid from t_eb_model where freporttype = '7')";
        DataSet dataSet = DB.queryDataSet((String)"queryControlBizModel", (DBRoute)DBRoute.of((String)"epm"), (String)controlSql);
        if (dataSet == null || dataSet.isEmpty() || !dataSet.hasNext()) {
            return controlBizModels;
        }
        Row row = null;
        HashSet<Long> bizModelIds = new HashSet<Long>(16);
        HashSet<Long> pkIds = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            row = dataSet.next();
            Long pkId = row.getLong("fid");
            pkIds.add(pkId);
            ControlBizModel bizModel = new ControlBizModel();
            bizModel.setPkId(pkId);
            bizModel.setModelId(row.getLong("fmodel"));
            Long bizModelId = row.getLong("fbasedatafield");
            bizModelIds.add(bizModelId);
            bizModel.setBizModelId(bizModelId);
            controlBizModels_tmp.add(bizModel);
        }
        Map<Long, List<Map<String, String>>> dataSetMap = this.getAllDataSetMap(bizModelIds);
        Map<Long, List<Long>> controlDimIdMap = this.getAllControlDimMap(pkIds);
        Map<Long, Map<String, List<Long>>> controlVersionMap = this.getAllControlVersionMap(bizModelIds);
        for (ControlBizModel controlBizModel : controlBizModels_tmp) {
            Map<String, List<Long>> controlVersions;
            Long bizModelId = controlBizModel.getBizModelId();
            List<Map<String, String>> datasetInfos = dataSetMap.get(bizModelId);
            if (datasetInfos == null || datasetInfos.size() == 0) continue;
            controlBizModel.setDataSetInfos(datasetInfos);
            List<Long> controlDimIds = controlDimIdMap.get(controlBizModel.getPkId());
            if (controlDimIds != null && controlDimIds.size() != 0) {
                controlBizModel.setControlDimIds(controlDimIds);
            }
            if ((controlVersions = controlVersionMap.get(bizModelId)) != null && controlVersions.size() != 0) {
                controlBizModel.setControlVersions(controlVersions);
            }
            controlBizModels.add(controlBizModel);
        }
        return controlBizModels;
    }

    private Map<Long, List<Map<String, String>>> getAllDataSetMap(Set<Long> bizModelIds) {
        HashMap<Long, List<Map<String, String>>> dataSetMap = new HashMap<Long, List<Map<String, String>>>(16);
        if (bizModelIds.size() == 0) {
            return dataSetMap;
        }
        String sql = "select fid, fname, fnumber, fbizmodelid from t_eb_dataset where fbizmodelid in " + bizModelIds.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
        DataSet dataSet = DB.queryDataSet((String)"queryDataSet", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet == null || dataSet.isEmpty() || !dataSet.hasNext()) {
            return dataSetMap;
        }
        Row row = null;
        while (dataSet.hasNext()) {
            row = dataSet.next();
            Long bizModelId = row.getLong("fbizmodelid");
            List dataSetInfos = dataSetMap.computeIfAbsent(bizModelId, k -> new ArrayList(16));
            HashMap<String, String> dataSetInfoMap = new HashMap<String, String>(16);
            Long dataSetId = row.getLong("fid");
            dataSetInfoMap.put("id", dataSetId.toString());
            String name = row.getString("fname");
            dataSetInfoMap.put("name", name);
            String number = row.getString("fnumber");
            dataSetInfoMap.put("number", number);
            dataSetInfos.add(dataSetInfoMap);
        }
        return dataSetMap;
    }

    private Map<Long, List<Long>> getAllControlDimMap(Set<Long> pkIds) {
        HashMap<Long, List<Long>> controlDims = new HashMap<Long, List<Long>>(16);
        if (pkIds.size() == 0) {
            return controlDims;
        }
        String sql = "select fid, fdimensionid from t_eb_controldimdetail where fid in " + pkIds.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
        DataSet dataSet = DB.queryDataSet((String)"queryControlDim", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet == null || dataSet.isEmpty() || !dataSet.hasNext()) {
            return controlDims;
        }
        Row row = null;
        while (dataSet.hasNext()) {
            Long dimensionId;
            row = dataSet.next();
            Long pkId = row.getLong("fid");
            List dimensionIds = controlDims.computeIfAbsent(pkId, k -> new ArrayList(16));
            if (dimensionIds.contains(dimensionId = row.getLong("fdimensionid"))) continue;
            dimensionIds.add(dimensionId);
        }
        return controlDims;
    }

    private Map<Long, Map<String, List<Long>>> getAllControlVersionMap(Set<Long> bizModelIds) {
        HashMap<Long, Map<String, List<Long>>> controlVersions = new HashMap<Long, Map<String, List<Long>>>(16);
        if (bizModelIds.size() == 0) {
            return controlVersions;
        }
        String sql = "select fversion, fbussmodelid, finvalidtime, fdatatype, faudittrail from t_eb_controlversion where fbussmodelid in " + bizModelIds.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
        DataSet dataSet = DB.queryDataSet((String)"queryControlVersion", (DBRoute)DBRoute.of((String)"epm"), (String)sql);
        if (dataSet == null || dataSet.isEmpty() || !dataSet.hasNext()) {
            return controlVersions;
        }
        Date now = TimeServiceHelper.now();
        Row row = null;
        while (dataSet.hasNext()) {
            Long auditTrailId;
            Long dataTypeId;
            row = dataSet.next();
            Date invalidTime = row.getDate("finvalidtime");
            if (invalidTime != null && invalidTime.before(now)) continue;
            Long bizModelId = row.getLong("fbussmodelid");
            Map memberMap = controlVersions.computeIfAbsent(bizModelId, k -> new HashMap(16));
            List versions = memberMap.computeIfAbsent(SysDimensionEnum.Version.getNumber(), k -> new ArrayList(16));
            List dataTypes = memberMap.computeIfAbsent(SysDimensionEnum.DataType.getNumber(), k -> new ArrayList(16));
            List auditTrails = memberMap.computeIfAbsent(SysDimensionEnum.AuditTrail.getNumber(), k -> new ArrayList(16));
            Long versionId = row.getLong("fversion");
            if (versionId != 0L && !versions.contains(versionId)) {
                versions.add(versionId);
            }
            if ((dataTypeId = row.getLong("fdatatype")) != 0L && !dataTypes.contains(dataTypeId)) {
                dataTypes.add(dataTypeId);
            }
            if ((auditTrailId = row.getLong("faudittrail")) == 0L || auditTrails.contains(auditTrailId)) continue;
            auditTrails.add(auditTrailId);
        }
        return controlVersions;
    }

    private List<Object[]> getSchemeSaveInfos(List<ControlBizModel> controlBizModels) {
        String checkNumberSql = "select fnumber, fmodelid from t_eb_execschemeentity where fnumber like '%_default'";
        DataSet dataSet = DB.queryDataSet((String)"queryControlVersion", (DBRoute)DBRoute.of((String)"epm"), (String)checkNumberSql);
        HashMap<Long, Set> defaultNumbers = new HashMap<Long, Set>(16);
        if (dataSet != null) {
            Row row = null;
            while (dataSet.hasNext()) {
                row = dataSet.next();
                Long modelId = row.getLong("fmodelid");
                Set numbers = defaultNumbers.computeIfAbsent(modelId, k -> new HashSet());
                numbers.add(row.getString("fnumber"));
            }
        }
        ArrayList<Object[]> saveInfos = new ArrayList<Object[]>(16);
        HashSet<Long> modelIds = new HashSet<Long>(16);
        ArrayList dataSetId_tmp = new ArrayList(16);
        HashMap<String, Set<Long>> controlVersionIds = new HashMap<String, Set<Long>>(16);
        for (ControlBizModel controlBizModel : controlBizModels) {
            modelIds.add(controlBizModel.getModelId());
            dataSetId_tmp.addAll(controlBizModel.getDataSetInfos().stream().map(e -> Long.parseLong((String)e.get("id"))).collect(Collectors.toList()));
            controlBizModel.getControlVersions().forEach((key, value) -> {
                Set memberIds = controlVersionIds.computeIfAbsent((String)key, k -> new HashSet(16));
                memberIds.addAll(value);
            });
        }
        HashSet<Long> dataSetIds = new HashSet<Long>(dataSetId_tmp);
        HashMap<Long, List<Dimension>> dimensionLists = new HashMap<Long, List<Dimension>>(16);
        HashMap<Long, Dimension> accounts = new HashMap<Long, Dimension>(16);
        HashMap<Long, Map<String, List<Member>>> members = new HashMap<Long, Map<String, List<Member>>>(16);
        HashMap<Long, Map<String, Member>> customMembers = new HashMap<Long, Map<String, Member>>(16);
        long[] pkIds = DB.genGlobalLongIds((int)dataSetIds.size());
        int index = 0;
        Timestamp timeStamp = new Timestamp(199, 11, 30, 23, 59, 59, 100);
        for (ControlBizModel controlBizModel : controlBizModels) {
            Long modelId = controlBizModel.getModelId();
            List<Long> controlDimIds = controlBizModel.getControlDimIds();
            Map<String, List<Long>> controlVersions = controlBizModel.getControlVersions();
            List<Map<String, String>> dataSetInfos = controlBizModel.getDataSetInfos();
            Set defaultDatasetNums = (Set)defaultNumbers.get(modelId);
            for (Map<String, String> dataSetInfo : dataSetInfos) {
                String number = dataSetInfo.get("number") + "_default";
                if (defaultDatasetNums != null && defaultDatasetNums.contains(number)) continue;
                String name = ResManager.loadResFormat((String)"%1\u9ed8\u8ba4\u65b9\u6848", (String)"", (String)"", (Object[])new Object[]{dataSetInfo.get("name")});
                String dataSetId = dataSetInfo.get("id");
                String desc = ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848", (String)"", (String)"", (Object[])new Object[0]);
                String memberJson = this.getMemberJson(Long.parseLong(dataSetId), controlDimIds, modelId, dimensionLists, modelIds, dataSetIds, accounts, members, controlVersionIds, controlVersions, customMembers);
                if (memberJson == null) continue;
                if (index >= pkIds.length) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u7ec4\u8d8a\u754c\uff1aSet:%1, List:%2", (String)"", (String)"", (Object[])new Object[]{pkIds.length, dataSetId_tmp.size()}));
                }
                saveInfos.add(new Object[]{pkIds[index++], name, number, modelId, Long.parseLong(dataSetId), "2", "1", desc, "1", memberJson, timeStamp, timeStamp});
            }
        }
        return saveInfos;
    }

    private String getMemberJson(Long dataSetId, List<Long> controlDimIds, Long modelId, Map<Long, List<Dimension>> dimensionLists, Set<Long> modelIds, Set<Long> dataSetIds, Map<Long, Dimension> accounts, Map<Long, Map<String, List<Member>>> members, Map<String, Set<Long>> controlVersionIds, Map<String, List<Long>> controlVersions, Map<Long, Map<String, Member>> customMembers) {
        List<Dimension> dimensionList = this.getDimensionList(dataSetId, controlDimIds, modelId, dimensionLists, modelIds, dataSetIds, accounts);
        if (dimensionList.size() == 0) {
            return null;
        }
        this.setDefaultMembers(dimensionList, members, controlVersionIds, controlVersions, modelId, modelIds, customMembers);
        SchemeDimension schemeDimension = this.getDefaultSchemeDimension(dimensionList);
        return SerializationUtils.serializeToBase64((Object)schemeDimension);
    }

    private List<Dimension> getDimensionList(Long dataSetId, List<Long> controlDimIds, Long modelId, Map<Long, List<Dimension>> dimensionLists, Set<Long> modelIds, Set<Long> dataSetIds, Map<Long, Dimension> accounts) {
        Dimension dimension;
        List dimensionList;
        if (dimensionLists.size() == 0) {
            this.getAllDimensionLists(dimensionLists, dataSetIds);
        }
        if ((dimensionList = dimensionLists.get(dataSetId)) == null) {
            dimensionList = DatasetServiceHelper.getInstance().listDimensionByDatasetId(dataSetId);
        }
        if (dimensionList.size() == 0) {
            return dimensionList;
        }
        if (accounts.size() == 0) {
            this.getAllAccounts(accounts, modelIds);
        }
        if ((dimension = accounts.get(modelId)) == null) {
            dimension = this.getAccount(modelId);
        }
        dimensionList.add(dimension);
        ArrayList tmp = new ArrayList(dimensionList);
        dimensionList.clear();
        for (Dimension dim : tmp) {
            Long pkId = dim.getId();
            if (!controlDimIds.contains(pkId)) continue;
            dimensionList.add(dim);
        }
        return dimensionList;
    }

    private void getAllDimensionLists(Map<Long, List<Dimension>> dimensionLists, Set<Long> dataSetIds) {
        String sql = "select a.fid as id,a.fnumber,a.fshortnumber,a.fmembermodel,a.fmodelid fmodelid,l.fname as name,a.fdseq as seq, b.fid as datasetid from t_eb_dimension a LEFT JOIN t_eb_dimension_l l ON a.fid = l.fid left join t_eb_datasetdim b ON a.fid = b.fdatasetdim where l.FLOCALEID = 'zh_CN' and b.fid in " + dataSetIds.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
        try (DataSet ds = DB.queryDataSet((String)"dataset", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds.hasNext()) {
                Row next = ds.next();
                Long datasetId = next.getLong("datasetid");
                List dimensionList = dimensionLists.computeIfAbsent(datasetId, k -> new ArrayList(16));
                Dimension dimension = new Dimension(next.getLong("id"));
                dimension.setModelId(next.getLong("fmodelid"));
                dimension.setName(next.getString("name"));
                dimension.setNumber(next.getString("fnumber"));
                dimension.setShortNumber(next.getString("fshortnumber"));
                dimension.setMemberModel(next.getString("fmembermodel"));
                dimension.setSeq(next.getInteger("seq").intValue());
                dimensionList.add(dimension);
            }
        }
    }

    private void getAllAccounts(Map<Long, Dimension> accounts, Set<Long> modelIds) {
        String sql = "select a.fid as id,a.fnumber,a.fshortnumber,a.fmembermodel,a.fmodelid fmodelid,l.fname as name,a.fdseq as seq from t_eb_dimension a LEFT JOIN t_eb_dimension_l l ON a.fid = l.fid where l.FLOCALEID = 'zh_CN' and a.fnumber = 'Account' and a.fmodelid in " + modelIds.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
        try (DataSet ds = DB.queryDataSet((String)"account", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds.hasNext()) {
                Row next = ds.next();
                Long modelId = next.getLong("fmodelid");
                Dimension dimension = new Dimension(next.getLong("id"));
                dimension.setModelId(modelId);
                dimension.setName(next.getString("name"));
                dimension.setNumber(next.getString("fnumber"));
                dimension.setShortNumber(next.getString("fshortnumber"));
                dimension.setMemberModel(next.getString("fmembermodel"));
                dimension.setSeq(next.getInteger("seq").intValue());
                accounts.put(modelId, dimension);
            }
        }
    }

    private Dimension getAccount(Long modelId) {
        Dimension dimension = new Dimension();
        String sql = "select a.fid as id,a.fnumber,a.fshortnumber,a.fmembermodel,a.fmodelid fmodelid,l.fname as name,a.fdseq as seq from t_eb_dimension a LEFT JOIN t_eb_dimension_l l ON a.fid = l.fid where l.FLOCALEID = 'zh_CN' and a.fnumber = 'Account' and a.fmodelid = " + modelId;
        try (DataSet ds = DB.queryDataSet((String)"account", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            if (ds.hasNext()) {
                Row next = ds.next();
                dimension.setId(next.getLong("id"));
                dimension.setModelId(next.getLong("fmodelid"));
                dimension.setName(next.getString("name"));
                dimension.setNumber(next.getString("fnumber"));
                dimension.setShortNumber(next.getString("fshortnumber"));
                dimension.setMemberModel(next.getString("fmembermodel"));
                dimension.setSeq(next.getInteger("seq").intValue());
            }
        }
        return dimension;
    }

    private void setDefaultMembers(List<Dimension> dimensionList, Map<Long, Map<String, List<Member>>> members, Map<String, Set<Long>> controlVersionIds, Map<String, List<Long>> controlVersions, Long modelId, Set<Long> modelIds, Map<Long, Map<String, Member>> customMembers) {
        Map<String, Member> customMemberMap;
        Map<String, List<Member>> memberMap;
        if (members.size() == 0) {
            this.getAllMembers(members, modelIds, controlVersionIds);
        }
        if ((memberMap = members.get(modelId)) == null) {
            memberMap = this.getMemberMap(modelId, controlVersions);
        }
        if (customMembers.size() == 0) {
            this.getAllCustomMembers(customMembers, modelIds);
        }
        if ((customMemberMap = customMembers.get(modelId)) == null) {
            customMemberMap = this.getCustomMemberMap(modelId);
        }
        for (Dimension dimension : dimensionList) {
            String number = dimension.getNumber();
            SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)number);
            if (dimensionEnum == null) {
                Member member = customMemberMap.get(number);
                member.setRange(RangeEnum.ALL_EXCLUDE.getIndex());
                dimension.setMembers(Collections.singletonList(member));
                continue;
            }
            switch (dimensionEnum) {
                case Entity: 
                case Account: 
                case BudgetPeriod: {
                    List<Member> memberList = memberMap.get(dimensionEnum.getNumber());
                    memberList.forEach(e -> e.setRange(RangeEnum.ALL_EXCLUDE.getIndex()));
                    dimension.setMembers(memberList);
                    break;
                }
                case DataType: 
                case Version: 
                case AuditTrail: {
                    this.setControlVersionMember(dimension, controlVersions, number, memberMap.get(number));
                    break;
                }
                case ChangeType: 
                case Currency: 
                case Metric: 
                case InternalCompany: {
                    dimension.setMembers(memberMap.get(dimensionEnum.getNumber()));
                    break;
                }
            }
        }
    }

    private void getAllMembers(Map<Long, Map<String, List<Member>>> members, Set<Long> modelIds, Map<String, Set<Long>> controlVersionIds) {
        block8: for (SysDimensionEnum sysDimension : SysDimensionEnum.values()) {
            switch (sysDimension) {
                case Entity: 
                case Account: 
                case BudgetPeriod: {
                    this.addMembers(modelIds, sysDimension.getNumber(), members, sysDimension);
                    continue block8;
                }
                case ChangeType: {
                    this.addMembers(modelIds, "CurrentPeriod", members, sysDimension);
                    continue block8;
                }
                case Currency: {
                    this.addMembers(modelIds, "CNY", members, sysDimension);
                    continue block8;
                }
                case Metric: {
                    this.addMembers(modelIds, "Money", members, sysDimension);
                    continue block8;
                }
                case InternalCompany: {
                    this.addMembers(modelIds, "ICNone", members, sysDimension);
                    continue block8;
                }
                case DataType: 
                case Version: 
                case AuditTrail: {
                    this.addControlVersionMembers(modelIds, controlVersionIds.get(sysDimension.getNumber()), sysDimension, members);
                    continue block8;
                }
            }
        }
    }

    private void addMembers(Set<Long> modelIds, String memberNumber, Map<Long, Map<String, List<Member>>> members, SysDimensionEnum sysDimension) {
        String number = sysDimension.getNumber();
        String memberTreeTable = sysDimension.getMemberTreetable();
        String multiTable = memberTreeTable + "_l";
        String sql = "select a.fid as id, l.fname as name, a.fnumber as number, a.flongnumber as longnumber, a.fisleaf as isleaf, a.fmodelid as modelid from %s a LEFT JOIN %s l ON a.fid = l.fid where l.FLOCALEID = 'zh_CN' and a.fnumber = '%s' and a.fmodelid in %s";
        String modelFilter = modelIds.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
        try (DataSet ds = DB.queryDataSet((String)"addMember", (DBRoute)DBRoute.of((String)"epm"), (String)String.format(sql, memberTreeTable, multiTable, memberNumber, modelFilter));){
            while (ds.hasNext()) {
                Row next = ds.next();
                Long modelId = next.getLong("modelid");
                Map memberMap = members.computeIfAbsent(modelId, k -> new HashMap(16));
                List memberList = memberMap.computeIfAbsent(number, k -> new ArrayList(16));
                HashMap<String, Object> memberInfo = new HashMap<String, Object>(16);
                memberInfo.put("id", next.getLong("id"));
                memberInfo.put("name", next.getString("name"));
                String dimNumber = next.getString("number");
                memberInfo.put("number", dimNumber);
                memberInfo.put("longnumber", next.getString("longnumber"));
                memberInfo.put("isleaf", next.getBoolean("isleaf"));
                Member member = Member.loadFromDynamicObject(memberInfo);
                memberList.add(member);
            }
        }
    }

    private void addControlVersionMembers(Set<Long> modelIds, Set<Long> controlMemberIds, SysDimensionEnum sysDimension, Map<Long, Map<String, List<Member>>> members) {
        String number = sysDimension.getNumber();
        String memberTreeTable = sysDimension.getMemberTreetable();
        String multiTable = memberTreeTable + "_l";
        String sql = "select a.fid as id, l.fname as name, a.fnumber as number, a.flongnumber as longnumber, a.fisleaf as isleaf, a.fmodelid as modelid from %s a LEFT JOIN %s l ON a.fid = l.fid where l.FLOCALEID = 'zh_CN' and (%s) and a.fmodelid in %s";
        String filter = "a.fnumber = '" + number + "'";
        if (controlMemberIds != null && controlMemberIds.size() != 0) {
            filter = "a.fid in " + controlMemberIds.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")")) + " or " + filter;
        }
        String modelFilter = modelIds.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
        try (DataSet ds = DB.queryDataSet((String)"controlVersion", (DBRoute)DBRoute.of((String)"epm"), (String)String.format(sql, memberTreeTable, multiTable, filter, modelFilter));){
            while (ds.hasNext()) {
                Row next = ds.next();
                Long modelId = next.getLong("modelid");
                Map memberMap = members.computeIfAbsent(modelId, k -> new HashMap(16));
                List membersList = memberMap.computeIfAbsent(number, k -> new ArrayList(16));
                HashMap<String, Object> memberInfo = new HashMap<String, Object>(16);
                memberInfo.put("id", next.getLong("id"));
                memberInfo.put("name", next.getString("name"));
                String dimNumber = next.getString("number");
                memberInfo.put("number", dimNumber);
                memberInfo.put("longnumber", next.getString("longnumber"));
                memberInfo.put("isleaf", next.getBoolean("isleaf"));
                Member member = Member.loadFromDynamicObject(memberInfo);
                membersList.add(member);
            }
        }
    }

    private Map<String, List<Member>> getMemberMap(Long modelId, Map<String, List<Long>> controlVersions) {
        HashMap<String, List<Member>> memberMap = new HashMap<String, List<Member>>(16);
        block8: for (SysDimensionEnum sysDimension : SysDimensionEnum.values()) {
            switch (sysDimension) {
                case Entity: 
                case Account: 
                case BudgetPeriod: {
                    this.addMember(modelId, sysDimension.getNumber(), memberMap, sysDimension);
                    continue block8;
                }
                case ChangeType: {
                    this.addMember(modelId, "CurrentPeriod", memberMap, sysDimension);
                    continue block8;
                }
                case Currency: {
                    this.addMember(modelId, "CNY", memberMap, sysDimension);
                    continue block8;
                }
                case Metric: {
                    this.addMember(modelId, "Money", memberMap, sysDimension);
                    continue block8;
                }
                case InternalCompany: {
                    this.addMember(modelId, "ICNone", memberMap, sysDimension);
                    continue block8;
                }
                case DataType: 
                case Version: 
                case AuditTrail: {
                    this.addControlVersionMember(modelId, controlVersions.get(sysDimension.getNumber()), sysDimension, memberMap);
                    continue block8;
                }
            }
        }
        return memberMap;
    }

    private void addMember(Long modelId, String memberNumber, Map<String, List<Member>> memberMap, SysDimensionEnum sysDimension) {
        String number = sysDimension.getNumber();
        List members = memberMap.computeIfAbsent(number, k -> new ArrayList(16));
        String memberTreeTable = sysDimension.getMemberTreetable();
        String multiTable = memberTreeTable + "_l";
        String sql = "select a.fid as id, l.fname as name, a.fnumber as number, a.flongnumber as longnumber, a.fisleaf as isleaf from %s a LEFT JOIN %s l ON a.fid = l.fid where l.FLOCALEID = 'zh_CN' and a.fnumber = '%s' and a.fmodelid = %s";
        try (DataSet ds = DB.queryDataSet((String)"addMember", (DBRoute)DBRoute.of((String)"epm"), (String)String.format(sql, memberTreeTable, multiTable, memberNumber, modelId));){
            while (ds.hasNext()) {
                Row next = ds.next();
                HashMap<String, Object> memberInfo = new HashMap<String, Object>(16);
                memberInfo.put("id", next.getLong("id"));
                memberInfo.put("name", next.getString("name"));
                String dimNumber = next.getString("number");
                memberInfo.put("number", dimNumber);
                memberInfo.put("longnumber", next.getString("longnumber"));
                memberInfo.put("isleaf", next.getBoolean("isleaf"));
                Member member = Member.loadFromDynamicObject(memberInfo);
                members.add(member);
            }
        }
    }

    private void addControlVersionMember(Long modelId, List<Long> controlMemberIds, SysDimensionEnum sysDimension, Map<String, List<Member>> memberMap) {
        String number = sysDimension.getNumber();
        List members = memberMap.computeIfAbsent(number, k -> new ArrayList(16));
        String memberTreeTable = sysDimension.getMemberTreetable();
        String multiTable = memberTreeTable + "_l";
        String sql = "select a.fid as id, l.fname as name, a.fnumber as number, a.flongnumber as longnumber, a.fisleaf as isleaf from %s a LEFT JOIN %s l ON a.fid = l.fid where l.FLOCALEID = 'zh_CN' and (%s) and a.fmodelid = %s";
        String filter = "a.fnumber = '" + number + "'";
        if (controlMemberIds != null && controlMemberIds.size() != 0) {
            filter = "a.fid in " + controlMemberIds.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")")) + " or " + filter;
        }
        try (DataSet ds = DB.queryDataSet((String)"controlVersion", (DBRoute)DBRoute.of((String)"epm"), (String)String.format(sql, memberTreeTable, multiTable, filter, modelId));){
            while (ds.hasNext()) {
                Row next = ds.next();
                HashMap<String, Object> memberInfo = new HashMap<String, Object>(16);
                memberInfo.put("id", next.getLong("id"));
                memberInfo.put("name", next.getString("name"));
                String dimNumber = next.getString("number");
                memberInfo.put("number", dimNumber);
                memberInfo.put("longnumber", next.getString("longnumber"));
                memberInfo.put("isleaf", next.getBoolean("isleaf"));
                Member member = Member.loadFromDynamicObject(memberInfo);
                members.add(member);
            }
        }
    }

    private void getAllCustomMembers(Map<Long, Map<String, Member>> customMembers, Set<Long> modelIds) {
        String sql = "select a.fid as id, l.fname as name, a.fnumber as number, a.flongnumber as longnumber, a.fisleaf as isleaf, a.fmodelid as modelid from t_eb_structofdefined a LEFT JOIN t_eb_structofdefined_l l ON a.fid = l.fid where l.FLOCALEID = 'zh_CN' and a.fnumber in (select fnumber from t_eb_dimension where fissysdimension = '0') and a.fmodelid in " + modelIds.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
        try (DataSet ds = DB.queryDataSet((String)"customMembers", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds.hasNext()) {
                Row next = ds.next();
                Long modelId = next.getLong("modelid");
                Map customMap = customMembers.computeIfAbsent(modelId, k -> new HashMap(16));
                HashMap<String, Object> memberInfo = new HashMap<String, Object>(16);
                memberInfo.put("id", next.getLong("id"));
                memberInfo.put("name", next.getString("name"));
                String number = next.getString("number");
                memberInfo.put("number", number);
                memberInfo.put("longnumber", next.getString("longnumber"));
                memberInfo.put("isleaf", next.getBoolean("isleaf"));
                Member member = Member.loadFromDynamicObject(memberInfo);
                customMap.put(number, member);
            }
        }
    }

    private Map<String, Member> getCustomMemberMap(Long modelId) {
        HashMap<String, Member> customMap = new HashMap<String, Member>(16);
        String sql = "select a.fid as id, l.fname as name, a.fnumber as number, a.flongnumber as longnumber, a.fisleaf as isleaf from t_eb_structofdefined a LEFT JOIN t_eb_structofdefined_l l ON a.fid = l.fid where l.FLOCALEID = 'zh_CN' and a.fnumber in (select fnumber from t_eb_dimension where fissysdimension = '0') and a.fmodelid = " + modelId;
        try (DataSet ds = DB.queryDataSet((String)"customMember", (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
            while (ds.hasNext()) {
                Row next = ds.next();
                HashMap<String, Object> memberInfo = new HashMap<String, Object>(16);
                memberInfo.put("id", next.getLong("id"));
                memberInfo.put("name", next.getString("name"));
                String number = next.getString("number");
                memberInfo.put("number", number);
                memberInfo.put("longnumber", next.getString("longnumber"));
                memberInfo.put("isleaf", next.getBoolean("isleaf"));
                Member member = Member.loadFromDynamicObject(memberInfo);
                customMap.put(number, member);
            }
        }
        return customMap;
    }

    private void setControlVersionMember(Dimension dimension, Map<String, List<Long>> controlVersions, String number, List<Member> members) {
        List<Long> memberIds = controlVersions.get(number);
        if (memberIds == null || memberIds.size() == 0) {
            ArrayList memberList = new ArrayList(16);
            members.stream().filter(e -> e.getNumber().equals(number)).forEach(e -> {
                e.setRange(RangeEnum.ALL_EXCLUDE.getIndex());
                memberList.add(e);
            });
            dimension.setMembers(memberList);
            return;
        }
        ArrayList memberList_new = new ArrayList(16);
        members.forEach(e -> {
            if (memberIds.contains(e.getId())) {
                memberList_new.add(e);
            }
        });
        dimension.setMembers(memberList_new);
    }

    private SchemeDimension getDefaultSchemeDimension(List<Dimension> dimensionList) {
        SchemeDimension schemeDimension = new SchemeDimension();
        dimensionList.forEach(e -> {
            if (SysDimensionEnum.Account.getNumber().equals(e.getNumber())) {
                schemeDimension.getRowDimensions().add(e);
            } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(e.getNumber())) {
                schemeDimension.getColDimensions().add(e);
            } else {
                schemeDimension.getPageDimensions().add(e);
            }
        });
        return schemeDimension;
    }

    private void batchSaveSchemes(List<Object[]> schemeInfos) {
        if (schemeInfos.size() == 0) {
            return;
        }
        String sql = this.getSql();
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, schemeInfos);
    }

    private String getSql() {
        return "insert into t_eb_execschemeentity(" + String.join((CharSequence)",", fieldKeys) + ") values" + fieldKeys.stream().map(e -> "?").collect(Collectors.joining(",", "(", ")"));
    }
}

