/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.formula;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.formula.AcctFormulaExecutor;
import kd.epm.eb.common.formula.FormulaParam;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.service.formula.BgFormula4BcmService;

public class BgFormula4BcmServiceImpl
implements BgFormula4BcmService {
    private static final Log log = LogFactory.getLog(BgFormula4BcmServiceImpl.class);

    public String getFormulaDef() throws IOException {
        String formula_def = this.readFile("bcmrpt_formulas_list.json", true);
        String formula_catalog = this.readFile("bcmrpt_formulas_catalog_list.json", false);
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)formula_def) && StringUtils.isNotEmpty((String)formula_catalog)) {
            configMap.put("formula_catalog_list", formula_catalog);
            configMap.put("formula_def_list", formula_def);
        }
        return JSONUtils.toString(configMap);
    }

    private String readFile(String fileName, boolean isList) throws IOException {
        String result;
        try (InputStream fileStream = null;){
            fileStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            ObjectMapper om = new ObjectMapper();
            Object values = isList ? om.readValue(fileStream, List.class) : om.readValue(fileStream, Map.class);
            this.switchLanguage(values);
            result = SerializationUtils.toJsonString((Object)values);
        }
        return result;
    }

    private String switchLanguage(Object values) {
        String valStr;
        if (values instanceof List) {
            List list = (List)values;
            for (int index = 0; index < list.size(); ++index) {
                this.switchLanguage(list.get(index));
            }
        } else if (values instanceof Map) {
            Map map = (Map)values;
            for (Map.Entry entry : map.entrySet()) {
                String val = this.switchLanguage(entry.getValue());
                if (!StringUtils.isNotEmpty((String)val)) continue;
                entry.setValue(val);
            }
        } else if (values instanceof String && (valStr = (String)values).startsWith("FormulaFile_")) {
            int signIndex = valStr.indexOf("=");
            String string = valStr.substring(0, signIndex);
            String name = valStr.substring(signIndex + 1);
            return ResManager.loadKDString((String)name, (String)string, (String)"epm-eb-mservice", (Object[])new Object[0]);
        }
        return null;
    }

    public String executeFormula(String formulaName, String paramJson) {
        if (StringUtils.isEmpty((String)paramJson)) {
            return ResManager.loadKDString((String)"\u516c\u5f0f\u53c2\u6570\u4e3a\u7a7a", (String)"BgFormula4BcmServiceImpl_1", (String)"epm-eb-mservice", (Object[])new Object[0]);
        }
        try {
            long time1 = System.currentTimeMillis();
            Map acctMap = (Map)JSONUtils.cast((String)paramJson, Map.class);
            long time2 = System.currentTimeMillis();
            log.info("execAcctFormula-paramStr2Json:" + (time2 - time1));
            Map formulaParams = (Map)acctMap.get("param");
            Map commonParam = (Map)acctMap.get("commParam");
            if (commonParam == null) {
                return ResManager.loadKDString((String)"\u516c\u5f0f\u516c\u5171\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"BgFormula4BcmServiceImpl_2", (String)"epm-eb-mservice", (Object[])new Object[0]);
            }
            int yearNum = (Integer)commonParam.get("fy");
            String entityNum = (String)commonParam.get("org");
            int periodNum = (Integer)commonParam.get("period");
            FormulaParam param = new FormulaParam(entityNum, periodNum, yearNum, formulaName);
            Map formulaResult = AcctFormulaExecutor.executeBatch((Map)formulaParams, (FormulaParam)param);
            long time3 = System.currentTimeMillis();
            String result = SerializationUtils.toJsonString((Object)formulaResult);
            long time4 = System.currentTimeMillis();
            log.info("execAcctFormula-result2Str:" + (time4 - time3));
            if (LogSignHelper.needLog((String)"BgFormula4BcmServiceImpl", (String)"execAcctFormula")) {
                CommonServiceHelper.handleLog((Log)log, (String)"execAcctFormula-paramStr", (String)paramJson);
                CommonServiceHelper.handleLog((Log)log, (String)"execAcctFormula-resultStr", (String)result);
            }
            return result;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return ResManager.loadKDString((String)"\u53d6\u6570\u53c2\u6570\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u3002", (String)"BgFormula4BcmServiceImpl_3", (String)"epm-eb-mservice", (Object[])new Object[0]);
        }
    }
}

