/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.integration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.epm.eb.business.dataintegration.entity.syssetting.EbSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;

public class DataIntegrationUpService
implements IUpgradeService {
    private static final String updateKey = "DataIntegrationUpService";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        if (!UpdateRecordHelper.isUpdated((String)updateKey)) {
            try (TXHandle tx = TX.requiresNew((String)updateKey);){
                try {
                    this.updateMemberMap();
                    this.updateExecuteCondition();
                    UpdateRecordHelper.addRecord((String)updateKey, null, null, (boolean)true);
                }
                catch (Exception e) {
                    tx.markRollback();
                    result.setSuccess(false);
                    result.setLog(e.getMessage());
                    result.setErrorInfo(CommonServiceHelper.getStackTraceStr((Throwable)e));
                }
            }
        }
        return result;
    }

    private void updateMemberMap() {
        String sourceInsertSql;
        String querySql = "select fdimtarget,fdimview,fdataset,fid,ftype from t_eb_integration_map";
        LinkedList<Object[]> updateValForSource = new LinkedList<Object[]>();
        LinkedList<Object[]> updateValForTarget = new LinkedList<Object[]>();
        try (DataSet dataSet = DB.queryDataSet((String)"updateMemberMap", (DBRoute)BgFormConstant.DBROUTE, (String)querySql);){
            EbSysSetting setting = new EbSysSetting();
            for (Row row : dataSet) {
                Object[] rowVal = new Object[3];
                setting.setDataset(row.getLong("fdataset"));
                setting.setView(row.getLong("fdimview"));
                setting.setDim(row.getLong("fdimtarget"));
                if (setting.getView() == 0L) {
                    setting.setView(null);
                }
                if (setting.getDataset() == 0L) {
                    setting.setDataset(null);
                }
                if (setting.getDim() == 0L) continue;
                rowVal[0] = EASDataIntegrationUtil.serSysSetting((SysSettingInfo)setting, (String[])new String[0]);
                rowVal[1] = IntegrationSchemeType.CUSTOM.getVal();
                rowVal[2] = row.getLong("fid");
                if (DataIntegrationType.INPUT.getVal().equals(row.getString("ftype"))) {
                    updateValForTarget.add(rowVal);
                    continue;
                }
                updateValForSource.add(rowVal);
            }
        }
        if (updateValForSource.size() > 0) {
            sourceInsertSql = "update t_eb_integration_map set fsourcesysinfo = ? ,fschemetype = ? where fid = ?";
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sourceInsertSql, updateValForSource);
        }
        if (updateValForTarget.size() > 0) {
            sourceInsertSql = "update t_eb_integration_map set ftargetsysinfo = ? ,fschemetype = ? where fid = ?";
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)sourceInsertSql, updateValForTarget);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateExecuteCondition() {
        LinkedList<Long[]> conditionRowsVal = new LinkedList<Long[]>();
        String querySql = "select fid,fdatasetid,fintegrationid from t_eb_integration_query";
        HashSet<Long> datasetIds = new HashSet<Long>(16);
        LinkedList<Long[]> integrationRowsVal = new LinkedList<Long[]>();
        try (DataSet dataSet = DB.queryDataSet((String)"updateExecuteCondition", (DBRoute)BgFormConstant.DBROUTE, (String)querySql);){
            for (Object row : dataSet) {
                Long datasetId = row.getLong("fdatasetid");
                Long integrationSchemeId = row.getLong("fintegrationid");
                if (datasetId == 0L || integrationSchemeId == 0L) continue;
                Long rowId = row.getLong("fid");
                conditionRowsVal.add(new Long[]{datasetId, rowId});
                integrationRowsVal.add(new Long[]{rowId, integrationSchemeId, null});
                datasetIds.add(datasetId);
            }
        }
        if (conditionRowsVal.size() == 0) {
            return;
        }
        HashMap<Long, Long> datasetBizModelMap = new HashMap<Long, Long>(16);
        if (datasetIds.size() > 0) {
            querySql = "select fid,fbizmodelid from t_eb_dataset where fid in (" + SqlBatchUtils.getBatchParamsSql((int)datasetIds.size()) + ")";
            Throwable throwable = null;
            try (DataSet dataSet = DB.queryDataSet((String)"updateExecuteCondition_datasetBizModelMap", (DBRoute)BgFormConstant.DBROUTE, (String)querySql, (Object[])datasetIds.toArray());){
                for (Row row : dataSet) {
                    datasetBizModelMap.put(row.getLong("fid"), row.getLong("fbizmodelid"));
                }
            }
            catch (Throwable row) {
                Throwable throwable2 = row;
                throw row;
            }
        }
        for (Object[] objectArray : conditionRowsVal) {
            objectArray[0] = datasetBizModelMap.get((Long)objectArray[0]);
        }
        long[] ids = GlobalIdUtil.genGlobalLongIds((int)integrationRowsVal.size());
        boolean bl = false;
        for (Object[] objectArray : integrationRowsVal) {
            void var10_17;
            objectArray[2] = ids[++var10_17];
        }
        String updateSql = "update t_eb_integration_query set fbizmodelid = ? where fid = ?";
        DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)updateSql, conditionRowsVal);
        String string = "insert into t_eb_integrationquery_ins (fid,fbasedataid,fpkid) values(?,?,?)";
        DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)string, integrationRowsVal);
    }
}

