/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.member;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.openapi.entity.EBApiResult;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.service.member.MemberPermService;

public class MemberPermServiceImpl
implements MemberPermService {
    public ApiResult queryMemberPerm(Map<String, Object> params) {
        String modelNumber = (String)params.get("modelNumber");
        if (StringUtils.isEmpty((String)modelNumber)) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4f53\u7cfb\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"MemberPermServiceImpl_1", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        String businessModelNumber = (String)params.get("businessModelNumber");
        if (StringUtils.isEmpty((String)businessModelNumber)) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4e1a\u52a1\u6a21\u578b\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"MemberPermServiceImpl_2", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        String dimNumber = (String)params.get("dimNumber");
        if (StringUtils.isEmpty((String)dimNumber)) {
            return EBApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ef4\u5ea6\u7f16\u7801\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"MemberPermServiceImpl_3", (String)"epm-eb-mservice", (Object[])new Object[0]));
        }
        String permType = (String)params.get("permType");
        try {
            BizModel model = CommonUtils.getModel((String)modelNumber);
            Long modelId = model.getId();
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and(new QFilter("number", "=", (Object)businessModelNumber));
            DynamicObject businessModel = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (QFilter[])qFilter.toArray());
            if (businessModel == null) {
                return EBApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u4e1a\u52a1\u6a21\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MemberPermServiceImpl_4", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            DimMembPermType dimPermType = DimMembPermType.READ;
            if ("2".equals(permType)) {
                dimPermType = DimMembPermType.WRITE;
            }
            IModelCacheHelper modelCache = model.getModelCache();
            Long busModelId = businessModel.getLong("id");
            Long defaultViewId = modelCache.getViewByBusModelAndDimNumber(busModelId, dimNumber);
            Set permMembIds = DimMembPermHelper.getPermMembIds((String)dimNumber, (Long)modelId, (Long)busModelId, (Long)defaultViewId, (DimMembPermType)dimPermType, (boolean)true);
            Dimension dimension = modelCache.getDimension(dimNumber);
            if (dimension == null) {
                return EBApiResult.fail((String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MemberPermServiceImpl_5", (String)"epm-eb-mservice", (Object[])new Object[0]));
            }
            ArrayList memberList = null;
            if (permMembIds != null) {
                memberList = new ArrayList(permMembIds.size());
                for (Long permMembId : permMembIds) {
                    Member member = modelCache.getMember(dimNumber, defaultViewId, permMembId);
                    HashMap<String, String> memberSimple = new HashMap<String, String>(16);
                    memberSimple.put("number", member.getNumber());
                    memberSimple.put("name", member.getName());
                    memberSimple.put("parentNumber", member.getParentNumber());
                    memberList.add(memberSimple);
                }
            }
            ApiResult apiResult = new ApiResult();
            apiResult.setSuccess(true);
            apiResult.setData(memberList);
            return apiResult;
        }
        catch (KDBizException e) {
            return EBApiResult.fail((String)e.getMessage());
        }
    }
}

