/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.service.memberQuote;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.MemberQuote;
import kd.epm.eb.business.quote.QuoteBuilder;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.business.quote.QuoteSave;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.service.memberQuote.MemberQuoteService;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MemberQuoteServiceImpl
implements MemberQuoteService {
    public void save(List<MemberQuoteDao> memberQuotes) {
        QuoteSave.get().save(memberQuotes);
    }

    public boolean delete(int resource, Collection<Long> sourceIds) {
        return MemberQuote.get().delete(resource, sourceIds);
    }

    public Set<Long> queryQuote(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Set<Long> memberIds, int resource) {
        return MemberQuote.get().queryQuote(modelId, dimensionId, memberIds, resource);
    }

    public Set<Long> queryDataQuote(@NotNull Long modelId, @NotNull Long dimensionId, Long viewId, @NotNull Set<Long> memberIds) {
        return MemberQuote.get().queryDataQuote(modelId, dimensionId, viewId, memberIds);
    }

    public Set<Long> filterQuote(@NotNull Long modelId, @NotNull Long busModelId, @NotNull Set<Long> resourceIds, Map<Long, Long> variableMap, @NotNull List<Map<Long, Long>> members) {
        return MemberQuote.get().filterQuote(modelId, busModelId, resourceIds, variableMap, members);
    }

    public Set<Long> filterQuoteNew(@NotNull Long modelId, @NotNull Long busModelId, @NotNull Set<Long> resourceIds, Map<Long, Long> variableMap, @NotNull List<Map<Long, Long>> members) {
        return MemberQuote.get().filterQuoteNew(modelId, busModelId, resourceIds, variableMap, members);
    }

    public Map<Long, Map<String, Set<Long>>> queryQuote(@NotNull Long resourceId) {
        return MemberQuote.get().queryQuote(resourceId);
    }

    public Map<Long, Map<Long, List<Object[]>>> queryTemplateQuote(@NotNull Set<Long> resourceIdSet) {
        return MemberQuote.get().queryTemplateQuote(resourceIdSet);
    }

    public void clearQuote(@NotNull Long modelId, @NotNull Long dimensionId, Long ... memberIds) {
        MemberQuote.get().clearQuote(modelId, dimensionId, memberIds);
    }

    public Pair<Boolean, String> checkQuoteResult(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull long memberId, MemberTypeEnum typeEnum, Map<String, Object> optMap) {
        CheckQuote checkQuote = QuoteBuilder.build((Long)modelId, (Long)dimensionId, (Long)memberId);
        Long viewId = MapUtils.getLong(optMap, (Object)"viewId", (Long)0L);
        if (viewId > 0L) {
            HashSet<Long> memberIds = new HashSet<Long>();
            memberIds.add(memberId);
            checkQuote = QuoteBuilder.build((Long)modelId, (Long)dimensionId, (Long)viewId, memberIds, (MemberTypeEnum)typeEnum);
        }
        checkQuote.setCheckChild(MapUtils.getBoolean(optMap, (Object)"checkChild", (Boolean)false).booleanValue());
        checkQuote.setOnlyCurrView(MapUtils.getBoolean(optMap, (Object)"onlyCurrView", (Boolean)false).booleanValue());
        if (MapUtils.getString(optMap, (Object)"excludeViewMember") != null) {
            checkQuote.addExclude(MemberQuoteResourceEnum.ViewMember);
        }
        checkQuote.setDataCheck(MapUtils.getBoolean(optMap, (Object)"dataCheck", (Boolean)true).booleanValue());
        QuoteCheckResult result = MemberQuote.get().checkQuoteResult(checkQuote);
        return Pair.of((Object)result.isHasQuote(), (Object)result.getMsg());
    }
}

